/*
 * Decompiled with CFR 0.152.
 */
package com.vk.sdk.api.httpClient;

import android.util.Pair;
import android.webkit.MimeTypeMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import java.util.Random;

public class VKMultipartEntity {
    private static final String VK_BOUNDARY = "Boundary(======VK_SDK_%d======)";
    private final String mBoundary = String.format(Locale.US, "Boundary(======VK_SDK_%d======)", new Random().nextInt());
    private final File[] mFiles;
    private String mType;

    public VKMultipartEntity(File[] files) {
        this.mFiles = files;
    }

    public VKMultipartEntity(File[] files, String type) {
        this.mFiles = files;
        this.mType = type;
    }

    public long getContentLength() {
        long length = 0L;
        for (int i = 0; i < this.mFiles.length; ++i) {
            File f = this.mFiles[i];
            length += f.length();
            length += (long)this.getFileDescription(f, i).length();
        }
        return length += (long)this.getBoundaryEnd().length();
    }

    public Pair<String, String> getContentType() {
        return new Pair((Object)"Content-Type", (Object)String.format("multipart/form-data; boundary=%s", this.mBoundary));
    }

    public InputStream getContent() throws IOException, IllegalStateException {
        throw new UnsupportedOperationException("Multipart form entity does not implement #getContent()");
    }

    protected String getFileDescription(File uploadFile, int i) {
        String fileName = this.mType != null && this.mType.equals("doc") ? "file" : String.format(Locale.US, "file%d", i + 1);
        String extension = MimeTypeMap.getFileExtensionFromUrl((String)uploadFile.getAbsolutePath());
        return String.format("\r\n--%s\r\n", this.mBoundary) + String.format("Content-Disposition: form-data; name=\"%s\"; filename=\"%s.%s\"\r\n", fileName, fileName, extension) + String.format("Content-Type: %s\r\n\r\n", VKMultipartEntity.getMimeType(uploadFile.getAbsolutePath()));
    }

    private String getBoundaryEnd() {
        return String.format("\r\n--%s--\r\n", this.mBoundary);
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        for (int i = 0; i < this.mFiles.length; ++i) {
            int bytesRead;
            File uploadFile = this.mFiles[i];
            outputStream.write(this.getFileDescription(uploadFile, i).getBytes("UTF-8"));
            FileInputStream reader = new FileInputStream(uploadFile);
            byte[] fileBuffer = new byte[2048];
            while ((bytesRead = reader.read(fileBuffer)) != -1) {
                outputStream.write(fileBuffer, 0, bytesRead);
            }
            reader.close();
        }
        outputStream.write(this.getBoundaryEnd().getBytes("UTF-8"));
    }

    protected static String getMimeType(String url) {
        String type = null;
        String extension = MimeTypeMap.getFileExtensionFromUrl((String)url);
        if (extension != null) {
            MimeTypeMap mime = MimeTypeMap.getSingleton();
            type = mime.getMimeTypeFromExtension(extension);
        }
        return type;
    }
}

