/*
 * Decompiled with CFR 0.152.
 */
package com.vk.sdk.api.model;

import android.os.Parcelable;
import com.vk.sdk.api.model.Identifiable;
import com.vk.sdk.api.model.VKApiModel;
import com.vk.sdk.api.model.VKAttachments;
import com.vk.sdk.api.model.VKList;
import com.vk.sdk.api.model.VKPhotoSizes;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class ParseUtils {
    private ParseUtils() {
    }

    public static boolean parseBoolean(String from) throws JSONException {
        return new JSONObject(from).optInt("response", 0) == 1;
    }

    public static boolean parseBoolean(JSONObject from, String name) {
        return from != null && from.optInt(name, 0) == 1;
    }

    public static int parseInt(JSONObject from, String name) {
        if (from == null) {
            return 0;
        }
        return from.optInt(name, 0);
    }

    public static int parseInt(String from) throws JSONException {
        if (from == null) {
            return 0;
        }
        return new JSONObject(from).optInt("response");
    }

    public static long parseLong(JSONObject from, String name) {
        if (from == null) {
            return 0L;
        }
        return from.optLong(name, 0L);
    }

    public static int[] parseIntArray(JSONArray from) {
        int[] result = new int[from.length()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = from.optInt(i);
        }
        return result;
    }

    public static JSONObject rootJSONObject(String source) throws JSONException {
        return new JSONObject(source).getJSONObject("response");
    }

    public static JSONArray rootJSONArray(String source) throws JSONException {
        return new JSONObject(source).getJSONArray("response");
    }

    public static <T> T parseViaReflection(T object, JSONObject source) throws JSONException {
        if (source.has("response")) {
            source = source.optJSONObject("response");
        }
        if (source == null) {
            return object;
        }
        for (Field field : object.getClass().getFields()) {
            field.setAccessible(true);
            String fieldName = field.getName();
            Class<?> fieldType = field.getType();
            Object value = source.opt(fieldName);
            if (value == null) continue;
            try {
                Constructor<?> constructor;
                if (fieldType.isPrimitive() && value instanceof Number) {
                    Number number = (Number)value;
                    if (fieldType.equals(Integer.TYPE)) {
                        field.setInt(object, number.intValue());
                        continue;
                    }
                    if (fieldType.equals(Long.TYPE)) {
                        field.setLong(object, number.longValue());
                        continue;
                    }
                    if (fieldType.equals(Float.TYPE)) {
                        field.setFloat(object, number.floatValue());
                        continue;
                    }
                    if (fieldType.equals(Double.TYPE)) {
                        field.setDouble(object, number.doubleValue());
                        continue;
                    }
                    if (fieldType.equals(Boolean.TYPE)) {
                        field.setBoolean(object, number.intValue() == 1);
                        continue;
                    }
                    if (fieldType.equals(Short.TYPE)) {
                        field.setShort(object, number.shortValue());
                        continue;
                    }
                    if (!fieldType.equals(Byte.TYPE)) continue;
                    field.setByte(object, number.byteValue());
                    continue;
                }
                VKList result = field.get(object);
                if (value.getClass().equals(fieldType)) {
                    result = value;
                } else if (fieldType.isArray() && value instanceof JSONArray) {
                    result = ParseUtils.parseArrayViaReflection((JSONArray)value, fieldType);
                } else if (VKPhotoSizes.class.isAssignableFrom(fieldType) && value instanceof JSONArray) {
                    constructor = fieldType.getConstructor(JSONArray.class);
                    result = constructor.newInstance((JSONArray)value);
                } else if (VKAttachments.class.isAssignableFrom(fieldType) && value instanceof JSONArray) {
                    constructor = fieldType.getConstructor(JSONArray.class);
                    result = constructor.newInstance((JSONArray)value);
                } else if (VKList.class.equals(fieldType)) {
                    ParameterizedType genericTypes = (ParameterizedType)field.getGenericType();
                    Class genericType = (Class)genericTypes.getActualTypeArguments()[0];
                    if (VKApiModel.class.isAssignableFrom(genericType) && Parcelable.class.isAssignableFrom(genericType) && Identifiable.class.isAssignableFrom(genericType)) {
                        if (value instanceof JSONArray) {
                            result = new VKList((JSONArray)value, genericType);
                        } else if (value instanceof JSONObject) {
                            result = new VKList((JSONObject)value, genericType);
                        }
                    }
                } else if (VKApiModel.class.isAssignableFrom(fieldType) && value instanceof JSONObject) {
                    result = ((VKApiModel)fieldType.newInstance()).parse((JSONObject)value);
                }
                field.set(object, result);
            }
            catch (InstantiationException e) {
                throw new JSONException(e.getMessage());
            }
            catch (IllegalAccessException e) {
                throw new JSONException(e.getMessage());
            }
            catch (NoSuchMethodException e) {
                throw new JSONException(e.getMessage());
            }
            catch (InvocationTargetException e) {
                throw new JSONException(e.getMessage());
            }
            catch (NoSuchMethodError e) {
                throw new JSONException(e.getMessage());
            }
        }
        return object;
    }

    private static Object parseArrayViaReflection(JSONArray array, Class arrayClass) throws JSONException {
        Object result = Array.newInstance(arrayClass.getComponentType(), array.length());
        Class<?> subType = arrayClass.getComponentType();
        for (int i = 0; i < array.length(); ++i) {
            try {
                Object item = array.opt(i);
                if (VKApiModel.class.isAssignableFrom(subType) && item instanceof JSONObject) {
                    VKApiModel model = (VKApiModel)subType.newInstance();
                    item = model.parse((JSONObject)item);
                }
                Array.set(result, i, item);
                continue;
            }
            catch (InstantiationException e) {
                throw new JSONException(e.getMessage());
            }
            catch (IllegalAccessException e) {
                throw new JSONException(e.getMessage());
            }
            catch (IllegalArgumentException e) {
                throw new JSONException(e.getMessage());
            }
        }
        return result;
    }
}

