/*
 * Decompiled with CFR 0.152.
 */
package com.vk.sdk.api.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.vk.sdk.api.model.Identifiable;
import com.vk.sdk.api.model.ParseUtils;
import com.vk.sdk.api.model.VKApiModel;
import com.vk.sdk.api.model.VKAttachments;
import org.json.JSONObject;

public class VKApiComment
extends VKApiModel
implements Identifiable,
Parcelable {
    public int id;
    public int from_id;
    public long date;
    public String text;
    public int reply_to_user;
    public int reply_to_comment;
    public int likes;
    public boolean user_likes;
    public boolean can_like;
    public VKAttachments attachments = new VKAttachments();
    public static Parcelable.Creator<VKApiComment> CREATOR = new Parcelable.Creator<VKApiComment>(){

        public VKApiComment createFromParcel(Parcel source) {
            return new VKApiComment(source);
        }

        public VKApiComment[] newArray(int size) {
            return new VKApiComment[size];
        }
    };

    public VKApiComment(JSONObject from) {
        this.parse(from);
    }

    @Override
    public VKApiComment parse(JSONObject from) {
        this.id = from.optInt("id");
        this.from_id = from.optInt("from_id");
        this.date = from.optLong("date");
        this.text = from.optString("text");
        this.reply_to_user = from.optInt("reply_to_user");
        this.reply_to_comment = from.optInt("reply_to_comment");
        this.attachments.fill(from.optJSONArray("attachments"));
        JSONObject likes = from.optJSONObject("likes");
        this.likes = ParseUtils.parseInt(likes, "count");
        this.user_likes = ParseUtils.parseBoolean(likes, "user_likes");
        this.can_like = ParseUtils.parseBoolean(likes, "can_like");
        return this;
    }

    public VKApiComment(Parcel in) {
        this.id = in.readInt();
        this.from_id = in.readInt();
        this.date = in.readLong();
        this.text = in.readString();
        this.reply_to_user = in.readInt();
        this.reply_to_comment = in.readInt();
        this.likes = in.readInt();
        this.user_likes = in.readByte() != 0;
        this.can_like = in.readByte() != 0;
        this.attachments = (VKAttachments)in.readParcelable(VKAttachments.class.getClassLoader());
    }

    public VKApiComment() {
    }

    @Override
    public int getId() {
        return this.id;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.id);
        dest.writeInt(this.from_id);
        dest.writeLong(this.date);
        dest.writeString(this.text);
        dest.writeInt(this.reply_to_user);
        dest.writeInt(this.reply_to_comment);
        dest.writeInt(this.likes);
        dest.writeByte(this.user_likes ? (byte)1 : 0);
        dest.writeByte(this.can_like ? (byte)1 : 0);
        dest.writeParcelable((Parcelable)this.attachments, flags);
    }
}

