/*
 * Decompiled with CFR 0.152.
 */
package com.vk.sdk.api.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.vk.sdk.api.model.Identifiable;
import com.vk.sdk.api.model.ParseUtils;
import com.vk.sdk.api.model.VKApiAudio;
import com.vk.sdk.api.model.VKApiCity;
import com.vk.sdk.api.model.VKApiCommunity;
import com.vk.sdk.api.model.VKApiCountry;
import com.vk.sdk.api.model.VKApiModel;
import com.vk.sdk.api.model.VKApiPhotoSize;
import com.vk.sdk.api.model.VKApiPlace;
import com.vk.sdk.api.model.VKApiUser;
import com.vk.sdk.api.model.VKList;
import com.vk.sdk.api.model.VKPhotoSizes;
import org.json.JSONObject;

public class VKApiCommunityFull
extends VKApiCommunity
implements Parcelable {
    public static final String CITY = "city";
    public static final String COUNTRY = "country";
    public static final String PLACE = "place";
    public static final String DESCRIPTION = "description";
    public static final String WIKI_PAGE = "wiki_page";
    public static final String MEMBERS_COUNT = "members_count";
    public static final String COUNTERS = "counters";
    public static final String START_DATE = "start_date";
    public static final String END_DATE = "end_date";
    public static final String CAN_POST = "can_post";
    public static final String CAN_SEE_ALL_POSTS = "can_see_all_posts";
    public static final String STATUS = "status";
    public static final String CONTACTS = "contacts";
    public static final String LINKS = "links";
    public static final String FIXED_POST = "fixed_post";
    public static final String VERIFIED = "verified";
    public static final String BLACKLISTED = "blacklisted";
    public static final String SITE = "site";
    public static final String ACTIVITY = "activity";
    public VKApiCity city;
    public VKApiCountry country;
    public VKApiAudio status_audio;
    public VKApiPlace place;
    public String description;
    public String wiki_page;
    public int members_count;
    public Counters counters;
    public long start_date;
    public long end_date;
    public boolean can_post;
    public boolean can_see_all_posts;
    public String status;
    public VKList<Contact> contacts;
    public VKList<Link> links;
    public int fixed_post;
    public boolean verified;
    public String site;
    public boolean blacklisted;
    public static Parcelable.Creator<VKApiCommunityFull> CREATOR = new Parcelable.Creator<VKApiCommunityFull>(){

        public VKApiCommunityFull createFromParcel(Parcel source) {
            return new VKApiCommunityFull(source);
        }

        public VKApiCommunityFull[] newArray(int size) {
            return new VKApiCommunityFull[size];
        }
    };

    public VKApiCommunityFull() {
    }

    @Override
    public VKApiCommunityFull parse(JSONObject jo) {
        JSONObject place;
        JSONObject country;
        super.parse(jo);
        JSONObject city = jo.optJSONObject(CITY);
        if (city != null) {
            this.city = new VKApiCity().parse(city);
        }
        if ((country = jo.optJSONObject(COUNTRY)) != null) {
            this.country = new VKApiCountry().parse(country);
        }
        if ((place = jo.optJSONObject(PLACE)) != null) {
            this.place = new VKApiPlace().parse(place);
        }
        this.description = jo.optString(DESCRIPTION);
        this.wiki_page = jo.optString(WIKI_PAGE);
        this.members_count = jo.optInt(MEMBERS_COUNT);
        JSONObject counters = jo.optJSONObject(COUNTERS);
        if (counters != null) {
            this.counters = new Counters(counters);
        }
        this.start_date = jo.optLong(START_DATE);
        this.end_date = jo.optLong(END_DATE);
        this.can_post = ParseUtils.parseBoolean(jo, CAN_POST);
        this.can_see_all_posts = ParseUtils.parseBoolean(jo, CAN_SEE_ALL_POSTS);
        this.status = jo.optString(STATUS);
        JSONObject status_audio = jo.optJSONObject("status_audio");
        if (status_audio != null) {
            this.status_audio = new VKApiAudio().parse(status_audio);
        }
        this.contacts = new VKList<Contact>(jo.optJSONArray(CONTACTS), Contact.class);
        this.links = new VKList<Link>(jo.optJSONArray(LINKS), Link.class);
        this.fixed_post = jo.optInt(FIXED_POST);
        this.verified = ParseUtils.parseBoolean(jo, VERIFIED);
        this.blacklisted = ParseUtils.parseBoolean(jo, VERIFIED);
        this.site = jo.optString(SITE);
        return this;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeParcelable((Parcelable)this.city, flags);
        dest.writeParcelable((Parcelable)this.country, flags);
        dest.writeParcelable((Parcelable)this.status_audio, flags);
        dest.writeParcelable((Parcelable)this.place, flags);
        dest.writeString(this.description);
        dest.writeString(this.wiki_page);
        dest.writeInt(this.members_count);
        dest.writeParcelable((Parcelable)this.counters, flags);
        dest.writeLong(this.start_date);
        dest.writeLong(this.end_date);
        dest.writeByte(this.can_post ? (byte)1 : 0);
        dest.writeByte(this.can_see_all_posts ? (byte)1 : 0);
        dest.writeString(this.status);
        dest.writeParcelable(this.contacts, flags);
        dest.writeParcelable(this.links, flags);
        dest.writeInt(this.fixed_post);
        dest.writeByte(this.verified ? (byte)1 : 0);
        dest.writeString(this.site);
        dest.writeByte(this.blacklisted ? (byte)1 : 0);
    }

    public VKApiCommunityFull(Parcel in) {
        super(in);
        this.city = (VKApiCity)in.readParcelable(VKApiCity.class.getClassLoader());
        this.country = (VKApiCountry)in.readParcelable(VKApiCountry.class.getClassLoader());
        this.status_audio = (VKApiAudio)in.readParcelable(VKApiAudio.class.getClassLoader());
        this.place = (VKApiPlace)in.readParcelable(VKApiPlace.class.getClassLoader());
        this.description = in.readString();
        this.wiki_page = in.readString();
        this.members_count = in.readInt();
        this.counters = (Counters)in.readParcelable(Counters.class.getClassLoader());
        this.start_date = in.readLong();
        this.end_date = in.readLong();
        this.can_post = in.readByte() != 0;
        this.can_see_all_posts = in.readByte() != 0;
        this.status = in.readString();
        this.contacts = (VKList)in.readParcelable(VKList.class.getClassLoader());
        this.links = (VKList)in.readParcelable(VKList.class.getClassLoader());
        this.fixed_post = in.readInt();
        this.verified = in.readByte() != 0;
        this.site = in.readString();
        this.blacklisted = in.readByte() != 0;
    }

    public static class Link
    extends VKApiModel
    implements Parcelable,
    Identifiable {
        public String url;
        public String name;
        public String desc;
        public VKPhotoSizes photo = new VKPhotoSizes();
        public static Parcelable.Creator<Link> CREATOR = new Parcelable.Creator<Link>(){

            public Link createFromParcel(Parcel source) {
                return new Link(source);
            }

            public Link[] newArray(int size) {
                return new Link[size];
            }
        };

        public Link(JSONObject from) {
            this.parse(from);
        }

        @Override
        public Link parse(JSONObject from) {
            String photo_100;
            this.url = from.optString("url");
            this.name = from.optString("name");
            this.desc = from.optString("desc");
            String photo_50 = from.optString("photo_50");
            if (!TextUtils.isEmpty((CharSequence)photo_50)) {
                this.photo.add(VKApiPhotoSize.create(photo_50, 50));
            }
            if (!TextUtils.isEmpty((CharSequence)(photo_100 = from.optString("photo_100")))) {
                this.photo.add(VKApiPhotoSize.create(photo_100, 100));
            }
            this.photo.sort();
            return this;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.url);
            dest.writeString(this.name);
            dest.writeString(this.desc);
            dest.writeParcelable((Parcelable)this.photo, flags);
        }

        public Link(Parcel in) {
            this.url = in.readString();
            this.name = in.readString();
            this.desc = in.readString();
            this.photo = (VKPhotoSizes)in.readParcelable(null);
        }

        @Override
        public int getId() {
            return 0;
        }
    }

    public static class Contact
    extends VKApiModel
    implements Parcelable,
    Identifiable {
        public int user_id;
        public VKApiUser user;
        public String email;
        public String desc;
        public static Parcelable.Creator<Contact> CREATOR = new Parcelable.Creator<Contact>(){

            public Contact createFromParcel(Parcel source) {
                return new Contact(source);
            }

            public Contact[] newArray(int size) {
                return new Contact[size];
            }
        };

        public Contact(JSONObject from) {
            this.parse(from);
        }

        @Override
        public Contact parse(JSONObject from) {
            this.user_id = from.optInt("user_id");
            this.desc = from.optString("desc");
            this.email = from.optString("email");
            return this;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.user_id);
            dest.writeString(this.desc);
        }

        private Contact(Parcel in) {
            this.user_id = in.readInt();
            this.desc = in.readString();
        }

        @Override
        public int getId() {
            return this.user_id;
        }

        public String toString() {
            if (this.user != null) {
                return this.user.toString();
            }
            if (this.email != null) {
                return this.email;
            }
            return null;
        }
    }

    public static class Counters
    implements Parcelable {
        public static final int NO_COUNTER = -1;
        public int photos = -1;
        public int albums = -1;
        public int audios = -1;
        public int videos = -1;
        public int topics = -1;
        public int docs = -1;
        public static Parcelable.Creator<Counters> CREATOR = new Parcelable.Creator<Counters>(){

            public Counters createFromParcel(Parcel source) {
                return new Counters(source);
            }

            public Counters[] newArray(int size) {
                return new Counters[size];
            }
        };

        public Counters(JSONObject from) {
            this.photos = from.optInt("photos", this.photos);
            this.albums = from.optInt("albums", this.albums);
            this.audios = from.optInt("audios", this.audios);
            this.videos = from.optInt("videos", this.videos);
            this.topics = from.optInt("topics", this.topics);
            this.docs = from.optInt("docs", this.docs);
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.photos);
            dest.writeInt(this.albums);
            dest.writeInt(this.audios);
            dest.writeInt(this.videos);
            dest.writeInt(this.topics);
            dest.writeInt(this.docs);
        }

        private Counters(Parcel in) {
            this.photos = in.readInt();
            this.albums = in.readInt();
            this.audios = in.readInt();
            this.videos = in.readInt();
            this.topics = in.readInt();
            this.docs = in.readInt();
        }
    }
}

