/*
 * Decompiled with CFR 0.152.
 */
package com.vk.sdk.api.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.vk.sdk.api.model.Identifiable;
import com.vk.sdk.api.model.VKApiPhotoSize;
import com.vk.sdk.api.model.VKAttachments;
import com.vk.sdk.api.model.VKPhotoSizes;
import org.json.JSONException;
import org.json.JSONObject;

public class VKApiDocument
extends VKAttachments.VKApiAttachment
implements Parcelable,
Identifiable {
    public int id;
    public int owner_id;
    public String title;
    public long size;
    public String ext;
    public String url;
    public String photo_100;
    public String photo_130;
    public VKPhotoSizes photo = new VKPhotoSizes();
    public String access_key;
    public long date = 0L;
    private boolean mIsGif;
    private boolean mIsImage;
    public static Parcelable.Creator<VKApiDocument> CREATOR = new Parcelable.Creator<VKApiDocument>(){

        public VKApiDocument createFromParcel(Parcel source) {
            return new VKApiDocument(source);
        }

        public VKApiDocument[] newArray(int size) {
            return new VKApiDocument[size];
        }
    };

    public VKApiDocument(JSONObject from) throws JSONException {
        this.parse(from);
    }

    @Override
    public VKApiDocument parse(JSONObject jo) {
        this.id = jo.optInt("id");
        this.owner_id = jo.optInt("owner_id");
        this.title = jo.optString("title");
        this.size = jo.optLong("size");
        this.ext = jo.optString("ext");
        this.url = jo.optString("url");
        this.access_key = jo.optString("access_key");
        this.date = jo.optLong("date", 0L) * 1000L;
        this.photo_100 = jo.optString("photo_100");
        if (!TextUtils.isEmpty((CharSequence)this.photo_100)) {
            this.photo.add(VKApiPhotoSize.create(this.photo_100, 100, 75));
        }
        this.photo_130 = jo.optString("photo_130");
        if (!TextUtils.isEmpty((CharSequence)this.photo_130)) {
            this.photo.add(VKApiPhotoSize.create(this.photo_130, 130, 100));
        }
        this.photo.sort();
        return this;
    }

    public VKApiDocument(Parcel in) {
        this.id = in.readInt();
        this.owner_id = in.readInt();
        this.title = in.readString();
        this.size = in.readLong();
        this.ext = in.readString();
        this.url = in.readString();
        this.date = in.readLong();
        this.photo_100 = in.readString();
        this.photo_130 = in.readString();
        this.photo = (VKPhotoSizes)in.readParcelable(VKPhotoSizes.class.getClassLoader());
        this.access_key = in.readString();
        this.mIsImage = in.readByte() != 0;
        this.mIsGif = in.readByte() != 0;
    }

    public VKApiDocument() {
    }

    public boolean isImage() {
        this.mIsImage = this.mIsImage || "jpg".equals(this.ext) || "jpeg".equals(this.ext) || "png".equals(this.ext) || "bmp".equals(this.ext);
        return this.mIsImage;
    }

    public boolean isGif() {
        this.mIsGif = this.mIsGif || "gif".equals(this.ext);
        return this.mIsGif;
    }

    @Override
    public int getId() {
        return this.id;
    }

    public String toString() {
        return this.title;
    }

    @Override
    public CharSequence toAttachmentString() {
        StringBuilder result = new StringBuilder("doc").append(this.owner_id).append('_').append(this.id);
        if (!TextUtils.isEmpty((CharSequence)this.access_key)) {
            result.append('_');
            result.append(this.access_key);
        }
        return result;
    }

    @Override
    public String getType() {
        return "doc";
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.id);
        dest.writeInt(this.owner_id);
        dest.writeString(this.title);
        dest.writeLong(this.size);
        dest.writeString(this.ext);
        dest.writeString(this.url);
        dest.writeLong(this.date);
        dest.writeString(this.photo_100);
        dest.writeString(this.photo_130);
        dest.writeParcelable((Parcelable)this.photo, flags);
        dest.writeString(this.access_key);
        dest.writeByte(this.mIsImage ? (byte)1 : 0);
        dest.writeByte(this.mIsGif ? (byte)1 : 0);
    }
}

