/*
 * Decompiled with CFR 0.152.
 */
package com.vk.sdk.api.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.vk.sdk.api.model.Identifiable;
import com.vk.sdk.api.model.ParseUtils;
import com.vk.sdk.api.model.VKApiModel;
import com.vk.sdk.api.model.VKAttachments;
import com.vk.sdk.api.model.VKList;
import org.json.JSONException;
import org.json.JSONObject;

public class VKApiMessage
extends VKApiModel
implements Identifiable,
Parcelable {
    public int id;
    public int user_id;
    public long date;
    public boolean read_state;
    public boolean out;
    public String title;
    public String body;
    public VKAttachments attachments = new VKAttachments();
    public VKList<VKApiMessage> fwd_messages;
    public boolean emoji;
    public boolean deleted;
    public static Parcelable.Creator<VKApiMessage> CREATOR = new Parcelable.Creator<VKApiMessage>(){

        public VKApiMessage createFromParcel(Parcel source) {
            return new VKApiMessage(source);
        }

        public VKApiMessage[] newArray(int size) {
            return new VKApiMessage[size];
        }
    };

    public VKApiMessage(JSONObject from) throws JSONException {
        this.parse(from);
    }

    @Override
    public VKApiMessage parse(JSONObject source) throws JSONException {
        this.id = source.optInt("id");
        this.user_id = source.optInt("user_id");
        this.date = source.optLong("date");
        this.read_state = ParseUtils.parseBoolean(source, "read_state");
        this.out = ParseUtils.parseBoolean(source, "out");
        this.title = source.optString("title");
        this.body = source.optString("body");
        this.attachments.fill(source.optJSONArray("attachments"));
        this.fwd_messages = new VKList<VKApiMessage>(source.optJSONArray("fwd_messages"), VKApiMessage.class);
        this.emoji = ParseUtils.parseBoolean(source, "emoji");
        this.deleted = ParseUtils.parseBoolean(source, "deleted");
        return this;
    }

    public VKApiMessage(Parcel in) {
        this.id = in.readInt();
        this.user_id = in.readInt();
        this.date = in.readLong();
        this.read_state = in.readByte() != 0;
        this.out = in.readByte() != 0;
        this.title = in.readString();
        this.body = in.readString();
        this.attachments = (VKAttachments)in.readParcelable(VKAttachments.class.getClassLoader());
        this.fwd_messages = (VKList)in.readParcelable(VKList.class.getClassLoader());
        this.emoji = in.readByte() != 0;
        this.deleted = in.readByte() != 0;
    }

    public VKApiMessage() {
    }

    @Override
    public int getId() {
        return this.id;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.id);
        dest.writeInt(this.user_id);
        dest.writeLong(this.date);
        dest.writeByte(this.read_state ? (byte)1 : 0);
        dest.writeByte(this.out ? (byte)1 : 0);
        dest.writeString(this.title);
        dest.writeString(this.body);
        dest.writeParcelable((Parcelable)this.attachments, flags);
        dest.writeParcelable(this.fwd_messages, flags);
        dest.writeByte(this.emoji ? (byte)1 : 0);
        dest.writeByte(this.deleted ? (byte)1 : 0);
    }
}

