/*
 * Decompiled with CFR 0.152.
 */
package com.vk.sdk.api.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.vk.sdk.api.model.Identifiable;
import com.vk.sdk.api.model.ParseUtils;
import com.vk.sdk.api.model.VKApiPhotoSize;
import com.vk.sdk.api.model.VKAttachments;
import com.vk.sdk.api.model.VKPhotoSizes;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class VKApiPhoto
extends VKAttachments.VKApiAttachment
implements Parcelable,
Identifiable {
    public int id;
    public int album_id;
    public int owner_id;
    public int width;
    public int height;
    public String text;
    public long date;
    public String photo_75;
    public String photo_130;
    public String photo_604;
    public String photo_807;
    public String photo_1280;
    public String photo_2560;
    public VKPhotoSizes src = new VKPhotoSizes();
    public boolean user_likes;
    public boolean can_comment;
    public int likes;
    public int comments;
    public int tags;
    public String access_key;
    public static Parcelable.Creator<VKApiPhoto> CREATOR = new Parcelable.Creator<VKApiPhoto>(){

        public VKApiPhoto createFromParcel(Parcel source) {
            return new VKApiPhoto(source);
        }

        public VKApiPhoto[] newArray(int size) {
            return new VKApiPhoto[size];
        }
    };

    public VKApiPhoto(JSONObject from) throws JSONException {
        this.parse(from);
    }

    @Override
    public VKApiPhoto parse(JSONObject from) {
        this.album_id = from.optInt("album_id");
        this.date = from.optLong("date");
        this.height = from.optInt("height");
        this.width = from.optInt("width");
        this.owner_id = from.optInt("owner_id");
        this.id = from.optInt("id");
        this.text = from.optString("text");
        this.access_key = from.optString("access_key");
        this.photo_75 = from.optString("photo_75");
        this.photo_130 = from.optString("photo_130");
        this.photo_604 = from.optString("photo_604");
        this.photo_807 = from.optString("photo_807");
        this.photo_1280 = from.optString("photo_1280");
        this.photo_2560 = from.optString("photo_2560");
        JSONObject likes = from.optJSONObject("likes");
        this.likes = ParseUtils.parseInt(likes, "count");
        this.user_likes = ParseUtils.parseBoolean(likes, "user_likes");
        this.comments = ParseUtils.parseInt(from.optJSONObject("comments"), "count");
        this.tags = ParseUtils.parseInt(from.optJSONObject("tags"), "count");
        this.can_comment = ParseUtils.parseBoolean(from, "can_comment");
        this.src.setOriginalDimension(this.width, this.height);
        JSONArray photo_sizes = from.optJSONArray("sizes");
        if (photo_sizes != null) {
            this.src.fill(photo_sizes);
        } else {
            if (!TextUtils.isEmpty((CharSequence)this.photo_75)) {
                this.src.add(VKApiPhotoSize.create(this.photo_75, 's', this.width, this.height));
            }
            if (!TextUtils.isEmpty((CharSequence)this.photo_130)) {
                this.src.add(VKApiPhotoSize.create(this.photo_130, 'm', this.width, this.height));
            }
            if (!TextUtils.isEmpty((CharSequence)this.photo_604)) {
                this.src.add(VKApiPhotoSize.create(this.photo_604, 'x', this.width, this.height));
            }
            if (!TextUtils.isEmpty((CharSequence)this.photo_807)) {
                this.src.add(VKApiPhotoSize.create(this.photo_807, 'y', this.width, this.height));
            }
            if (!TextUtils.isEmpty((CharSequence)this.photo_1280)) {
                this.src.add(VKApiPhotoSize.create(this.photo_1280, 'z', this.width, this.height));
            }
            if (!TextUtils.isEmpty((CharSequence)this.photo_2560)) {
                this.src.add(VKApiPhotoSize.create(this.photo_2560, 'w', this.width, this.height));
            }
            this.src.sort();
        }
        return this;
    }

    public VKApiPhoto(Parcel in) {
        this.id = in.readInt();
        this.album_id = in.readInt();
        this.owner_id = in.readInt();
        this.width = in.readInt();
        this.height = in.readInt();
        this.text = in.readString();
        this.date = in.readLong();
        this.src = (VKPhotoSizes)in.readParcelable(VKPhotoSizes.class.getClassLoader());
        this.photo_75 = in.readString();
        this.photo_130 = in.readString();
        this.photo_604 = in.readString();
        this.photo_807 = in.readString();
        this.photo_1280 = in.readString();
        this.photo_2560 = in.readString();
        this.user_likes = in.readByte() != 0;
        this.can_comment = in.readByte() != 0;
        this.likes = in.readInt();
        this.comments = in.readInt();
        this.tags = in.readInt();
        this.access_key = in.readString();
    }

    public VKApiPhoto(String photoAttachmentString) {
        if (photoAttachmentString.startsWith("photo")) {
            photoAttachmentString = photoAttachmentString.substring("photo".length());
            String[] ids = photoAttachmentString.split("_");
            this.owner_id = Integer.parseInt(ids[0]);
            this.id = Integer.parseInt(ids[1]);
        }
    }

    public VKApiPhoto() {
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public CharSequence toAttachmentString() {
        StringBuilder result = new StringBuilder("photo").append(this.owner_id).append('_').append(this.id);
        if (!TextUtils.isEmpty((CharSequence)this.access_key)) {
            result.append('_');
            result.append(this.access_key);
        }
        return result;
    }

    @Override
    public String getType() {
        return "photo";
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.id);
        dest.writeInt(this.album_id);
        dest.writeInt(this.owner_id);
        dest.writeInt(this.width);
        dest.writeInt(this.height);
        dest.writeString(this.text);
        dest.writeLong(this.date);
        dest.writeParcelable((Parcelable)this.src, flags);
        dest.writeString(this.photo_75);
        dest.writeString(this.photo_130);
        dest.writeString(this.photo_604);
        dest.writeString(this.photo_807);
        dest.writeString(this.photo_1280);
        dest.writeString(this.photo_2560);
        dest.writeByte(this.user_likes ? (byte)1 : 0);
        dest.writeByte(this.can_comment ? (byte)1 : 0);
        dest.writeInt(this.likes);
        dest.writeInt(this.comments);
        dest.writeInt(this.tags);
        dest.writeString(this.access_key);
    }
}

