/*
 * Decompiled with CFR 0.152.
 */
package com.vk.sdk.api.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.vk.sdk.api.model.Identifiable;
import com.vk.sdk.api.model.ParseUtils;
import com.vk.sdk.api.model.VKApiPhotoSize;
import com.vk.sdk.api.model.VKAttachments;
import com.vk.sdk.api.model.VKPhotoSizes;
import com.vk.sdk.api.model.VKPrivacy;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class VKApiPhotoAlbum
extends VKAttachments.VKApiAttachment
implements Parcelable,
Identifiable {
    public static final String COVER_S = "http://vk.com/images/s_noalbum.png";
    public static final String COVER_M = "http://vk.com/images/m_noalbum.png";
    public static final String COVER_X = "http://vk.com/images/x_noalbum.png";
    public int id;
    public String title;
    public int size;
    public int privacy;
    public String description;
    public int owner_id;
    public boolean can_upload;
    public long updated;
    public long created;
    public int thumb_id;
    public String thumb_src;
    public VKPhotoSizes photo = new VKPhotoSizes();
    public static Parcelable.Creator<VKApiPhotoAlbum> CREATOR = new Parcelable.Creator<VKApiPhotoAlbum>(){

        public VKApiPhotoAlbum createFromParcel(Parcel source) {
            return new VKApiPhotoAlbum(source);
        }

        public VKApiPhotoAlbum[] newArray(int size) {
            return new VKApiPhotoAlbum[size];
        }
    };

    public VKApiPhotoAlbum(JSONObject from) throws JSONException {
        this.parse(from);
    }

    @Override
    public VKApiPhotoAlbum parse(JSONObject from) {
        this.id = from.optInt("id");
        this.thumb_id = from.optInt("thumb_id");
        this.owner_id = from.optInt("owner_id");
        this.title = from.optString("title");
        this.description = from.optString("description");
        this.created = from.optLong("created");
        this.updated = from.optLong("updated");
        this.size = from.optInt("size");
        this.can_upload = ParseUtils.parseBoolean(from, "can_upload");
        this.thumb_src = from.optString("thumb_src");
        this.privacy = from.has("privacy") ? from.optInt("privacy") : VKPrivacy.parsePrivacy(from.optJSONObject("privacy_view"));
        JSONArray sizes = from.optJSONArray("sizes");
        if (sizes != null) {
            this.photo.fill(sizes);
        } else {
            this.photo.add(VKApiPhotoSize.create(COVER_S, 75, 55));
            this.photo.add(VKApiPhotoSize.create(COVER_M, 130, 97));
            this.photo.add(VKApiPhotoSize.create(COVER_X, 432, 249));
            this.photo.sort();
        }
        return this;
    }

    public VKApiPhotoAlbum(Parcel in) {
        this.id = in.readInt();
        this.title = in.readString();
        this.size = in.readInt();
        this.privacy = in.readInt();
        this.description = in.readString();
        this.owner_id = in.readInt();
        this.can_upload = in.readByte() != 0;
        this.updated = in.readLong();
        this.created = in.readLong();
        this.thumb_id = in.readInt();
        this.thumb_src = in.readString();
        this.photo = (VKPhotoSizes)in.readParcelable(VKPhotoSizes.class.getClassLoader());
    }

    public VKApiPhotoAlbum() {
    }

    public boolean isClosed() {
        return this.privacy != 0;
    }

    @Override
    public int getId() {
        return this.id;
    }

    public String toString() {
        return this.title;
    }

    @Override
    public CharSequence toAttachmentString() {
        return new StringBuilder("album").append(this.owner_id).append('_').append(this.id);
    }

    @Override
    public String getType() {
        return "album";
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.id);
        dest.writeString(this.title);
        dest.writeInt(this.size);
        dest.writeInt(this.privacy);
        dest.writeString(this.description);
        dest.writeInt(this.owner_id);
        dest.writeByte(this.can_upload ? (byte)1 : 0);
        dest.writeLong(this.updated);
        dest.writeLong(this.created);
        dest.writeInt(this.thumb_id);
        dest.writeString(this.thumb_src);
        dest.writeParcelable((Parcelable)this.photo, flags);
    }
}

