/*
 * Decompiled with CFR 0.152.
 */
package com.vk.sdk.api.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.vk.sdk.api.model.Identifiable;
import com.vk.sdk.api.model.VKApiModel;
import org.json.JSONException;
import org.json.JSONObject;

public class VKApiPhotoSize
extends VKApiModel
implements Comparable<VKApiPhotoSize>,
Parcelable,
Identifiable {
    public static final char S = 's';
    public static final char M = 'm';
    public static final char X = 'x';
    public static final char Y = 'y';
    public static final char O = 'o';
    public static final char P = 'p';
    public static final char Q = 'q';
    public static final char Z = 'z';
    public static final char W = 'w';
    public String src;
    public int width;
    public int height;
    public char type;
    public static Parcelable.Creator<VKApiPhotoSize> CREATOR = new Parcelable.Creator<VKApiPhotoSize>(){

        public VKApiPhotoSize createFromParcel(Parcel source) {
            return new VKApiPhotoSize(source);
        }

        public VKApiPhotoSize[] newArray(int size) {
            return new VKApiPhotoSize[size];
        }
    };

    private VKApiPhotoSize() {
    }

    private VKApiPhotoSize(Parcel in) {
        this.src = in.readString();
        this.width = in.readInt();
        this.height = in.readInt();
        this.type = (char)in.readInt();
    }

    @Override
    public int compareTo(VKApiPhotoSize another) {
        return this.width < another.width ? -1 : (this.width == another.width ? 0 : 1);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.src);
        dest.writeInt(this.width);
        dest.writeInt(this.height);
        dest.writeInt((int)this.type);
    }

    @Override
    public int getId() {
        return 0;
    }

    public VKApiPhotoSize(JSONObject from) throws JSONException {
        VKApiPhotoSize.parse(from, 0, 0);
    }

    public static VKApiPhotoSize parse(JSONObject source, int originalWidth, int originalHeight) {
        VKApiPhotoSize result = new VKApiPhotoSize();
        result.src = source.optString("src");
        result.width = source.optInt("width");
        result.height = source.optInt("height");
        String type = source.optString("type");
        if (!TextUtils.isEmpty((CharSequence)type)) {
            result.type = type.charAt(0);
        }
        if (result.width == 0 || result.height == 0) {
            VKApiPhotoSize.fillDimensions(result, originalWidth, originalHeight);
        }
        return result;
    }

    private static void fillDimensions(VKApiPhotoSize result, int originalWidth, int originalHeight) {
        float ratio = (float)originalWidth / (float)originalHeight;
        switch (result.type) {
            case 's': {
                VKApiPhotoSize.fillDimensionSMXY(result, ratio, Math.min(originalWidth, 75));
                break;
            }
            case 'm': {
                VKApiPhotoSize.fillDimensionSMXY(result, ratio, Math.min(originalWidth, 130));
                break;
            }
            case 'x': {
                VKApiPhotoSize.fillDimensionSMXY(result, ratio, Math.min(originalWidth, 604));
                break;
            }
            case 'y': {
                VKApiPhotoSize.fillDimensionSMXY(result, ratio, Math.min(originalWidth, 807));
                break;
            }
            case 'o': {
                VKApiPhotoSize.fillDimensionOPQ(result, ratio, Math.min(originalWidth, 130));
                break;
            }
            case 'p': {
                VKApiPhotoSize.fillDimensionOPQ(result, ratio, Math.min(originalWidth, 200));
                break;
            }
            case 'q': {
                VKApiPhotoSize.fillDimensionOPQ(result, ratio, Math.min(originalWidth, 320));
                break;
            }
            case 'z': {
                VKApiPhotoSize.fillDimensionZW(result, ratio, Math.min(originalWidth, 1280), Math.min(originalHeight, 1024));
                break;
            }
            case 'w': {
                VKApiPhotoSize.fillDimensionZW(result, ratio, Math.min(originalWidth, 2560), Math.min(originalHeight, 2048));
            }
        }
    }

    private static void fillDimensionSMXY(VKApiPhotoSize result, float ratio, int width) {
        result.width = width;
        result.height = (int)Math.ceil((float)result.width / ratio);
    }

    private static void fillDimensionOPQ(VKApiPhotoSize result, float ratio, int width) {
        VKApiPhotoSize.fillDimensionSMXY(result, Math.min(1.5f, ratio), width);
    }

    private static void fillDimensionZW(VKApiPhotoSize result, float ratio, int allowedWidth, int allowedHeight) {
        if (ratio > 1.0f) {
            result.width = allowedWidth;
            result.height = (int)((float)result.width / ratio);
        } else {
            result.height = allowedHeight;
            result.width = (int)((float)result.height * ratio);
        }
    }

    public static VKApiPhotoSize create(String url, int width, int height) {
        VKApiPhotoSize result = new VKApiPhotoSize();
        result.src = url;
        result.width = width;
        result.height = height;
        float ratio = (float)width / (float)height;
        if (width <= 75) {
            result.type = (char)115;
        } else if (width <= 130) {
            result.type = (char)(ratio <= 1.5f ? 111 : 109);
        } else if (width <= 200 && ratio <= 1.5f) {
            result.type = (char)112;
        } else if (width <= 320 && ratio <= 1.5f) {
            result.type = (char)113;
        } else if (width <= 604) {
            result.type = (char)120;
        } else if (width <= 807) {
            result.type = (char)121;
        } else if (width <= 1280 && height <= 1024) {
            result.type = (char)122;
        } else if (width <= 2560 && height <= 2048) {
            result.type = (char)119;
        }
        return result;
    }

    public static VKApiPhotoSize create(String url, char type, int originalWidth, int originalHeight) {
        VKApiPhotoSize result = new VKApiPhotoSize();
        result.src = url;
        result.type = type;
        VKApiPhotoSize.fillDimensions(result, originalWidth, originalHeight);
        return result;
    }

    public static VKApiPhotoSize create(String url, int dimension) {
        return VKApiPhotoSize.create(url, dimension, dimension);
    }
}

