/*
 * Decompiled with CFR 0.152.
 */
package com.vk.sdk.api.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.vk.sdk.api.model.Identifiable;
import com.vk.sdk.api.model.ParseUtils;
import com.vk.sdk.api.model.VKApiPlace;
import com.vk.sdk.api.model.VKAttachments;
import com.vk.sdk.api.model.VKList;
import org.json.JSONException;
import org.json.JSONObject;

public class VKApiPost
extends VKAttachments.VKApiAttachment
implements Identifiable,
Parcelable {
    public int id;
    public int to_id;
    public int from_id;
    public long date;
    public String text;
    public int reply_owner_id;
    public int reply_post_id;
    public boolean friends_only;
    public int comments_count;
    public boolean can_post_comment;
    public int likes_count;
    public boolean user_likes;
    public boolean can_like;
    public boolean can_publish;
    public int reposts_count;
    public boolean user_reposted;
    public String post_type;
    public VKAttachments attachments = new VKAttachments();
    public VKApiPlace geo;
    public int signer_id;
    public VKList<VKApiPost> copy_history;
    public static Parcelable.Creator<VKApiPost> CREATOR = new Parcelable.Creator<VKApiPost>(){

        public VKApiPost createFromParcel(Parcel source) {
            return new VKApiPost(source);
        }

        public VKApiPost[] newArray(int size) {
            return new VKApiPost[size];
        }
    };

    public VKApiPost(JSONObject from) throws JSONException {
        this.parse(from);
    }

    @Override
    public VKApiPost parse(JSONObject source) throws JSONException {
        JSONObject reposts;
        JSONObject likes;
        this.id = source.optInt("id");
        this.to_id = source.optInt("to_id");
        this.from_id = source.optInt("from_id");
        this.date = source.optLong("date");
        this.text = source.optString("text");
        this.reply_owner_id = source.optInt("reply_owner_id");
        this.reply_post_id = source.optInt("reply_post_id");
        this.friends_only = ParseUtils.parseBoolean(source, "friends_only");
        JSONObject comments = source.optJSONObject("comments");
        if (comments != null) {
            this.comments_count = comments.optInt("count");
            this.can_post_comment = ParseUtils.parseBoolean(comments, "can_post");
        }
        if ((likes = source.optJSONObject("likes")) != null) {
            this.likes_count = likes.optInt("count");
            this.user_likes = ParseUtils.parseBoolean(likes, "user_likes");
            this.can_like = ParseUtils.parseBoolean(likes, "can_like");
            this.can_publish = ParseUtils.parseBoolean(likes, "can_publish");
        }
        if ((reposts = source.optJSONObject("reposts")) != null) {
            this.reposts_count = reposts.optInt("count");
            this.user_reposted = ParseUtils.parseBoolean(reposts, "user_reposted");
        }
        this.post_type = source.optString("post_type");
        this.attachments.fill(source.optJSONArray("attachments"));
        JSONObject geo = source.optJSONObject("geo");
        if (geo != null) {
            this.geo = new VKApiPlace().parse(geo);
        }
        this.signer_id = source.optInt("signer_id");
        this.copy_history = new VKList<VKApiPost>(source.optJSONArray("copy_history"), VKApiPost.class);
        return this;
    }

    public VKApiPost(Parcel in) {
        this.id = in.readInt();
        this.to_id = in.readInt();
        this.from_id = in.readInt();
        this.date = in.readLong();
        this.text = in.readString();
        this.reply_owner_id = in.readInt();
        this.reply_post_id = in.readInt();
        this.friends_only = in.readByte() != 0;
        this.comments_count = in.readInt();
        this.can_post_comment = in.readByte() != 0;
        this.likes_count = in.readInt();
        this.user_likes = in.readByte() != 0;
        this.can_like = in.readByte() != 0;
        this.can_publish = in.readByte() != 0;
        this.reposts_count = in.readInt();
        this.user_reposted = in.readByte() != 0;
        this.post_type = in.readString();
        this.attachments = (VKAttachments)in.readParcelable(VKAttachments.class.getClassLoader());
        this.geo = (VKApiPlace)in.readParcelable(VKApiPlace.class.getClassLoader());
        this.signer_id = in.readInt();
    }

    public VKApiPost() {
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public CharSequence toAttachmentString() {
        return new StringBuilder("wall").append(this.to_id).append('_').append(this.id);
    }

    @Override
    public String getType() {
        return "wall";
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.id);
        dest.writeInt(this.to_id);
        dest.writeInt(this.from_id);
        dest.writeLong(this.date);
        dest.writeString(this.text);
        dest.writeInt(this.reply_owner_id);
        dest.writeInt(this.reply_post_id);
        dest.writeByte(this.friends_only ? (byte)1 : 0);
        dest.writeInt(this.comments_count);
        dest.writeByte(this.can_post_comment ? (byte)1 : 0);
        dest.writeInt(this.likes_count);
        dest.writeByte(this.user_likes ? (byte)1 : 0);
        dest.writeByte(this.can_like ? (byte)1 : 0);
        dest.writeByte(this.can_publish ? (byte)1 : 0);
        dest.writeInt(this.reposts_count);
        dest.writeByte(this.user_reposted ? (byte)1 : 0);
        dest.writeString(this.post_type);
        dest.writeParcelable((Parcelable)this.attachments, flags);
        dest.writeParcelable((Parcelable)this.geo, flags);
        dest.writeInt(this.signer_id);
    }
}

