/*
 * Decompiled with CFR 0.152.
 */
package com.vk.sdk.api.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.vk.sdk.api.model.Identifiable;
import com.vk.sdk.api.model.ParseUtils;
import com.vk.sdk.api.model.VKApiAudio;
import com.vk.sdk.api.model.VKApiCity;
import com.vk.sdk.api.model.VKApiCountry;
import com.vk.sdk.api.model.VKApiModel;
import com.vk.sdk.api.model.VKApiSchool;
import com.vk.sdk.api.model.VKApiUniversity;
import com.vk.sdk.api.model.VKApiUser;
import com.vk.sdk.api.model.VKList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class VKApiUserFull
extends VKApiUser
implements Parcelable {
    public static final String LAST_SEEN = "last_seen";
    public static final String BDATE = "bdate";
    public static final String CITY = "city";
    public static final String COUNTRY = "country";
    public static final String UNIVERSITIES = "universities";
    public static final String SCHOOLS = "schools";
    public static final String ACTIVITY = "activity";
    public static final String PERSONAL = "personal";
    public static final String SEX = "sex";
    public static final String SITE = "site";
    public static final String CONTACTS = "contacts";
    public static final String CAN_POST = "can_post";
    public static final String CAN_SEE_ALL_POSTS = "can_see_all_posts";
    public static final String CAN_WRITE_PRIVATE_MESSAGE = "can_write_private_message";
    public static final String RELATION = "relation";
    public static final String COUNTERS = "counters";
    public static final String OCCUPATION = "occupation";
    public static final String ACTIVITIES = "activities";
    public static final String INTERESTS = "interests";
    public static final String MOVIES = "movies";
    public static final String TV = "tv";
    public static final String BOOKS = "books";
    public static final String GAMES = "games";
    public static final String ABOUT = "about";
    public static final String QUOTES = "quotes";
    public static final String CONNECTIONS = "connections";
    public static final String RELATIVES = "relatives";
    public static final String WALL_DEFAULT = "wall_default";
    public static final String VERIFIED = "verified";
    public static final String SCREEN_NAME = "screen_name";
    public static final String BLACKLISTED_BY_ME = "blacklisted_by_me";
    public String activity;
    public VKApiAudio status_audio;
    public String bdate;
    public VKApiCity city;
    public VKApiCountry country;
    public long last_seen;
    public VKList<VKApiUniversity> universities;
    public VKList<VKApiSchool> schools;
    public int smoking;
    public int alcohol;
    public int political;
    public int life_main;
    public int people_main;
    public String inspired_by;
    public String[] langs;
    public String religion;
    public String facebook;
    public String facebook_name;
    public String livejournal;
    public String skype;
    public String site;
    public String twitter;
    public String instagram;
    public String mobile_phone;
    public String home_phone;
    public String screen_name;
    public String nickname;
    public String activities;
    public String interests;
    public String movies;
    public String tv;
    public String books;
    public String games;
    public String about;
    public String quotes;
    public boolean can_post;
    public boolean can_see_all_posts;
    public boolean can_write_private_message;
    public boolean wall_comments;
    public boolean is_banned;
    public boolean is_deleted;
    public boolean wall_default_owner;
    public boolean verified;
    public int sex;
    public Counters counters;
    public Occupation occupation;
    public int relation;
    public VKList<Relative> relatives;
    public boolean blacklisted_by_me;
    public static Parcelable.Creator<VKApiUserFull> CREATOR = new Parcelable.Creator<VKApiUserFull>(){

        public VKApiUserFull createFromParcel(Parcel source) {
            return new VKApiUserFull(source);
        }

        public VKApiUserFull[] newArray(int size) {
            return new VKApiUserFull[size];
        }
    };

    public VKApiUserFull(JSONObject from) throws JSONException {
        this.parse(from);
    }

    @Override
    public VKApiUserFull parse(JSONObject user) {
        JSONObject occupation;
        JSONObject personal;
        JSONObject country;
        super.parse(user);
        this.last_seen = ParseUtils.parseLong(user.optJSONObject(LAST_SEEN), "time");
        this.bdate = user.optString(BDATE);
        JSONObject city = user.optJSONObject(CITY);
        if (city != null) {
            this.city = new VKApiCity().parse(city);
        }
        if ((country = user.optJSONObject(COUNTRY)) != null) {
            this.country = new VKApiCountry().parse(country);
        }
        this.universities = new VKList<VKApiUniversity>(user.optJSONArray(UNIVERSITIES), VKApiUniversity.class);
        this.schools = new VKList<VKApiSchool>(user.optJSONArray(SCHOOLS), VKApiSchool.class);
        this.activity = user.optString(ACTIVITY);
        JSONObject status_audio = user.optJSONObject("status_audio");
        if (status_audio != null) {
            this.status_audio = new VKApiAudio().parse(status_audio);
        }
        if ((personal = user.optJSONObject(PERSONAL)) != null) {
            JSONArray langs;
            this.smoking = personal.optInt("smoking");
            this.alcohol = personal.optInt("alcohol");
            this.political = personal.optInt("political");
            this.life_main = personal.optInt("life_main");
            this.people_main = personal.optInt("people_main");
            this.inspired_by = personal.optString("inspired_by");
            this.religion = personal.optString("religion");
            if (personal.has("langs") && (langs = personal.optJSONArray("langs")) != null) {
                this.langs = new String[langs.length()];
                for (int i = 0; i < langs.length(); ++i) {
                    this.langs[i] = langs.optString(i);
                }
            }
        }
        this.facebook = user.optString("facebook");
        this.facebook_name = user.optString("facebook_name");
        this.livejournal = user.optString("livejournal");
        this.site = user.optString(SITE);
        this.screen_name = user.optString(SCREEN_NAME, "id" + this.id);
        this.skype = user.optString("skype");
        this.mobile_phone = user.optString("mobile_phone");
        this.home_phone = user.optString("home_phone");
        this.twitter = user.optString("twitter");
        this.instagram = user.optString("instagram");
        this.about = user.optString(ABOUT);
        this.activities = user.optString(ACTIVITIES);
        this.books = user.optString(BOOKS);
        this.games = user.optString(GAMES);
        this.interests = user.optString(INTERESTS);
        this.movies = user.optString(MOVIES);
        this.quotes = user.optString(QUOTES);
        this.tv = user.optString(TV);
        this.nickname = user.optString("nickname", null);
        this.can_post = ParseUtils.parseBoolean(user, CAN_POST);
        this.can_see_all_posts = ParseUtils.parseBoolean(user, CAN_SEE_ALL_POSTS);
        this.blacklisted_by_me = ParseUtils.parseBoolean(user, BLACKLISTED_BY_ME);
        this.can_write_private_message = ParseUtils.parseBoolean(user, CAN_WRITE_PRIVATE_MESSAGE);
        this.wall_comments = ParseUtils.parseBoolean(user, WALL_DEFAULT);
        String deactivated = user.optString("deactivated");
        this.is_deleted = "deleted".equals(deactivated);
        this.is_banned = "banned".equals(deactivated);
        this.wall_default_owner = "owner".equals(user.optString(WALL_DEFAULT));
        this.verified = ParseUtils.parseBoolean(user, VERIFIED);
        this.sex = user.optInt(SEX);
        JSONObject counters = user.optJSONObject(COUNTERS);
        if (counters != null) {
            this.counters = new Counters(counters);
        }
        if ((occupation = user.optJSONObject(OCCUPATION)) != null) {
            this.occupation = new Occupation(occupation);
        }
        this.relation = user.optInt(RELATION);
        if (user.has(RELATIVES)) {
            if (this.relatives == null) {
                this.relatives = new VKList();
            }
            this.relatives.fill(user.optJSONArray(RELATIVES), Relative.class);
        }
        return this;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeString(this.activity);
        dest.writeParcelable((Parcelable)this.status_audio, flags);
        dest.writeString(this.bdate);
        dest.writeParcelable((Parcelable)this.city, flags);
        dest.writeParcelable((Parcelable)this.country, flags);
        dest.writeLong(this.last_seen);
        dest.writeParcelable(this.universities, flags);
        dest.writeParcelable(this.schools, flags);
        dest.writeInt(this.smoking);
        dest.writeInt(this.alcohol);
        dest.writeInt(this.political);
        dest.writeInt(this.life_main);
        dest.writeInt(this.people_main);
        dest.writeString(this.inspired_by);
        dest.writeStringArray(this.langs);
        dest.writeString(this.religion);
        dest.writeString(this.facebook);
        dest.writeString(this.facebook_name);
        dest.writeString(this.livejournal);
        dest.writeString(this.skype);
        dest.writeString(this.site);
        dest.writeString(this.twitter);
        dest.writeString(this.instagram);
        dest.writeString(this.mobile_phone);
        dest.writeString(this.home_phone);
        dest.writeString(this.screen_name);
        dest.writeString(this.activities);
        dest.writeString(this.interests);
        dest.writeString(this.movies);
        dest.writeString(this.tv);
        dest.writeString(this.books);
        dest.writeString(this.games);
        dest.writeString(this.about);
        dest.writeString(this.quotes);
        dest.writeByte(this.can_post ? (byte)1 : 0);
        dest.writeByte(this.can_see_all_posts ? (byte)1 : 0);
        dest.writeByte(this.can_write_private_message ? (byte)1 : 0);
        dest.writeByte(this.wall_comments ? (byte)1 : 0);
        dest.writeByte(this.is_banned ? (byte)1 : 0);
        dest.writeByte(this.is_deleted ? (byte)1 : 0);
        dest.writeByte(this.wall_default_owner ? (byte)1 : 0);
        dest.writeByte(this.verified ? (byte)1 : 0);
        dest.writeInt(this.sex);
        dest.writeParcelable((Parcelable)this.counters, flags);
        dest.writeParcelable((Parcelable)this.occupation, flags);
        dest.writeInt(this.relation);
        dest.writeParcelable(this.relatives, flags);
        dest.writeByte(this.blacklisted_by_me ? (byte)1 : 0);
    }

    public VKApiUserFull() {
    }

    public VKApiUserFull(Parcel in) {
        super(in);
        this.activity = in.readString();
        this.status_audio = (VKApiAudio)in.readParcelable(VKApiAudio.class.getClassLoader());
        this.bdate = in.readString();
        this.city = (VKApiCity)in.readParcelable(VKApiCity.class.getClassLoader());
        this.country = (VKApiCountry)in.readParcelable(VKApiCountry.class.getClassLoader());
        this.last_seen = in.readLong();
        this.universities = (VKList)in.readParcelable(VKList.class.getClassLoader());
        this.schools = (VKList)in.readParcelable(VKList.class.getClassLoader());
        this.smoking = in.readInt();
        this.alcohol = in.readInt();
        this.political = in.readInt();
        this.life_main = in.readInt();
        this.people_main = in.readInt();
        this.inspired_by = in.readString();
        this.langs = in.createStringArray();
        this.religion = in.readString();
        this.facebook = in.readString();
        this.facebook_name = in.readString();
        this.livejournal = in.readString();
        this.skype = in.readString();
        this.site = in.readString();
        this.twitter = in.readString();
        this.instagram = in.readString();
        this.mobile_phone = in.readString();
        this.home_phone = in.readString();
        this.screen_name = in.readString();
        this.activities = in.readString();
        this.interests = in.readString();
        this.movies = in.readString();
        this.tv = in.readString();
        this.books = in.readString();
        this.games = in.readString();
        this.about = in.readString();
        this.quotes = in.readString();
        this.can_post = in.readByte() != 0;
        this.can_see_all_posts = in.readByte() != 0;
        this.can_write_private_message = in.readByte() != 0;
        this.wall_comments = in.readByte() != 0;
        this.is_banned = in.readByte() != 0;
        this.is_deleted = in.readByte() != 0;
        this.wall_default_owner = in.readByte() != 0;
        this.verified = in.readByte() != 0;
        this.sex = in.readInt();
        this.counters = (Counters)in.readParcelable(Counters.class.getClassLoader());
        this.occupation = (Occupation)in.readParcelable(Occupation.class.getClassLoader());
        this.relation = in.readInt();
        this.relatives = (VKList)in.readParcelable(VKList.class.getClassLoader());
        this.blacklisted_by_me = in.readByte() != 0;
    }

    public static class RelativeType {
        public static final String PARTNER = "partner";
        public static final String GRANDCHILD = "grandchild";
        public static final String GRANDPARENT = "grandparent";
        public static final String CHILD = "child";
        public static final String SUBLING = "sibling";
        public static final String PARENT = "parent";

        private RelativeType() {
        }
    }

    public static class PeopleMain {
        public static final int INTELLECT_AND_CREATIVITY = 1;
        public static final int KINDNESS_AND_HONESTLY = 2;
        public static final int HEALTH_AND_BEAUTY = 3;
        public static final int WEALTH_AND_POWER = 4;
        public static final int COURAGE_AND_PERSISTENCE = 5;
        public static final int HUMOR_AND_LOVE_FOR_LIFE = 6;

        private PeopleMain() {
        }
    }

    public static class LifeMain {
        public static final int FAMILY_AND_CHILDREN = 1;
        public static final int CAREER_AND_MONEY = 2;
        public static final int ENTERTAINMENT_AND_LEISURE = 3;
        public static final int SCIENCE_AND_RESEARCH = 4;
        public static final int IMPROOVING_THE_WORLD = 5;
        public static final int PERSONAL_DEVELOPMENT = 6;
        public static final int BEAUTY_AND_ART = 7;
        public static final int FAME_AND_INFLUENCE = 8;

        private LifeMain() {
        }
    }

    public static class Political {
        public static final int COMMUNNIST = 1;
        public static final int SOCIALIST = 2;
        public static final int CENTRIST = 3;
        public static final int LIBERAL = 4;
        public static final int CONSERVATIVE = 5;
        public static final int MONARCHIST = 6;
        public static final int ULTRACONSERVATIVE = 7;
        public static final int LIBERTARIAN = 8;
        public static final int APATHETIC = 9;

        private Political() {
        }
    }

    public static class Attitude {
        public static final int VERY_NEGATIVE = 1;
        public static final int NEGATIVE = 2;
        public static final int COMPROMISABLE = 3;
        public static final int NEUTRAL = 4;
        public static final int POSITIVE = 5;

        private Attitude() {
        }
    }

    public static class Relation {
        public static final int SINGLE = 1;
        public static final int RELATIONSHIP = 2;
        public static final int ENGAGED = 3;
        public static final int MARRIED = 4;
        public static final int COMPLICATED = 5;
        public static final int SEARCHING = 6;
        public static final int IN_LOVE = 7;

        private Relation() {
        }
    }

    public static class Sex {
        public static final int FEMALE = 1;
        public static final int MALE = 2;

        private Sex() {
        }
    }

    public static class Occupation
    implements Parcelable {
        public static final int NO_COUNTER = -1;
        public String type;
        public int id = -1;
        public String name;
        public static Parcelable.Creator<Occupation> CREATOR = new Parcelable.Creator<Occupation>(){

            public Occupation createFromParcel(Parcel source) {
                return new Occupation(source);
            }

            public Occupation[] newArray(int size) {
                return new Occupation[size];
            }
        };

        Occupation(JSONObject occupation) {
            this.type = occupation.optString("type");
            this.id = occupation.optInt("id", this.id);
            this.name = occupation.optString("name");
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.type);
            dest.writeInt(this.id);
            dest.writeString(this.name);
        }

        private Occupation(Parcel in) {
            this.type = in.readString();
            this.id = in.readInt();
            this.name = in.readString();
        }
    }

    public static class Counters
    implements Parcelable {
        public static final int NO_COUNTER = -1;
        public int albums = -1;
        public int videos = -1;
        public int audios = -1;
        public int notes = -1;
        public int friends = -1;
        public int photos = -1;
        public int groups = -1;
        public int online_friends = -1;
        public int mutual_friends = -1;
        public int user_videos = -1;
        public int followers = -1;
        public int subscriptions = -1;
        public int pages = -1;
        public static Parcelable.Creator<Counters> CREATOR = new Parcelable.Creator<Counters>(){

            public Counters createFromParcel(Parcel source) {
                return new Counters(source);
            }

            public Counters[] newArray(int size) {
                return new Counters[size];
            }
        };

        Counters(JSONObject counters) {
            this.albums = counters.optInt("albums", this.albums);
            this.audios = counters.optInt("audios", this.audios);
            this.followers = counters.optInt("followers", this.followers);
            this.photos = counters.optInt("photos", this.photos);
            this.friends = counters.optInt("friends", this.friends);
            this.groups = counters.optInt("groups", this.groups);
            this.mutual_friends = counters.optInt("mutual_friends", this.mutual_friends);
            this.notes = counters.optInt("notes", this.notes);
            this.online_friends = counters.optInt("online_friends", this.online_friends);
            this.user_videos = counters.optInt("user_videos", this.user_videos);
            this.videos = counters.optInt("videos", this.videos);
            this.subscriptions = counters.optInt("subscriptions", this.subscriptions);
            this.pages = counters.optInt("pages", this.pages);
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.albums);
            dest.writeInt(this.videos);
            dest.writeInt(this.audios);
            dest.writeInt(this.notes);
            dest.writeInt(this.friends);
            dest.writeInt(this.photos);
            dest.writeInt(this.groups);
            dest.writeInt(this.online_friends);
            dest.writeInt(this.mutual_friends);
            dest.writeInt(this.user_videos);
            dest.writeInt(this.followers);
            dest.writeInt(this.subscriptions);
            dest.writeInt(this.pages);
        }

        private Counters(Parcel in) {
            this.albums = in.readInt();
            this.videos = in.readInt();
            this.audios = in.readInt();
            this.notes = in.readInt();
            this.friends = in.readInt();
            this.photos = in.readInt();
            this.groups = in.readInt();
            this.online_friends = in.readInt();
            this.mutual_friends = in.readInt();
            this.user_videos = in.readInt();
            this.followers = in.readInt();
            this.subscriptions = in.readInt();
            this.pages = in.readInt();
        }
    }

    public static class Relative
    extends VKApiModel
    implements Parcelable,
    Identifiable {
        public int id;
        public String name;
        public static Parcelable.Creator<Relative> CREATOR = new Parcelable.Creator<Relative>(){

            public Relative createFromParcel(Parcel source) {
                return new Relative(source);
            }

            public Relative[] newArray(int size) {
                return new Relative[size];
            }
        };

        @Override
        public int getId() {
            return this.id;
        }

        @Override
        public Relative parse(JSONObject response) {
            this.id = response.optInt("id");
            this.name = response.optString("name");
            return this;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.id);
            dest.writeString(this.name);
        }

        private Relative(Parcel in) {
            this.id = in.readInt();
            this.name = in.readString();
        }
    }
}

