/*
 * Decompiled with CFR 0.152.
 */
package com.vk.sdk.api.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.vk.sdk.api.model.Identifiable;
import com.vk.sdk.api.model.VKApiApplicationContent;
import com.vk.sdk.api.model.VKApiAudio;
import com.vk.sdk.api.model.VKApiDocument;
import com.vk.sdk.api.model.VKApiLink;
import com.vk.sdk.api.model.VKApiModel;
import com.vk.sdk.api.model.VKApiNote;
import com.vk.sdk.api.model.VKApiPhoto;
import com.vk.sdk.api.model.VKApiPhotoAlbum;
import com.vk.sdk.api.model.VKApiPoll;
import com.vk.sdk.api.model.VKApiPost;
import com.vk.sdk.api.model.VKApiPostedPhoto;
import com.vk.sdk.api.model.VKApiVideo;
import com.vk.sdk.api.model.VKApiWikiPage;
import com.vk.sdk.api.model.VKList;
import com.vk.sdk.util.VKStringJoiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class VKAttachments
extends VKList<VKApiAttachment>
implements Parcelable {
    public static final String TYPE_PHOTO = "photo";
    public static final String TYPE_VIDEO = "video";
    public static final String TYPE_AUDIO = "audio";
    public static final String TYPE_DOC = "doc";
    public static final String TYPE_POST = "wall";
    public static final String TYPE_POSTED_PHOTO = "posted_photo";
    public static final String TYPE_LINK = "link";
    public static final String TYPE_NOTE = "note";
    public static final String TYPE_APP = "app";
    public static final String TYPE_POLL = "poll";
    public static final String TYPE_WIKI_PAGE = "page";
    public static final String TYPE_ALBUM = "album";
    private final VKList.Parser<VKApiAttachment> parser = new VKList.Parser<VKApiAttachment>(){

        @Override
        public VKApiAttachment parseObject(JSONObject attachment) throws Exception {
            String type = attachment.optString("type");
            if (VKAttachments.TYPE_PHOTO.equals(type)) {
                return new VKApiPhoto().parse(attachment.getJSONObject(VKAttachments.TYPE_PHOTO));
            }
            if (VKAttachments.TYPE_VIDEO.equals(type)) {
                return new VKApiVideo().parse(attachment.getJSONObject(VKAttachments.TYPE_VIDEO));
            }
            if (VKAttachments.TYPE_AUDIO.equals(type)) {
                return new VKApiAudio().parse(attachment.getJSONObject(VKAttachments.TYPE_AUDIO));
            }
            if (VKAttachments.TYPE_DOC.equals(type)) {
                return new VKApiDocument().parse(attachment.getJSONObject(VKAttachments.TYPE_DOC));
            }
            if (VKAttachments.TYPE_POST.equals(type)) {
                return new VKApiPost().parse(attachment.getJSONObject(VKAttachments.TYPE_POST));
            }
            if (VKAttachments.TYPE_POSTED_PHOTO.equals(type)) {
                return new VKApiPostedPhoto().parse(attachment.getJSONObject(VKAttachments.TYPE_POSTED_PHOTO));
            }
            if (VKAttachments.TYPE_LINK.equals(type)) {
                return new VKApiLink().parse(attachment.getJSONObject(VKAttachments.TYPE_LINK));
            }
            if (VKAttachments.TYPE_NOTE.equals(type)) {
                return new VKApiNote().parse(attachment.getJSONObject(VKAttachments.TYPE_NOTE));
            }
            if (VKAttachments.TYPE_APP.equals(type)) {
                return new VKApiApplicationContent().parse(attachment.getJSONObject(VKAttachments.TYPE_APP));
            }
            if (VKAttachments.TYPE_POLL.equals(type)) {
                return new VKApiPoll().parse(attachment.getJSONObject(VKAttachments.TYPE_POLL));
            }
            if (VKAttachments.TYPE_WIKI_PAGE.equals(type)) {
                return new VKApiWikiPage().parse(attachment.getJSONObject(VKAttachments.TYPE_WIKI_PAGE));
            }
            if (VKAttachments.TYPE_ALBUM.equals(type)) {
                return new VKApiPhotoAlbum().parse(attachment.getJSONObject(VKAttachments.TYPE_ALBUM));
            }
            return null;
        }
    };
    public static Parcelable.Creator<VKAttachments> CREATOR = new Parcelable.Creator<VKAttachments>(){

        public VKAttachments createFromParcel(Parcel source) {
            return new VKAttachments(source);
        }

        public VKAttachments[] newArray(int size) {
            return new VKAttachments[size];
        }
    };

    public VKAttachments() {
    }

    public VKAttachments(VKApiAttachment ... data) {
        super(Arrays.asList(data));
    }

    public VKAttachments(List<? extends VKApiAttachment> data) {
        super(data);
    }

    public VKAttachments(JSONObject from) {
        this.fill(from);
    }

    public VKAttachments(JSONArray from) {
        this.fill(from);
    }

    public void fill(JSONObject from) {
        super.fill(from, this.parser);
    }

    public void fill(JSONArray from) {
        super.fill(from, this.parser);
    }

    public String toAttachmentsString() {
        ArrayList<CharSequence> attachments = new ArrayList<CharSequence>();
        for (VKApiAttachment attach : this) {
            attachments.add(attach.toAttachmentString());
        }
        return VKStringJoiner.join(attachments, ",");
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.size());
        for (VKApiAttachment attachment : this) {
            dest.writeString(attachment.getType());
            dest.writeParcelable((Parcelable)attachment, 0);
        }
    }

    public VKAttachments(Parcel parcel) {
        int size = parcel.readInt();
        for (int i = 0; i < size; ++i) {
            String type = parcel.readString();
            if (TYPE_PHOTO.equals(type)) {
                this.add((VKApiAttachment)parcel.readParcelable(VKApiPhoto.class.getClassLoader()));
                continue;
            }
            if (TYPE_VIDEO.equals(type)) {
                this.add((VKApiAttachment)parcel.readParcelable(VKApiVideo.class.getClassLoader()));
                continue;
            }
            if (TYPE_AUDIO.equals(type)) {
                this.add((VKApiAttachment)parcel.readParcelable(VKApiAudio.class.getClassLoader()));
                continue;
            }
            if (TYPE_DOC.equals(type)) {
                this.add((VKApiAttachment)parcel.readParcelable(VKApiDocument.class.getClassLoader()));
                continue;
            }
            if (TYPE_POST.equals(type)) {
                this.add((VKApiAttachment)parcel.readParcelable(VKApiPost.class.getClassLoader()));
                continue;
            }
            if (TYPE_POSTED_PHOTO.equals(type)) {
                this.add((VKApiAttachment)parcel.readParcelable(VKApiPostedPhoto.class.getClassLoader()));
                continue;
            }
            if (TYPE_LINK.equals(type)) {
                this.add((VKApiAttachment)parcel.readParcelable(VKApiLink.class.getClassLoader()));
                continue;
            }
            if (TYPE_NOTE.equals(type)) {
                this.add((VKApiAttachment)parcel.readParcelable(VKApiNote.class.getClassLoader()));
                continue;
            }
            if (TYPE_APP.equals(type)) {
                this.add((VKApiAttachment)parcel.readParcelable(VKApiApplicationContent.class.getClassLoader()));
                continue;
            }
            if (TYPE_POLL.equals(type)) {
                this.add((VKApiAttachment)parcel.readParcelable(VKApiPoll.class.getClassLoader()));
                continue;
            }
            if (TYPE_WIKI_PAGE.equals(type)) {
                this.add((VKApiAttachment)parcel.readParcelable(VKApiWikiPage.class.getClassLoader()));
                continue;
            }
            if (!TYPE_ALBUM.equals(type)) continue;
            this.add((VKApiAttachment)parcel.readParcelable(VKApiPhotoAlbum.class.getClassLoader()));
        }
    }

    public static abstract class VKApiAttachment
    extends VKApiModel
    implements Identifiable {
        public abstract CharSequence toAttachmentString();

        public abstract String getType();
    }
}

