/*
 * Decompiled with CFR 0.152.
 */
package com.vk.sdk.api.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.vk.sdk.api.model.Identifiable;
import com.vk.sdk.api.model.VKApiModel;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class VKList<T extends VKApiModel & Identifiable>
extends VKApiModel
implements List<T>,
Parcelable {
    private static final int NO_COUNT = -1;
    private ArrayList<T> items = new ArrayList();
    private int count = -1;
    public static Parcelable.Creator<VKList> CREATOR = new Parcelable.Creator<VKList>(){

        public VKList createFromParcel(Parcel source) {
            return new VKList(source);
        }

        public VKList[] newArray(int size) {
            return new VKList[size];
        }
    };

    public VKList() {
    }

    public VKList(List<? extends T> data) {
        assert (data != null);
        this.items = new ArrayList<T>(data);
    }

    public VKList(JSONObject from, Class<? extends T> clazz) {
        this.fill(from, clazz);
    }

    public VKList(JSONArray from, Class<? extends T> clazz) {
        this.fill(from, clazz);
    }

    public VKList(JSONObject from, Parser<T> creator) {
        this.fill(from, creator);
    }

    public VKList(JSONArray from, Parser<T> creator) {
        this.fill(from, creator);
    }

    public void fill(JSONObject from, Class<? extends T> clazz) {
        if (from.has("response")) {
            JSONArray array = from.optJSONArray("response");
            if (array != null) {
                this.fill(array, clazz);
            } else {
                this.fill(from.optJSONObject("response"), clazz);
            }
        } else {
            this.fill(from, new ReflectParser<T>(clazz));
        }
    }

    public void fill(JSONArray from, Class<? extends T> clazz) {
        this.fill(from, new ReflectParser<T>(clazz));
    }

    public void fill(JSONObject from, Parser<? extends T> creator) {
        if (from != null) {
            this.fill(from.optJSONArray("items"), creator);
            this.count = from.optInt("count", this.count);
        }
    }

    public void fill(JSONArray from, Parser<? extends T> creator) {
        if (from != null) {
            for (int i = 0; i < from.length(); ++i) {
                try {
                    VKApiModel object = (VKApiModel)creator.parseObject(from.getJSONObject(i));
                    if (object == null) continue;
                    this.items.add(object);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void addBefore(int id, T data) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (((Identifiable)this.get(i)).getId() <= id && i != size - 1) continue;
            this.add(i, data);
            break;
        }
    }

    public void addAfter(int id, T data) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (((Identifiable)this.get(i)).getId() <= id && i != size - 1) continue;
            this.add(i + 1, data);
            break;
        }
    }

    public T getById(int id) {
        for (VKApiModel item : this) {
            if (((Identifiable)((Object)item)).getId() != id) continue;
            return (T)item;
        }
        return null;
    }

    public VKList<T> search(String query) {
        VKList<VKApiModel> result = new VKList<VKApiModel>();
        Pattern pattern = Pattern.compile("(?i).*\\b" + query + ".*");
        for (VKApiModel item : this) {
            if (!pattern.matcher(item.toString()).find()) continue;
            result.add(item);
        }
        return result;
    }

    public int getCount() {
        return this.count != -1 ? this.count : this.size();
    }

    @Override
    public void add(int location, T object) {
        this.items.add(location, object);
    }

    @Override
    public boolean add(T object) {
        return this.items.add(object);
    }

    @Override
    public boolean addAll(int location, @NonNull Collection<? extends T> collection) {
        return this.items.addAll(location, collection);
    }

    @Override
    public boolean addAll(@NonNull Collection<? extends T> collection) {
        return this.items.addAll(collection);
    }

    @Override
    public void clear() {
        this.items.clear();
    }

    @Override
    public boolean contains(Object object) {
        return this.items.contains(object);
    }

    @Override
    public boolean containsAll(@NonNull Collection<?> collection) {
        return this.items.containsAll(collection);
    }

    @Override
    public boolean equals(Object object) {
        return this.getClass().equals(object.getClass()) && this.items.equals(object);
    }

    @Override
    public T get(int location) {
        return (T)((VKApiModel)this.items.get(location));
    }

    @Override
    public int indexOf(Object object) {
        return this.items.indexOf(object);
    }

    @Override
    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    @Override
    @NonNull
    public Iterator<T> iterator() {
        return this.items.iterator();
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.items.lastIndexOf(object);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.items.listIterator();
    }

    @Override
    @NonNull
    public ListIterator<T> listIterator(int location) {
        return this.items.listIterator(location);
    }

    @Override
    public T remove(int location) {
        return (T)((VKApiModel)this.items.remove(location));
    }

    @Override
    public boolean remove(Object object) {
        return this.items.remove(object);
    }

    @Override
    public boolean removeAll(@NonNull Collection<?> collection) {
        return this.items.removeAll(collection);
    }

    @Override
    public boolean retainAll(@NonNull Collection<?> collection) {
        return this.items.retainAll(collection);
    }

    @Override
    public T set(int location, T object) {
        return (T)((VKApiModel)this.items.set(location, object));
    }

    @Override
    public int size() {
        return this.items.size();
    }

    @Override
    @NonNull
    public List<T> subList(int start, int end) {
        return this.items.subList(start, end);
    }

    @Override
    @NonNull
    public Object[] toArray() {
        return this.items.toArray();
    }

    @Override
    @NonNull
    public <T1> T1[] toArray(@NonNull T1[] array) {
        return this.items.toArray(array);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.items.size());
        for (VKApiModel item : this) {
            dest.writeParcelable((Parcelable)item, flags);
        }
        dest.writeInt(this.count);
    }

    public VKList(Parcel in) {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.items.add((VKApiModel)in.readParcelable(this.getClass().getClassLoader()));
        }
        this.count = in.readInt();
    }

    @Override
    public VKApiModel parse(JSONObject response) throws JSONException {
        throw new JSONException("Operation is not supported while class is generic");
    }

    public static final class ReflectParser<D extends VKApiModel>
    implements Parser<D> {
        private final Class<? extends D> clazz;

        public ReflectParser(Class<? extends D> clazz) {
            this.clazz = clazz;
        }

        @Override
        public D parseObject(JSONObject source) throws Exception {
            try {
                Constructor<D> jsonConstructor = this.clazz.getConstructor(JSONObject.class);
                if (jsonConstructor != null) {
                    return (D)((VKApiModel)jsonConstructor.newInstance(source));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return (D)((VKApiModel)this.clazz.newInstance()).parse(source);
        }
    }

    public static interface Parser<D> {
        public D parseObject(JSONObject var1) throws Exception;
    }
}

