/*
 * Decompiled with CFR 0.152.
 */
package com.vk.sdk.api.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.vk.sdk.api.model.VKApiPhotoSize;
import com.vk.sdk.api.model.VKList;
import java.util.Collections;
import org.json.JSONArray;
import org.json.JSONObject;

public class VKPhotoSizes
extends VKList<VKApiPhotoSize>
implements Parcelable {
    private static float sQuality = 1.0f;
    private int mOriginalWidth = 1;
    private int mOriginalHeight = 1;
    private String mWidthThumb;
    private String mHeightThumb;
    private int mLastWidth;
    private int mLastHeight;
    private final VKList.Parser<VKApiPhotoSize> parser = new VKList.Parser<VKApiPhotoSize>(){

        @Override
        public VKApiPhotoSize parseObject(JSONObject source) throws Exception {
            return VKApiPhotoSize.parse(source, VKPhotoSizes.this.mOriginalWidth, VKPhotoSizes.this.mOriginalHeight);
        }
    };
    public static Parcelable.Creator<VKPhotoSizes> CREATOR = new Parcelable.Creator<VKPhotoSizes>(){

        public VKPhotoSizes createFromParcel(Parcel source) {
            return new VKPhotoSizes(source);
        }

        public VKPhotoSizes[] newArray(int size) {
            return new VKPhotoSizes[size];
        }
    };

    public static void setQuality(float quality) {
        sQuality = quality;
    }

    public VKPhotoSizes() {
    }

    public VKPhotoSizes(JSONArray from) {
        this.fill(from);
    }

    public void fill(JSONArray from, int width, int height) {
        this.setOriginalDimension(width, height);
        this.fill(from);
    }

    public void fill(JSONArray from) {
        this.fill(from, this.parser);
        this.sort();
    }

    public String getByType(char type) {
        for (VKApiPhotoSize size : this) {
            if (size.type != type) continue;
            return size.src;
        }
        return null;
    }

    public void setOriginalDimension(int width, int height) {
        if (width != 0) {
            this.mOriginalWidth = width;
        }
        if (height != 0) {
            this.mOriginalHeight = height;
        }
    }

    public void sort() {
        Collections.sort(this);
    }

    public String getImageForDimension(int width, int height) {
        return width >= height ? this.getImageForWidth(width) : this.getImageForHeight(height);
    }

    private String getImageForWidth(int width) {
        if (this.mWidthThumb != null && this.mLastWidth != width || this.isEmpty()) {
            return this.mWidthThumb;
        }
        this.mLastWidth = width;
        this.mWidthThumb = null;
        width = (int)((float)width * sQuality);
        for (VKApiPhotoSize size : this) {
            if (size.width < width) continue;
            this.mWidthThumb = size.src;
            break;
        }
        return this.mWidthThumb;
    }

    private String getImageForHeight(int height) {
        if (this.mHeightThumb != null && this.mLastHeight != height || this.isEmpty()) {
            return this.mHeightThumb;
        }
        this.mLastHeight = height;
        this.mHeightThumb = null;
        height = (int)((float)height * sQuality);
        for (VKApiPhotoSize size : this) {
            if (size.height < height) continue;
            this.mHeightThumb = size.src;
            break;
        }
        return this.mHeightThumb;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeInt(this.mOriginalWidth);
        dest.writeInt(this.mOriginalHeight);
        dest.writeString(this.mWidthThumb);
        dest.writeInt(this.mLastWidth);
    }

    private VKPhotoSizes(Parcel in) {
        super(in);
        this.mOriginalWidth = in.readInt();
        this.mOriginalHeight = in.readInt();
        this.mWidthThumb = in.readString();
        this.mLastWidth = in.readInt();
    }
}

