/*
 * Decompiled with CFR 0.152.
 */
package com.vk.sdk.api.photo;

import android.os.Parcel;
import android.os.Parcelable;
import com.vk.sdk.VKObject;

public class VKImageParameters
extends VKObject
implements Parcelable {
    public VKImageType mImageType = VKImageType.Png;
    public float mJpegQuality;
    public static final Parcelable.Creator<VKImageParameters> CREATOR = new Parcelable.Creator<VKImageParameters>(){

        public VKImageParameters createFromParcel(Parcel source) {
            return new VKImageParameters(source);
        }

        public VKImageParameters[] newArray(int size) {
            return new VKImageParameters[size];
        }
    };

    public static VKImageParameters pngImage() {
        VKImageParameters result = new VKImageParameters();
        result.mImageType = VKImageType.Png;
        return result;
    }

    public static VKImageParameters jpgImage(float quality) {
        VKImageParameters result = new VKImageParameters();
        result.mImageType = VKImageType.Jpg;
        result.mJpegQuality = quality;
        return result;
    }

    public String fileExtension() {
        switch (this.mImageType) {
            case Jpg: {
                return "jpg";
            }
            case Png: {
                return "png";
            }
        }
        return "file";
    }

    public String mimeType() {
        switch (this.mImageType) {
            case Jpg: {
                return "image/jpeg";
            }
            case Png: {
                return "image/png";
            }
        }
        return "application/octet-stream";
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mImageType == null ? -1 : this.mImageType.ordinal());
        dest.writeFloat(this.mJpegQuality);
    }

    public VKImageParameters() {
    }

    private VKImageParameters(Parcel in) {
        int tmpMImageType = in.readInt();
        this.mImageType = tmpMImageType == -1 ? null : VKImageType.values()[tmpMImageType];
        this.mJpegQuality = in.readFloat();
    }

    static enum VKImageType {
        Jpg,
        Png;

    }
}

