/*
 * Decompiled with CFR 0.152.
 */
package com.vk.sdk.api.photo;

import com.vk.sdk.api.VKApi;
import com.vk.sdk.api.VKParameters;
import com.vk.sdk.api.VKRequest;
import com.vk.sdk.api.photo.VKUploadImage;
import com.vk.sdk.api.photo.VKUploadPhotoBase;
import com.vk.sdk.util.VKJsonHelper;
import com.vk.sdk.util.VKUtil;
import java.io.File;
import org.json.JSONException;
import org.json.JSONObject;

public class VKUploadAlbumPhotoRequest
extends VKUploadPhotoBase {
    private static final long serialVersionUID = 5439648671595840976L;

    public VKUploadAlbumPhotoRequest(File image, long albumId, long groupId) {
        this.mAlbumId = albumId;
        this.mGroupId = groupId;
        this.mImages = new File[]{image};
    }

    public VKUploadAlbumPhotoRequest(VKUploadImage image, long albumId, long groupId) {
        this.mAlbumId = albumId;
        this.mGroupId = groupId;
        this.mImages = new File[]{image.getTmpFile()};
    }

    @Override
    protected VKRequest getServerRequest() {
        if (this.mAlbumId != 0L && this.mGroupId != 0L) {
            return VKApi.photos().getUploadServer(this.mAlbumId, this.mGroupId);
        }
        return VKApi.photos().getUploadServer(this.mAlbumId);
    }

    @Override
    protected VKRequest getSaveRequest(JSONObject response) {
        VKRequest saveRequest;
        try {
            saveRequest = VKApi.photos().save(new VKParameters(VKJsonHelper.toMap(response)));
        }
        catch (JSONException e) {
            return null;
        }
        if (this.mAlbumId != 0L) {
            saveRequest.addExtraParameters(VKUtil.paramsFrom("album_id", this.mAlbumId));
        }
        if (this.mGroupId != 0L) {
            saveRequest.addExtraParameters(VKUtil.paramsFrom("group_id", this.mGroupId));
        }
        return saveRequest;
    }
}

