/*
 * Decompiled with CFR 0.152.
 */
package com.vk.sdk.api.photo;

import com.vk.sdk.api.VKApi;
import com.vk.sdk.api.VKParameters;
import com.vk.sdk.api.VKRequest;
import com.vk.sdk.api.photo.VKUploadImage;
import com.vk.sdk.api.photo.VKUploadPhotoBase;
import com.vk.sdk.util.VKJsonHelper;
import com.vk.sdk.util.VKUtil;
import java.io.File;
import org.json.JSONException;
import org.json.JSONObject;

public class VKUploadWallPhotoRequest
extends VKUploadPhotoBase {
    private static final long serialVersionUID = 4732771149932923938L;

    public VKUploadWallPhotoRequest(File image, long userId, int groupId) {
        this.mUserId = userId;
        this.mGroupId = groupId;
        this.mImages = new File[]{image};
    }

    public VKUploadWallPhotoRequest(VKUploadImage image, long userId, int groupId) {
        this.mUserId = userId;
        this.mGroupId = groupId;
        this.mImages = new File[]{image.getTmpFile()};
    }

    public VKUploadWallPhotoRequest(VKUploadImage[] images, long userId, int groupId) {
        this.mUserId = userId;
        this.mGroupId = groupId;
        this.mImages = new File[images.length];
        for (int i = 0; i < images.length; ++i) {
            this.mImages[i] = images[i].getTmpFile();
        }
    }

    @Override
    protected VKRequest getServerRequest() {
        if (this.mGroupId != 0L) {
            return VKApi.photos().getWallUploadServer(this.mGroupId);
        }
        return VKApi.photos().getWallUploadServer();
    }

    @Override
    protected VKRequest getSaveRequest(JSONObject response) {
        VKRequest saveRequest;
        try {
            saveRequest = VKApi.photos().saveWallPhoto(new VKParameters(VKJsonHelper.toMap(response)));
        }
        catch (JSONException e) {
            return null;
        }
        if (this.mUserId != 0L) {
            saveRequest.addExtraParameters(VKUtil.paramsFrom("user_id", this.mUserId));
        }
        if (this.mGroupId != 0L) {
            saveRequest.addExtraParameters(VKUtil.paramsFrom("group_id", this.mGroupId));
        }
        return saveRequest;
    }
}

