/*
 * Decompiled with CFR 0.152.
 */
package com.vk.sdk.dialogs;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.vk.sdk.R;
import com.vk.sdk.VKServiceActivity;
import com.vk.sdk.api.VKError;
import com.vk.sdk.util.VKUtil;
import java.util.Locale;
import java.util.Map;

public class VKOpenAuthDialog
implements DialogInterface.OnDismissListener {
    public static final String VK_EXTRA_CLIENT_ID = "client_id";
    public static final String VK_EXTRA_SCOPE = "scope";
    public static final String VK_EXTRA_API_VERSION = "version";
    public static final String VK_EXTRA_REVOKE = "revoke";
    public static final String VK_RESULT_INTENT_NAME = "com.vk.auth-token";
    public static final String VK_EXTRA_TOKEN_DATA = "extra-token-data";
    public static final String VK_EXTRA_VALIDATION_REQUEST = "extra-validation-request";
    private static final String REDIRECT_URL = "https://oauth.vk.com/blank.html";
    private static final String ERROR = "error";
    private static final String CANCEL = "cancel";
    @Nullable
    protected VKError mVkError;
    protected WebView mWebView;
    protected View mProgress;
    protected View mView;
    protected Bundle mBundle;
    protected Intent mData;
    protected int mResCode = -1;
    protected int mReqCode;
    protected Dialog mDialog;

    public void show(@NonNull Activity activity, Bundle bundle, int reqCode, @Nullable VKError vkError) {
        this.mVkError = vkError;
        this.mBundle = bundle;
        this.mReqCode = reqCode;
        this.mView = View.inflate((Context)activity, (int)R.layout.vk_open_auth_dialog, null);
        this.mProgress = this.mView.findViewById(R.id.progress);
        this.mWebView = (WebView)this.mView.findViewById(R.id.copyUrl);
        final Dialog dialog = new Dialog((Context)activity, R.style.VKAlertDialog);
        dialog.setContentView(this.mView);
        dialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialogInterface) {
                dialog.dismiss();
            }
        });
        dialog.setOnDismissListener((DialogInterface.OnDismissListener)this);
        if (Build.VERSION.SDK_INT >= 21) {
            dialog.getWindow().setStatusBarColor(0);
        }
        this.mDialog = dialog;
        this.mDialog.show();
        this.loadPage();
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private void loadPage() {
        try {
            String urlToLoad;
            String string2 = urlToLoad = this.mVkError == null ? null : this.mVkError.redirectUri;
            if (urlToLoad == null) {
                int appId = this.mBundle.getInt(VK_EXTRA_CLIENT_ID, 0);
                String scope = this.mBundle.getString(VK_EXTRA_SCOPE);
                String apiV = this.mBundle.getString(VK_EXTRA_API_VERSION);
                boolean revoke = this.mBundle.getBoolean(VK_EXTRA_REVOKE, false);
                urlToLoad = String.format(Locale.US, "https://oauth.vk.com/authorize?client_id=%s&scope=%s&redirect_uri=%s&display=mobile&v=%s&response_type=token&revoke=%d", appId, scope, REDIRECT_URL, apiV, revoke ? 1 : 0);
            }
            this.mWebView.setWebViewClient((WebViewClient)new OAuthWebViewClient(this));
            WebSettings webSettings = this.mWebView.getSettings();
            webSettings.setJavaScriptEnabled(true);
            this.mWebView.loadUrl(urlToLoad);
            this.mWebView.setBackgroundColor(0);
            if (Build.VERSION.SDK_INT >= 11) {
                this.mWebView.setLayerType(1, null);
            }
            this.mWebView.setVerticalScrollBarEnabled(false);
            this.mWebView.setVisibility(4);
            this.mWebView.setOverScrollMode(2);
            this.mProgress.setVisibility(0);
        }
        catch (Exception e) {
            this.setResult(0);
            this.finish();
        }
    }

    public void onDismiss(DialogInterface dialog) {
        Activity activity;
        Activity activity2 = activity = this.mView == null ? null : (Activity)this.mView.getContext();
        if (activity instanceof VKServiceActivity) {
            ((VKServiceActivity)activity).onActivityResultPublic(this.mReqCode, this.mResCode, this.mData);
        }
    }

    private void setResult(int code) {
        this.mResCode = code;
    }

    private void setResult(int code, Intent data) {
        this.mResCode = code;
        this.mData = data;
    }

    private void finish() {
        if (this.mDialog != null) {
            this.mDialog.dismiss();
        }
    }

    private static class OAuthWebViewClient
    extends WebViewClient {
        boolean canShowPage = true;
        @NonNull
        final VKOpenAuthDialog vkOpenAuthDialog;

        public OAuthWebViewClient(@NonNull VKOpenAuthDialog vkOpenAuthDialog) {
            this.vkOpenAuthDialog = vkOpenAuthDialog;
        }

        boolean processUrl(String url) {
            if (url.startsWith(VKOpenAuthDialog.REDIRECT_URL)) {
                Intent data = new Intent(VKOpenAuthDialog.VK_RESULT_INTENT_NAME);
                String extraData = url.substring(url.indexOf(35) + 1);
                data.putExtra(VKOpenAuthDialog.VK_EXTRA_TOKEN_DATA, extraData);
                Map<String, String> resultParams = VKUtil.explodeQueryString(extraData);
                if (this.vkOpenAuthDialog.mVkError != null) {
                    data.putExtra(VKOpenAuthDialog.VK_EXTRA_VALIDATION_REQUEST, this.vkOpenAuthDialog.mVkError.request.registerObject());
                }
                if (resultParams != null && (resultParams.containsKey(VKOpenAuthDialog.ERROR) || resultParams.containsKey(VKOpenAuthDialog.CANCEL))) {
                    this.vkOpenAuthDialog.setResult(0, data);
                } else {
                    this.vkOpenAuthDialog.setResult(-1, data);
                }
                this.vkOpenAuthDialog.finish();
                return true;
            }
            return false;
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            if (this.processUrl(url)) {
                return true;
            }
            this.canShowPage = true;
            return false;
        }

        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            super.onPageStarted(view, url, favicon);
            this.processUrl(url);
        }

        public void onPageFinished(WebView view, String url) {
            super.onPageFinished(view, url);
            if (this.canShowPage) {
                if (this.vkOpenAuthDialog.mProgress != null) {
                    this.vkOpenAuthDialog.mProgress.setVisibility(8);
                }
                view.setVisibility(0);
            }
        }

        public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
            super.onReceivedError(view, errorCode, description, failingUrl);
            this.canShowPage = false;
            AlertDialog.Builder builder = new AlertDialog.Builder(view.getContext()).setMessage((CharSequence)description).setPositiveButton(R.string.vk_retry, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialogInterface, int i) {
                    OAuthWebViewClient.this.vkOpenAuthDialog.loadPage();
                }
            }).setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialogInterface, int i) {
                    OAuthWebViewClient.this.vkOpenAuthDialog.finish();
                }
            });
            try {
                builder.show();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

