/*
 * Decompiled with CFR 0.152.
 */
package com.vk.sdk.dialogs;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.HorizontalScrollView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.vk.sdk.R;
import com.vk.sdk.VKSdk;
import com.vk.sdk.VKUIHelper;
import com.vk.sdk.api.VKApi;
import com.vk.sdk.api.VKError;
import com.vk.sdk.api.VKParameters;
import com.vk.sdk.api.VKRequest;
import com.vk.sdk.api.VKResponse;
import com.vk.sdk.api.httpClient.VKHttpClient;
import com.vk.sdk.api.httpClient.VKImageOperation;
import com.vk.sdk.api.model.VKApiLink;
import com.vk.sdk.api.model.VKApiPhoto;
import com.vk.sdk.api.model.VKAttachments;
import com.vk.sdk.api.model.VKPhotoArray;
import com.vk.sdk.api.model.VKWallPostResult;
import com.vk.sdk.api.photo.VKUploadImage;
import com.vk.sdk.api.photo.VKUploadWallPhotoRequest;
import com.vk.sdk.dialogs.VKShareDialogBuilder;
import com.vk.sdk.util.VKStringJoiner;
import com.vk.sdk.util.VKUtil;
import java.util.ArrayList;

class VKShareDialogDelegate {
    private static final String SHARE_TEXT_KEY = "ShareText";
    private static final String SHARE_LINK_KEY = "ShareLink";
    private static final String SHARE_IMAGES_KEY = "ShareImages";
    private static final String SHARE_UPLOADED_IMAGES_KEY = "ShareUploadedImages";
    private static final int SHARE_PHOTO_HEIGHT = 100;
    private static final int SHARE_PHOTO_CORNER_RADIUS = 3;
    private static final int SHARE_PHOTO_MARGIN_LEFT = 10;
    private EditText mShareTextField;
    private Button mSendButton;
    private ProgressBar mSendProgress;
    private LinearLayout mPhotoLayout;
    private HorizontalScrollView mPhotoScroll;
    private UploadingLink mAttachmentLink;
    private VKUploadImage[] mAttachmentImages;
    private VKPhotoArray mExistingPhotos;
    private CharSequence mAttachmentText;
    private VKShareDialogBuilder.VKShareDialogListener mListener;
    private final DialogFragmentI dialogFragmentI;
    View.OnClickListener sendButtonPress = new View.OnClickListener(){

        public void onClick(View view) {
            VKShareDialogDelegate.this.setIsLoading(true);
            if (VKShareDialogDelegate.this.mAttachmentImages != null && VKSdk.getAccessToken() != null) {
                Long userId = Long.parseLong(VKSdk.getAccessToken().userId);
                VKUploadWallPhotoRequest photoRequest = new VKUploadWallPhotoRequest(VKShareDialogDelegate.this.mAttachmentImages, (long)userId, 0);
                photoRequest.executeWithListener(new VKRequest.VKRequestListener(){

                    @Override
                    public void onComplete(VKResponse response) {
                        VKPhotoArray photos = (VKPhotoArray)response.parsedModel;
                        VKAttachments attachments = new VKAttachments(photos);
                        VKShareDialogDelegate.this.makePostWithAttachments(attachments);
                    }

                    @Override
                    public void onError(VKError error) {
                        VKShareDialogDelegate.this.setIsLoading(false);
                        if (VKShareDialogDelegate.this.mListener != null) {
                            VKShareDialogDelegate.this.mListener.onVkShareError(error);
                        }
                    }
                });
            } else {
                VKShareDialogDelegate.this.makePostWithAttachments(null);
            }
        }
    };

    public VKShareDialogDelegate(DialogFragmentI dialogFragmentI) {
        this.dialogFragmentI = dialogFragmentI;
    }

    public void setAttachmentImages(VKUploadImage[] images) {
        this.mAttachmentImages = images;
    }

    public void setText(CharSequence textToPost) {
        this.mAttachmentText = textToPost;
    }

    public void setAttachmentLink(String linkTitle, String linkUrl) {
        this.mAttachmentLink = new UploadingLink(linkTitle, linkUrl);
    }

    public void setUploadedPhotos(VKPhotoArray photos) {
        this.mExistingPhotos = photos;
    }

    public void setShareDialogListener(VKShareDialogBuilder.VKShareDialogListener listener) {
        this.mListener = listener;
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Activity context = this.dialogFragmentI.getActivity();
        View mInternalView = View.inflate((Context)context, (int)R.layout.vk_share_dialog, null);
        assert (mInternalView != null);
        mInternalView.findViewById(R.id.close_btn).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                VKShareDialogDelegate.this.dialogFragmentI.dismissAllowingStateLoss();
            }
        });
        this.mSendButton = (Button)mInternalView.findViewById(R.id.sendButton);
        this.mSendProgress = (ProgressBar)mInternalView.findViewById(R.id.sendProgress);
        this.mPhotoLayout = (LinearLayout)mInternalView.findViewById(R.id.imagesContainer);
        this.mShareTextField = (EditText)mInternalView.findViewById(R.id.shareText);
        this.mPhotoScroll = (HorizontalScrollView)mInternalView.findViewById(R.id.imagesScrollView);
        LinearLayout mAttachmentLinkLayout = (LinearLayout)mInternalView.findViewById(R.id.attachmentLinkLayout);
        this.mSendButton.setOnClickListener(this.sendButtonPress);
        if (savedInstanceState != null) {
            this.mShareTextField.setText((CharSequence)savedInstanceState.getString(SHARE_TEXT_KEY));
            this.mAttachmentLink = (UploadingLink)savedInstanceState.getParcelable(SHARE_LINK_KEY);
            this.mAttachmentImages = (VKUploadImage[])savedInstanceState.getParcelableArray(SHARE_IMAGES_KEY);
            this.mExistingPhotos = (VKPhotoArray)savedInstanceState.getParcelable(SHARE_UPLOADED_IMAGES_KEY);
        } else if (this.mAttachmentText != null) {
            this.mShareTextField.setText(this.mAttachmentText);
        }
        this.mPhotoLayout.removeAllViews();
        if (this.mAttachmentImages != null) {
            for (VKUploadImage mAttachmentImage : this.mAttachmentImages) {
                this.addBitmapToPreview(mAttachmentImage.mImageData);
            }
            this.mPhotoLayout.setVisibility(0);
        }
        if (this.mExistingPhotos != null) {
            this.processExistingPhotos();
        }
        if (this.mExistingPhotos == null && this.mAttachmentImages == null) {
            this.mPhotoLayout.setVisibility(8);
        }
        if (this.mAttachmentLink != null) {
            TextView linkTitle = (TextView)mAttachmentLinkLayout.findViewById(R.id.linkTitle);
            TextView linkHost = (TextView)mAttachmentLinkLayout.findViewById(R.id.linkHost);
            linkTitle.setText((CharSequence)this.mAttachmentLink.linkTitle);
            linkHost.setText((CharSequence)VKUtil.getHost(this.mAttachmentLink.linkUrl));
            mAttachmentLinkLayout.setVisibility(0);
        } else {
            mAttachmentLinkLayout.setVisibility(8);
        }
        Dialog result = new Dialog((Context)context);
        result.requestWindowFeature(1);
        result.setContentView(mInternalView);
        result.setCancelable(true);
        return result;
    }

    public void onStart() {
        int width = -2;
        if (Build.VERSION.SDK_INT >= 13) {
            WindowManager wm = (WindowManager)this.dialogFragmentI.getActivity().getSystemService("window");
            Display display = wm.getDefaultDisplay();
            Point size = new Point();
            display.getSize(size);
            width = size.x - this.dialogFragmentI.getResources().getDimensionPixelSize(R.dimen.vk_share_dialog_view_padding) * 2;
        }
        WindowManager.LayoutParams lp = new WindowManager.LayoutParams();
        lp.copyFrom(this.dialogFragmentI.getDialog().getWindow().getAttributes());
        lp.height = -2;
        lp.width = width;
        this.dialogFragmentI.getDialog().getWindow().setAttributes(lp);
    }

    public void onSaveInstanceState(Bundle outState) {
        outState.putString(SHARE_TEXT_KEY, this.mShareTextField.getText().toString());
        if (this.mAttachmentLink != null) {
            outState.putParcelable(SHARE_LINK_KEY, (Parcelable)this.mAttachmentLink);
        }
        if (this.mAttachmentImages != null) {
            outState.putParcelableArray(SHARE_IMAGES_KEY, (Parcelable[])this.mAttachmentImages);
        }
        if (this.mExistingPhotos != null) {
            outState.putParcelable(SHARE_UPLOADED_IMAGES_KEY, (Parcelable)this.mExistingPhotos);
        }
    }

    private void setIsLoading(boolean loading) {
        if (loading) {
            this.mSendButton.setVisibility(8);
            this.mSendProgress.setVisibility(0);
            this.mShareTextField.setEnabled(false);
            this.mPhotoLayout.setEnabled(false);
        } else {
            this.mSendButton.setVisibility(0);
            this.mSendProgress.setVisibility(8);
            this.mShareTextField.setEnabled(true);
            this.mPhotoLayout.setEnabled(true);
        }
    }

    private void processExistingPhotos() {
        ArrayList<String> photosToLoad = new ArrayList<String>(this.mExistingPhotos.size());
        for (VKApiPhoto photo : this.mExistingPhotos) {
            photosToLoad.add("" + photo.owner_id + '_' + photo.id);
        }
        VKRequest photosById = new VKRequest("photos.getById", VKParameters.from("photo_sizes", 1, "photos", VKStringJoiner.join(photosToLoad, ",")), VKPhotoArray.class);
        photosById.executeWithListener(new VKRequest.VKRequestListener(){

            @Override
            public void onComplete(VKResponse response) {
                VKPhotoArray photos = (VKPhotoArray)response.parsedModel;
                for (VKApiPhoto photo : photos) {
                    if (photo.src.getByType('q') != null) {
                        VKShareDialogDelegate.this.loadAndAddPhoto(photo.src.getByType('q'));
                        continue;
                    }
                    if (photo.src.getByType('p') != null) {
                        VKShareDialogDelegate.this.loadAndAddPhoto(photo.src.getByType('p'));
                        continue;
                    }
                    if (photo.src.getByType('m') == null) continue;
                    VKShareDialogDelegate.this.loadAndAddPhoto(photo.src.getByType('m'));
                }
            }

            @Override
            public void onError(VKError error) {
                if (VKShareDialogDelegate.this.mListener != null) {
                    VKShareDialogDelegate.this.mListener.onVkShareError(error);
                }
            }
        });
    }

    private void loadAndAddPhoto(String photoUrl) {
        this.loadAndAddPhoto(photoUrl, 0);
    }

    private void loadAndAddPhoto(final String photoUrl, final int attempt) {
        if (attempt > 10) {
            return;
        }
        VKImageOperation op = new VKImageOperation(photoUrl);
        op.setImageOperationListener(new VKImageOperation.VKImageOperationListener(){

            @Override
            public void onComplete(VKImageOperation operation, Bitmap image) {
                if (image == null) {
                    new Handler(Looper.getMainLooper()).postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            VKShareDialogDelegate.this.loadAndAddPhoto(photoUrl, attempt + 1);
                        }
                    }, 1000L);
                    return;
                }
                VKShareDialogDelegate.this.addBitmapToPreview(image);
            }

            @Override
            public void onError(VKImageOperation operation, VKError error) {
            }
        });
        VKHttpClient.enqueueOperation(op);
    }

    private void addBitmapToPreview(Bitmap sourceBitmap) {
        if (this.dialogFragmentI.getActivity() == null) {
            return;
        }
        Bitmap b = VKUIHelper.getRoundedCornerBitmap(sourceBitmap, 100, 3);
        if (b == null) {
            return;
        }
        ImageView iv = new ImageView((Context)this.dialogFragmentI.getActivity());
        iv.setImageBitmap(b);
        iv.setAdjustViewBounds(true);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -2);
        params.setMargins(this.mPhotoLayout.getChildCount() > 0 ? 10 : 0, 0, 0, 0);
        this.mPhotoLayout.addView((View)iv, (ViewGroup.LayoutParams)params);
        this.mPhotoLayout.invalidate();
        this.mPhotoScroll.invalidate();
    }

    private void makePostWithAttachments(VKAttachments attachments) {
        if (attachments == null) {
            attachments = new VKAttachments();
        }
        if (this.mExistingPhotos != null) {
            attachments.addAll(this.mExistingPhotos);
        }
        if (this.mAttachmentLink != null) {
            attachments.add(new VKApiLink(this.mAttachmentLink.linkUrl));
        }
        String message = this.mShareTextField.getText().toString();
        Long userId = Long.parseLong(VKSdk.getAccessToken().userId);
        VKRequest wallPost = VKApi.wall().post(VKParameters.from("owner_id", userId, "message", message, "attachments", attachments.toAttachmentsString()));
        wallPost.executeWithListener(new VKRequest.VKRequestListener(){

            @Override
            public void onError(VKError error) {
                VKShareDialogDelegate.this.setIsLoading(false);
                if (VKShareDialogDelegate.this.mListener != null) {
                    VKShareDialogDelegate.this.mListener.onVkShareError(error);
                }
            }

            @Override
            public void onComplete(VKResponse response) {
                VKShareDialogDelegate.this.setIsLoading(false);
                VKWallPostResult res = (VKWallPostResult)response.parsedModel;
                if (VKShareDialogDelegate.this.mListener != null) {
                    VKShareDialogDelegate.this.mListener.onVkShareComplete(res.post_id);
                }
                VKShareDialogDelegate.this.dialogFragmentI.dismissAllowingStateLoss();
            }
        });
    }

    public void onCancel(DialogInterface dialog) {
        if (this.mListener != null) {
            this.mListener.onVkShareCancel();
        }
    }

    private static class UploadingLink
    implements Parcelable {
        public String linkTitle;
        public String linkUrl;
        public static final Parcelable.Creator<UploadingLink> CREATOR = new Parcelable.Creator<UploadingLink>(){

            public UploadingLink createFromParcel(Parcel source) {
                return new UploadingLink(source);
            }

            public UploadingLink[] newArray(int size) {
                return new UploadingLink[size];
            }
        };

        public UploadingLink(String title, String url) {
            this.linkTitle = title;
            this.linkUrl = url;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.linkTitle);
            dest.writeString(this.linkUrl);
        }

        private UploadingLink(Parcel in) {
            this.linkTitle = in.readString();
            this.linkUrl = in.readString();
        }
    }

    public static interface DialogFragmentI {
        public Activity getActivity();

        public Resources getResources();

        public void dismissAllowingStateLoss();

        public Dialog getDialog();
    }
}

