/*
 * Decompiled with CFR 0.152.
 */
package com.vk.sdk.util;

import com.vk.sdk.api.model.VKApiModel;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class VKJsonHelper {
    public static Object toJSON(Object object) throws JSONException {
        if (object instanceof Map) {
            JSONObject json = new JSONObject();
            Map map = (Map)object;
            for (Object key : map.keySet()) {
                json.put(key.toString(), VKJsonHelper.toJSON(map.get(key)));
            }
            return json;
        }
        if (object instanceof Iterable) {
            JSONArray json = new JSONArray();
            for (Object value : (Iterable)object) {
                json.put(value);
            }
            return json;
        }
        return object;
    }

    public static boolean isEmptyObject(JSONObject object) {
        return object.names() == null;
    }

    public static Map<String, Object> getMap(JSONObject object, String key) throws JSONException {
        return VKJsonHelper.toMap(object.getJSONObject(key));
    }

    public static Map<String, Object> toMap(JSONObject object) throws JSONException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator keys = object.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            map.put(key, VKJsonHelper.fromJson(object.get(key)));
        }
        return map;
    }

    public static List toList(JSONArray array) throws JSONException {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < array.length(); ++i) {
            list.add(VKJsonHelper.fromJson(array.get(i)));
        }
        return list;
    }

    public static Object toArray(JSONArray array, Class arrayClass) {
        Object ret = Array.newInstance(arrayClass.getComponentType(), array.length());
        Class<?> subType = arrayClass.getComponentType();
        for (int i = 0; i < array.length(); ++i) {
            try {
                Object jsonItem = array.get(i);
                Object objItem = subType.newInstance();
                if (!(jsonItem instanceof JSONObject)) continue;
                JSONObject jsonItem2 = (JSONObject)jsonItem;
                if (!(objItem instanceof VKApiModel)) continue;
                VKApiModel objItem2 = (VKApiModel)objItem;
                ((VKApiModel)objItem).parse(jsonItem2);
                Array.set(ret, i, objItem2);
                continue;
            }
            catch (JSONException jSONException) {
                continue;
            }
            catch (InstantiationException instantiationException) {
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return ret;
    }

    private static Object fromJson(Object json) throws JSONException {
        if (json == JSONObject.NULL) {
            return null;
        }
        if (json instanceof JSONObject) {
            return VKJsonHelper.toMap((JSONObject)json);
        }
        if (json instanceof JSONArray) {
            return VKJsonHelper.toList((JSONArray)json);
        }
        return json;
    }
}

