/*
 * Decompiled with CFR 0.152.
 */
package com.vk.sdk.util;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.support.annotation.Nullable;
import com.vk.sdk.api.VKParameters;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class VKUtil {
    @Nullable
    public static Map<String, String> explodeQueryString(@Nullable String queryString) {
        if (queryString == null) {
            return null;
        }
        String[] keyValuePairs = queryString.split("&");
        HashMap<String, String> parameters = new HashMap<String, String>(keyValuePairs.length);
        for (String keyValueString : keyValuePairs) {
            String[] keyValueArray = keyValueString.split("=");
            parameters.put(keyValueArray[0], keyValueArray[1]);
        }
        return parameters;
    }

    public static String fileToString(String filename) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(filename));
        StringBuilder builder = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            builder.append(line);
        }
        reader.close();
        return builder.toString();
    }

    public static void stringToFile(String filename, String stringToWrite) {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(filename));
            writer.write(stringToWrite);
            writer.flush();
            writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String md5(String s) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.update(s.getBytes());
            byte[] messageDigest = digest.digest();
            StringBuilder hexString = new StringBuilder();
            for (byte aMessageDigest : messageDigest) {
                String h = Integer.toHexString(0xFF & aMessageDigest);
                while (h.length() < 2) {
                    h = "0" + h;
                }
                hexString.append(h);
            }
            return hexString.toString();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return "";
        }
    }

    public static String[] getCertificateFingerprint(Context ctx, String packageName) {
        try {
            if (ctx == null || ctx.getPackageManager() == null) {
                return null;
            }
            PackageInfo info = ctx.getPackageManager().getPackageInfo(packageName, 64);
            assert (info.signatures != null);
            String[] result = new String[info.signatures.length];
            int i = 0;
            for (Signature signature : info.signatures) {
                MessageDigest md = MessageDigest.getInstance("SHA");
                md.update(signature.toByteArray());
                result[i++] = VKUtil.toHex(md.digest());
            }
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String toHex(byte[] bytes) {
        BigInteger bi = new BigInteger(1, bytes);
        return String.format("%0" + (bytes.length << 1) + "X", bi);
    }

    public static Map<String, Object> mapFrom(Object ... args) {
        if (args.length % 2 != 0) {
            // empty if block
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(args.length / 2);
        int i = 0;
        while (i + 1 < args.length) {
            if (args[i] != null && args[i + 1] != null && args[i] instanceof String) {
                result.put((String)args[i], args[i + 1]);
            }
            i += 2;
        }
        return result;
    }

    public static VKParameters paramsFrom(Object ... args) {
        return new VKParameters(VKUtil.mapFrom(args));
    }

    public static boolean isAppInstalled(Context context, String uri) {
        boolean appInstalled;
        PackageManager pm = context.getPackageManager();
        try {
            assert (pm != null);
            pm.getPackageInfo(uri, 1);
            appInstalled = true;
        }
        catch (PackageManager.NameNotFoundException e) {
            appInstalled = false;
        }
        return appInstalled;
    }

    public static boolean isIntentAvailable(Context context, String action) {
        PackageManager packageManager = context.getPackageManager();
        Intent intent = new Intent(action);
        assert (packageManager != null);
        List list = packageManager.queryIntentActivities(intent, 65536);
        return list.size() > 0;
    }

    public static String getApplicationName(Context ctx) {
        try {
            Context appContext = ctx.getApplicationContext();
            assert (appContext != null);
            PackageManager pm = appContext.getPackageManager();
            assert (pm != null);
            ApplicationInfo ai = pm.getApplicationInfo(ctx.getPackageName(), 0);
            return ai != null ? pm.getApplicationLabel(ai) : "(unknown)";
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getHost(String url) {
        if (url == null || url.length() == 0) {
            return "";
        }
        int doubleslash = url.indexOf("//");
        doubleslash = doubleslash == -1 ? 0 : (doubleslash += 2);
        int end = url.indexOf(47, doubleslash);
        end = end >= 0 ? end : url.length();
        int port = url.indexOf(58, doubleslash);
        end = port > 0 && port < end ? port : end;
        return url.substring(doubleslash, end);
    }
}

