/*
 * Decompiled with CFR 0.152.
 */
package com.vk.api.sdk;

import android.net.Uri;
import com.vk.api.sdk.internal.HttpMultipartEntry;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001:\u0001\u0016B\u000f\b\u0014\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0017"}, d2={"Lcom/vk/api/sdk/VKHttpPostCall;", "", "b", "Lcom/vk/api/sdk/VKHttpPostCall$Builder;", "(Lcom/vk/api/sdk/VKHttpPostCall$Builder;)V", "parts", "", "", "Lcom/vk/api/sdk/internal/HttpMultipartEntry;", "getParts", "()Ljava/util/Map;", "retryCount", "", "getRetryCount", "()I", "timeoutMs", "", "getTimeoutMs", "()J", "url", "getUrl", "()Ljava/lang/String;", "Builder", "libapi-sdk-core_release"})
public class VKHttpPostCall {
    @NotNull
    private final String url;
    @NotNull
    private final Map<String, HttpMultipartEntry> parts;
    private final int retryCount;
    private final long timeoutMs;

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    @NotNull
    public final Map<String, HttpMultipartEntry> getParts() {
        return this.parts;
    }

    public final int getRetryCount() {
        return this.retryCount;
    }

    public final long getTimeoutMs() {
        return this.timeoutMs;
    }

    protected VKHttpPostCall(@NotNull Builder b) {
        Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
        if (StringsKt.isBlank((CharSequence)b.getUrl())) {
            throw (Throwable)new IllegalArgumentException("Illegal url value: " + b.getUrl());
        }
        if (b.getTimeoutMs() < 0L) {
            throw (Throwable)new IllegalArgumentException("Illegal timeout value: " + b.getTimeoutMs());
        }
        this.url = b.getUrl();
        this.parts = b.getParts();
        this.retryCount = b.getRetryCount();
        this.timeoutMs = b.getTimeoutMs();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J \u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0005H\u0016J\u0018\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0005H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\nH\u0016J\u0010\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u000eH\u0016J\u0010\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0005H\u0016R6\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0003\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001f"}, d2={"Lcom/vk/api/sdk/VKHttpPostCall$Builder;", "", "()V", "<set-?>", "", "", "Lcom/vk/api/sdk/internal/HttpMultipartEntry;", "parts", "getParts", "()Ljava/util/Map;", "", "retryCount", "getRetryCount", "()I", "", "timeoutMs", "getTimeoutMs", "()J", "url", "getUrl", "()Ljava/lang/String;", "args", "key", "fileUri", "Landroid/net/Uri;", "fileName", "value", "build", "Lcom/vk/api/sdk/VKHttpPostCall;", "count", "timeout", "libapi-sdk-core_release"})
    public static class Builder {
        @NotNull
        private String url = "";
        @NotNull
        private Map<String, HttpMultipartEntry> parts = new HashMap();
        private int retryCount = Integer.MAX_VALUE;
        private long timeoutMs;

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        @NotNull
        public final Map<String, HttpMultipartEntry> getParts() {
            return this.parts;
        }

        public final int getRetryCount() {
            return this.retryCount;
        }

        public final long getTimeoutMs() {
            return this.timeoutMs;
        }

        @NotNull
        public Builder url(@NotNull String url) {
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            Builder builder2 = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder2;
            boolean bl3 = false;
            $this$apply.url = url;
            return builder2;
        }

        @NotNull
        public Builder args(@NotNull String key, @NotNull String value2) {
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
            Builder builder2 = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder2;
            boolean bl3 = false;
            $this$apply.parts.put(key, new HttpMultipartEntry.Text(value2));
            return builder2;
        }

        @NotNull
        public Builder args(@NotNull String key, @NotNull Uri fileUri) {
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            Intrinsics.checkParameterIsNotNull((Object)fileUri, (String)"fileUri");
            Builder builder2 = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder2;
            boolean bl3 = false;
            $this$apply.parts.put(key, new HttpMultipartEntry.File(fileUri));
            return builder2;
        }

        @NotNull
        public Builder args(@NotNull String key, @NotNull Uri fileUri, @NotNull String fileName) {
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            Intrinsics.checkParameterIsNotNull((Object)fileUri, (String)"fileUri");
            Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
            Builder builder2 = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder2;
            boolean bl3 = false;
            $this$apply.parts.put(key, new HttpMultipartEntry.File(fileUri, fileName));
            return builder2;
        }

        @NotNull
        public Builder retryCount(int count) {
            Builder builder2 = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder2;
            boolean bl3 = false;
            $this$apply.retryCount = count;
            return builder2;
        }

        @NotNull
        public Builder timeout(long timeout) {
            Builder builder2 = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder2;
            boolean bl3 = false;
            $this$apply.timeoutMs = timeout;
            return builder2;
        }

        @NotNull
        public VKHttpPostCall build() {
            return new VKHttpPostCall(this);
        }
    }
}

