/*
 * Decompiled with CFR 0.152.
 */
package com.vk.api.sdk.chain;

import com.vk.api.sdk.VKApiManager;
import com.vk.api.sdk.VKApiResponseParser;
import com.vk.api.sdk.chain.ChainArgs;
import com.vk.api.sdk.chain.ChainCall;
import com.vk.api.sdk.exceptions.VKApiException;
import com.vk.api.sdk.okhttp.OkHttpExecutor;
import com.vk.api.sdk.okhttp.OkHttpMethodCall;
import com.vk.api.sdk.utils.ApiExtKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B=\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\u0017\u0010\u001a\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u001b\u001a\u00020\u001cH\u0016\u00a2\u0006\u0002\u0010\u001dJ)\u0010\u001e\u001a\u0004\u0018\u00018\u00002\b\u0010\u001f\u001a\u0004\u0018\u00010\n2\u0006\u0010 \u001a\u00020\n2\b\u0010!\u001a\u0004\u0018\u00010\"\u00a2\u0006\u0002\u0010#J\u0017\u0010$\u001a\u0004\u0018\u00018\u00002\u0006\u0010%\u001a\u00020&H\u0016\u00a2\u0006\u0002\u0010'R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0019\u0010\f\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006("}, d2={"Lcom/vk/api/sdk/chain/MethodChainCall;", "T", "Lcom/vk/api/sdk/chain/ChainCall;", "manager", "Lcom/vk/api/sdk/VKApiManager;", "okHttpExecutor", "Lcom/vk/api/sdk/okhttp/OkHttpExecutor;", "callBuilder", "Lcom/vk/api/sdk/okhttp/OkHttpMethodCall$Builder;", "defaultDeviceId", "", "defaultLang", "parser", "Lcom/vk/api/sdk/VKApiResponseParser;", "(Lcom/vk/api/sdk/VKApiManager;Lcom/vk/api/sdk/okhttp/OkHttpExecutor;Lcom/vk/api/sdk/okhttp/OkHttpMethodCall$Builder;Ljava/lang/String;Ljava/lang/String;Lcom/vk/api/sdk/VKApiResponseParser;)V", "getCallBuilder", "()Lcom/vk/api/sdk/okhttp/OkHttpMethodCall$Builder;", "getDefaultDeviceId", "()Ljava/lang/String;", "setDefaultDeviceId", "(Ljava/lang/String;)V", "getDefaultLang", "getOkHttpExecutor", "()Lcom/vk/api/sdk/okhttp/OkHttpExecutor;", "getParser", "()Lcom/vk/api/sdk/VKApiResponseParser;", "call", "args", "Lcom/vk/api/sdk/chain/ChainArgs;", "(Lcom/vk/api/sdk/chain/ChainArgs;)Ljava/lang/Object;", "parseResult", "response", "methodName", "ignoredExecuteErrors", "", "(Ljava/lang/String;Ljava/lang/String;[I)Ljava/lang/Object;", "runRequest", "mc", "Lcom/vk/api/sdk/okhttp/OkHttpMethodCall;", "(Lcom/vk/api/sdk/okhttp/OkHttpMethodCall;)Ljava/lang/Object;", "libapi-sdk-core_release"})
public class MethodChainCall<T>
extends ChainCall<T> {
    @NotNull
    private final OkHttpExecutor okHttpExecutor;
    @NotNull
    private final OkHttpMethodCall.Builder callBuilder;
    @NotNull
    private String defaultDeviceId;
    @NotNull
    private final String defaultLang;
    @Nullable
    private final VKApiResponseParser<T> parser;

    @Override
    @Nullable
    public T call(@NotNull ChainArgs args) throws Exception {
        String lang;
        String deviceId;
        String string2;
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        if (args.hasCaptcha()) {
            this.callBuilder.args("captcha_sid", args.getCaptchaSid()).args("captcha_key", args.getCaptchaKey());
        }
        if (args.getUserConfirmed()) {
            this.callBuilder.args("confirm", "1");
        }
        if ((string2 = this.callBuilder.args("device_id")) == null) {
            string2 = deviceId = "";
        }
        if (StringsKt.isBlank((CharSequence)deviceId)) {
            deviceId = this.defaultDeviceId;
        }
        String string3 = deviceId;
        String string4 = "device_id";
        OkHttpMethodCall.Builder builder2 = this.callBuilder;
        boolean bl = false;
        String string5 = string3;
        if (string5 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string6 = string5.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).toLowerCase()");
        String string7 = string6;
        builder2.args(string4, string7);
        String string8 = this.callBuilder.args("lang");
        if (string8 == null) {
            string8 = lang = "";
        }
        if (StringsKt.isBlank((CharSequence)lang)) {
            lang = this.defaultLang;
        }
        String string9 = lang;
        string4 = "lang";
        builder2 = this.callBuilder;
        boolean bl2 = false;
        String string10 = string9;
        if (string10 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string11 = string10.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string11, (String)"(this as java.lang.String).toLowerCase()");
        string7 = string11;
        builder2.args(string4, string7);
        return this.runRequest(this.callBuilder.build());
    }

    @Nullable
    public T runRequest(@NotNull OkHttpMethodCall mc) {
        Intrinsics.checkParameterIsNotNull((Object)mc, (String)"mc");
        return this.parseResult(this.okHttpExecutor.execute(mc), mc.getMethod(), null);
    }

    @Nullable
    public final T parseResult(@Nullable String response, @NotNull String methodName, @Nullable int[] ignoredExecuteErrors) {
        Intrinsics.checkParameterIsNotNull((Object)methodName, (String)"methodName");
        if (response == null) {
            throw (Throwable)new VKApiException("Response returned null instead of valid string response");
        }
        if (ApiExtKt.hasSimpleError(response)) {
            throw (Throwable)ApiExtKt.toSimpleError(response, methodName);
        }
        if (ApiExtKt.hasExecuteError(response, ignoredExecuteErrors)) {
            throw (Throwable)ApiExtKt.toExecuteError(response, methodName, ignoredExecuteErrors);
        }
        VKApiResponseParser<T> vKApiResponseParser = this.parser;
        return (T)(vKApiResponseParser != null ? vKApiResponseParser.parse(response) : null);
    }

    @NotNull
    public final OkHttpExecutor getOkHttpExecutor() {
        return this.okHttpExecutor;
    }

    @NotNull
    public final OkHttpMethodCall.Builder getCallBuilder() {
        return this.callBuilder;
    }

    @NotNull
    public final String getDefaultDeviceId() {
        return this.defaultDeviceId;
    }

    public final void setDefaultDeviceId(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"<set-?>");
        this.defaultDeviceId = string2;
    }

    @NotNull
    public final String getDefaultLang() {
        return this.defaultLang;
    }

    @Nullable
    public final VKApiResponseParser<T> getParser() {
        return this.parser;
    }

    public MethodChainCall(@NotNull VKApiManager manager, @NotNull OkHttpExecutor okHttpExecutor, @NotNull OkHttpMethodCall.Builder callBuilder, @NotNull String defaultDeviceId, @NotNull String defaultLang, @Nullable VKApiResponseParser<T> parser) {
        Intrinsics.checkParameterIsNotNull((Object)manager, (String)"manager");
        Intrinsics.checkParameterIsNotNull((Object)okHttpExecutor, (String)"okHttpExecutor");
        Intrinsics.checkParameterIsNotNull((Object)callBuilder, (String)"callBuilder");
        Intrinsics.checkParameterIsNotNull((Object)defaultDeviceId, (String)"defaultDeviceId");
        Intrinsics.checkParameterIsNotNull((Object)defaultLang, (String)"defaultLang");
        super(manager);
        this.okHttpExecutor = okHttpExecutor;
        this.callBuilder = callBuilder;
        this.defaultDeviceId = defaultDeviceId;
        this.defaultLang = defaultLang;
        this.parser = parser;
    }
}

