/*
 * Decompiled with CFR 0.152.
 */
package com.vk.api.sdk.internal;

import android.util.JsonReader;
import android.util.JsonToken;
import android.util.MalformedJsonException;
import java.io.Reader;
import java.io.StringReader;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a8\u0006\t"}, d2={"Lcom/vk/api/sdk/internal/JsonUtils;", "", "()V", "containsElement", "", "jsonString", "", "name", "containsElementImpl", "libapi-sdk-core_release"})
public final class JsonUtils {
    public static final JsonUtils INSTANCE;

    public final boolean containsElement(@NotNull String jsonString, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)jsonString, (String)"jsonString");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        try {
            return this.containsElementImpl(jsonString, name);
        }
        catch (MalformedJsonException ex) {
            throw (Throwable)new MalformedJsonException(ex.getMessage() + ". Json: '" + jsonString + '\'');
        }
    }

    private final boolean containsElementImpl(String jsonString, String name) {
        JsonToken nextToken;
        CharSequence charSequence = jsonString;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return false;
        }
        JsonReader reader = new JsonReader((Reader)new StringReader(jsonString));
        if (reader.hasNext() && reader.peek() == JsonToken.BEGIN_OBJECT) {
            reader.beginObject();
        } else {
            return false;
        }
        while (reader.hasNext() && (nextToken = reader.peek()) != JsonToken.END_DOCUMENT) {
            if (nextToken != JsonToken.NAME) {
                reader.skipValue();
                continue;
            }
            if (!Intrinsics.areEqual((Object)name, (Object)reader.nextName())) continue;
            return true;
        }
        return false;
    }

    private JsonUtils() {
    }

    static {
        JsonUtils jsonUtils;
        INSTANCE = jsonUtils = new JsonUtils();
    }
}

