/*
 * Decompiled with CFR 0.152.
 */
package com.vk.api.sdk.internal;

import android.os.Bundle;
import com.vk.api.sdk.exceptions.VKApiException;
import com.vk.api.sdk.exceptions.VKApiExecutionException;
import com.vk.api.sdk.exceptions.VKApiIllegalResponseException;
import com.vk.api.sdk.internal.JsonUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u000e\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00072\b\u0010\u0011\u001a\u0004\u0018\u00010\fJ\"\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00072\b\u0010\u0011\u001a\u0004\u0018\u00010\fH\u0002J\u001a\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00072\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0007J\u001a\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0007\u00a8\u0006\u0017"}, d2={"Lcom/vk/api/sdk/internal/VKErrorUtils;", "", "()V", "executeErrorsSet", "", "", "jsonString", "", "hasExecuteError", "", "response", "ignoreErrors", "", "hasSimpleError", "parseExecuteError", "Lcom/vk/api/sdk/exceptions/VKApiException;", "method", "ignoredErrors", "errorsJson", "Lorg/json/JSONArray;", "parseSimpleError", "errorJson", "Lorg/json/JSONObject;", "libapi-sdk-core_release"})
public final class VKErrorUtils {
    public static final VKErrorUtils INSTANCE;

    public final boolean hasSimpleError(@NotNull String response) {
        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
        return JsonUtils.INSTANCE.containsElement(response, "error");
    }

    public final boolean hasExecuteError(@NotNull String response, @Nullable int[] ignoreErrors) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
        if (!JsonUtils.INSTANCE.containsElement(response, "execute_errors")) {
            bl = false;
        } else if (ignoreErrors == null) {
            bl = true;
        } else {
            Set<Integer> errors = this.executeErrorsSet(response);
            int[] $this$forEach$iv = ignoreErrors;
            boolean $i$f$forEach = false;
            int[] nArray = $this$forEach$iv;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int element$iv;
                int it = element$iv = nArray[i];
                boolean bl2 = false;
                errors.remove(it);
            }
            Collection collection = errors;
            boolean bl3 = false;
            bl = !collection.isEmpty();
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<Integer> executeErrorsSet(String jsonString) {
        HashSet<Integer> set = new HashSet<Integer>();
        JSONObject jo = new JSONObject(jsonString);
        JSONArray jaErrors = jo.getJSONArray("execute_errors");
        int n = 0;
        int n2 = jaErrors.length();
        while (n < n2) {
            void i;
            set.add(jaErrors.getJSONObject((int)i).getInt("error_code"));
            ++i;
        }
        return set;
    }

    @NotNull
    public final VKApiException parseSimpleError(@NotNull String errorJson, @Nullable String method) {
        Intrinsics.checkParameterIsNotNull((Object)errorJson, (String)"errorJson");
        JSONObject jSONObject = new JSONObject(errorJson).optJSONObject("error");
        Intrinsics.checkExpressionValueIsNotNull((Object)jSONObject, (String)"JSONObject(errorJson).op\u2026t(VKApiCodes.PARAM_ERROR)");
        return this.parseSimpleError(jSONObject, method);
    }

    public static /* synthetic */ VKApiException parseSimpleError$default(VKErrorUtils vKErrorUtils, String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string3 = null;
        }
        return vKErrorUtils.parseSimpleError(string2, string3);
    }

    @NotNull
    public final VKApiException parseSimpleError(@NotNull JSONObject errorJson, @Nullable String method) {
        Intrinsics.checkParameterIsNotNull((Object)errorJson, (String)"errorJson");
        try {
            Bundle bundle;
            int code = errorJson.getInt("error_code");
            switch (code) {
                case 14: {
                    Bundle extra = new Bundle();
                    extra.putString("captcha_sid", errorJson.getString("captcha_sid"));
                    extra.putString("captcha_img", errorJson.getString("captcha_img"));
                    bundle = extra;
                    break;
                }
                case 17: {
                    Bundle extra = new Bundle();
                    extra.putString("validation_url", errorJson.getString("redirect_uri"));
                    bundle = extra;
                    break;
                }
                case 24: {
                    Bundle extra = new Bundle();
                    extra.putString("confirmation_text", errorJson.getString("confirmation_text"));
                    bundle = extra;
                    break;
                }
                case 5: {
                    Bundle extra;
                    JSONObject jSONObject = errorJson.optJSONObject("ban_info");
                    if (jSONObject != null) {
                        extra = jSONObject;
                        boolean bl = false;
                        boolean bl2 = false;
                        Bundle it = extra;
                        boolean bl3 = false;
                        Bundle extra2 = new Bundle();
                        extra2.putString("user_ban_info", it.toString());
                        bundle = extra2;
                        break;
                    }
                    bundle = null;
                    break;
                }
                case 3609: {
                    Bundle extra = new Bundle();
                    extra.putString("extend_hash", errorJson.optString("extend_hash", null));
                    bundle = extra;
                    break;
                }
                default: {
                    bundle = null;
                }
            }
            Bundle bundle2 = bundle;
            return VKApiExecutionException.Companion.parse(errorJson, method, bundle2);
        }
        catch (Exception e) {
            return new VKApiIllegalResponseException(e);
        }
    }

    public static /* synthetic */ VKApiException parseSimpleError$default(VKErrorUtils vKErrorUtils, JSONObject jSONObject, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return vKErrorUtils.parseSimpleError(jSONObject, string2);
    }

    @NotNull
    public final VKApiException parseExecuteError(@NotNull String response, @NotNull String method, @Nullable int[] ignoredErrors) {
        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        JSONArray jSONArray = new JSONObject(response).getJSONArray("execute_errors");
        Intrinsics.checkExpressionValueIsNotNull((Object)jSONArray, (String)"JSONObject(response).get\u2026des.PARAM_EXECUTE_ERRORS)");
        return this.parseExecuteError(jSONArray, method, ignoredErrors);
    }

    /*
     * WARNING - void declaration
     */
    private final VKApiException parseExecuteError(JSONArray errorsJson, String method, int[] ignoredErrors) {
        try {
            ArrayList<VKApiException> nonCriticalErrors = new ArrayList<VKApiException>();
            int n = 0;
            int n2 = errorsJson.length();
            while (n < n2) {
                void i;
                JSONObject jSONObject = errorsJson.getJSONObject((int)i);
                Intrinsics.checkExpressionValueIsNotNull((Object)jSONObject, (String)"errorsJson.getJSONObject(i)");
                VKApiException parsedError = VKErrorUtils.parseSimpleError$default(this, jSONObject, null, 2, null);
                if (!(parsedError instanceof VKApiExecutionException)) {
                    return parsedError;
                }
                switch (((VKApiExecutionException)parsedError).getCode()) {
                    case 1: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 9: 
                    case 10: 
                    case 14: 
                    case 17: 
                    case 24: 
                    case 25: {
                        return parsedError;
                    }
                }
                if (ignoredErrors == null || !ArraysKt.contains((int[])ignoredErrors, (int)((VKApiExecutionException)parsedError).getCode())) {
                    nonCriticalErrors.add(parsedError);
                }
                ++i;
            }
            return new VKApiExecutionException(Integer.MIN_VALUE, method, false, "", null, nonCriticalErrors, null, 64, null);
        }
        catch (JSONException e) {
            return new VKApiIllegalResponseException(e);
        }
    }

    private VKErrorUtils() {
    }

    static {
        VKErrorUtils vKErrorUtils;
        INSTANCE = vKErrorUtils = new VKErrorUtils();
    }
}

