/*
 * Decompiled with CFR 0.152.
 */
package com.vk.api.sdk.utils;

import androidx.annotation.WorkerThread;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0016\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB-\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0014J\u0006\u0010\u0016\u001a\u00020\u0014J\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0006H\u0002J\b\u0010\u001b\u001a\u00020\u0014H\u0007R\u001e\u0010\n\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001e\u0010\u000e\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/vk/api/sdk/utils/ExponentialBackoff;", "", "minDelayMs", "", "maxDelayMs", "factor", "", "jitter", "(JJFF)V", "<set-?>", "delayMs", "getDelayMs", "()J", "", "errorsCount", "getErrorsCount", "()I", "random", "Ljava/util/Random;", "increase", "", "onError", "reset", "shouldWait", "", "variance", "std", "waitIfNeeded", "Companion", "libapi-sdk-core_release"})
public class ExponentialBackoff {
    private final Random random;
    private volatile long delayMs;
    private volatile int errorsCount;
    private final long minDelayMs;
    private final long maxDelayMs;
    private final float factor;
    private final float jitter;
    public static final Companion Companion = new Companion(null);

    public final long getDelayMs() {
        return this.delayMs;
    }

    public final int getErrorsCount() {
        return this.errorsCount;
    }

    public final boolean shouldWait() {
        return this.errorsCount > 0;
    }

    @WorkerThread
    public final void waitIfNeeded() {
        if (this.shouldWait()) {
            Thread.sleep(this.delayMs);
        }
    }

    public final void reset() {
        this.delayMs = this.minDelayMs;
        this.errorsCount = 0;
    }

    public final void onError() {
        this.increase();
    }

    public final void increase() {
        float f = (float)this.delayMs * this.factor;
        float f2 = this.maxDelayMs;
        ExponentialBackoff exponentialBackoff = this;
        boolean bl = false;
        float f3 = Math.min(f, f2);
        exponentialBackoff.delayMs = (long)f3;
        this.delayMs += this.variance((float)this.delayMs * this.jitter);
        int n = this.errorsCount;
        this.errorsCount = n + 1;
    }

    private final long variance(float std) {
        return (long)(this.random.nextGaussian() * (double)std);
    }

    public ExponentialBackoff(long minDelayMs, long maxDelayMs, float factor, float jitter) {
        this.minDelayMs = minDelayMs;
        this.maxDelayMs = maxDelayMs;
        this.factor = factor;
        this.jitter = jitter;
        this.random = new Random(System.currentTimeMillis());
        this.delayMs = this.minDelayMs;
    }

    public /* synthetic */ ExponentialBackoff(long l, long l2, float f, float f2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            l = TimeUnit.MILLISECONDS.toMillis(100L);
        }
        if ((n & 2) != 0) {
            l2 = TimeUnit.MINUTES.toMillis(5L);
        }
        if ((n & 4) != 0) {
            f = 2.0f;
        }
        if ((n & 8) != 0) {
            f2 = 0.1f;
        }
        this(l, l2, f, f2);
    }

    public ExponentialBackoff() {
        this(0L, 0L, 0.0f, 0.0f, 15, null);
    }

    @JvmStatic
    @NotNull
    public static final ExponentialBackoff forNetworkWait() {
        return Companion.forNetworkWait();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lcom/vk/api/sdk/utils/ExponentialBackoff$Companion;", "", "()V", "forNetworkWait", "Lcom/vk/api/sdk/utils/ExponentialBackoff;", "libapi-sdk-core_release"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final ExponentialBackoff forNetworkWait() {
            return new ExponentialBackoff(500L, 60000L, 1.5f, 0.0f, 8, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

