/*
 * Decompiled with CFR 0.152.
 */
package com.vk.api.sdk.utils;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.Signature;
import android.content.res.Resources;
import android.os.Build;
import android.util.DisplayMetrics;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import com.vk.api.sdk.utils.ThreadLocalDelegate;
import com.vk.api.sdk.utils.ThreadLocalDelegateKt;
import com.vk.api.sdk.utils.VKUtils;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001eB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\nJ \u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0007J)\u0010\u000f\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\r\u0018\u00010\u00102\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0011\u001a\u00020\rH\u0007\u00a2\u0006\u0002\u0010\u0012J\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\rH\u0007J\u0018\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\rH\u0007J\u0010\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u000e\u0010\u001d\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u001f"}, d2={"Lcom/vk/api/sdk/utils/VKUtils;", "", "()V", "clearAllCookies", "", "context", "Landroid/content/Context;", "density", "", "dp", "", "explodeQueryString", "", "", "queryString", "getCertificateFingerprint", "", "packageName", "(Landroid/content/Context;Ljava/lang/String;)[Ljava/lang/String;", "getDisplayMetrics", "Landroid/util/DisplayMetrics;", "height", "isAppInstalled", "", "isIntentAvailable", "action", "toHex", "bytes", "", "width", "MD5", "libapi-sdk-core_release"})
public final class VKUtils {
    public static final VKUtils INSTANCE;

    @JvmStatic
    public static final boolean isAppInstalled(@NotNull Context context, @NotNull String packageName) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)packageName, (String)"packageName");
        try {
            context.getPackageManager().getPackageInfo(packageName, 1);
            bl = true;
        }
        catch (Throwable e) {
            bl = false;
        }
        return bl;
    }

    @JvmStatic
    public static final boolean isIntentAvailable(@NotNull Context context, @NotNull String action) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)action, (String)"action");
        Object object = context.getPackageManager();
        return object != null && (object = object.queryIntentActivities(new Intent(action), 65536)) != null ? CollectionsKt.any((Iterable)((Iterable)object)) : false;
    }

    @JvmStatic
    @Nullable
    public static final Map<String, String> explodeQueryString(@Nullable String queryString) {
        if (queryString == null) {
            return null;
        }
        List keyValuePairs = StringsKt.split$default((CharSequence)queryString, (String[])new String[]{"&"}, (boolean)false, (int)0, (int)6, null);
        HashMap parameters = new HashMap(keyValuePairs.size());
        for (String keyValueString : keyValuePairs) {
            List keyValueArray = StringsKt.split$default((CharSequence)keyValueString, (String[])new String[]{"="}, (boolean)false, (int)0, (int)6, null);
            if (keyValueArray.size() <= 1) continue;
            ((Map)parameters).put(keyValueArray.get(0), keyValueArray.get(1));
        }
        return parameters;
    }

    @JvmStatic
    @Nullable
    public static final String[] getCertificateFingerprint(@Nullable Context context, @NotNull String packageName) {
        Intrinsics.checkParameterIsNotNull((Object)packageName, (String)"packageName");
        try {
            if (context == null || context.getPackageManager() == null) {
                return null;
            }
            PackageInfo info = context.getPackageManager().getPackageInfo(packageName, 64);
            boolean bl = info.signatures != null;
            boolean bl2 = false;
            boolean bl3 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl4 = false;
                String string2 = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
            String[] result = new String[info.signatures.length];
            int i = 0;
            Intrinsics.checkExpressionValueIsNotNull((Object)info.signatures, (String)"info.signatures");
            Signature[] $this$forEach$iv = info.signatures;
            boolean $i$f$forEach = false;
            Signature[] signatureArray = $this$forEach$iv;
            int n = signatureArray.length;
            for (int j = 0; j < n; ++j) {
                Signature element$iv;
                Signature it = element$iv = signatureArray[j];
                boolean bl5 = false;
                MessageDigest md = MessageDigest.getInstance("SHA");
                md.update(it.toByteArray());
                int n2 = i;
                i = n2 + 1;
                byte[] byArray = md.digest();
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"md.digest()");
                result[n2] = INSTANCE.toHex(byArray);
            }
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }

    public final void clearAllCookies(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        CookieManager cookieManager = CookieManager.getInstance();
        if (Build.VERSION.SDK_INT >= 21) {
            cookieManager.removeAllCookies(null);
        } else {
            CookieSyncManager cookieSyncManager = CookieSyncManager.createInstance((Context)context);
            cookieSyncManager.startSync();
            cookieManager.removeAllCookie();
            cookieSyncManager.stopSync();
        }
    }

    private final String toHex(byte[] bytes) {
        BigInteger bi = new BigInteger(1, bytes);
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string2 = "%0" + (bytes.length << 1) + "X";
        Object[] objectArray = new Object[]{bi};
        boolean bl = false;
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(format, *args)");
        return string3;
    }

    public final int dp(int dp) {
        return (int)Math.ceil((float)dp * this.density());
    }

    public final float density() {
        return this.getDisplayMetrics().density;
    }

    @NotNull
    public final DisplayMetrics getDisplayMetrics() {
        Resources resources = Resources.getSystem();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"Resources.getSystem()");
        DisplayMetrics displayMetrics = resources.getDisplayMetrics();
        Intrinsics.checkExpressionValueIsNotNull((Object)displayMetrics, (String)"Resources.getSystem().displayMetrics");
        return displayMetrics;
    }

    public final int height(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Resources resources = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        return resources.getDisplayMetrics().heightPixels;
    }

    public final int width(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Resources resources = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        return resources.getDisplayMetrics().widthPixels;
    }

    private VKUtils() {
    }

    static {
        VKUtils vKUtils;
        INSTANCE = vKUtils = new VKUtils();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0007J\u0010\u0010\u0003\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0003R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u0005\u001a\u00060\u0006j\u0002`\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lcom/vk/api/sdk/utils/VKUtils$MD5;", "", "()V", "hex", "", "tmpBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getTmpBuilder", "()Ljava/lang/StringBuilder;", "tmpBuilder$delegate", "Lcom/vk/api/sdk/utils/ThreadLocalDelegate;", "convert", "", "h", "", "b", "", "libapi-sdk-core_release"})
    public static final class MD5 {
        static final /* synthetic */ KProperty[] $$delegatedProperties;
        private static final char[] hex;
        private static final ThreadLocalDelegate tmpBuilder$delegate;
        public static final MD5 INSTANCE;

        static {
            MD5 mD5;
            $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(MD5.class), "tmpBuilder", "getTmpBuilder()Ljava/lang/StringBuilder;"))};
            INSTANCE = mD5 = new MD5();
            hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
            tmpBuilder$delegate = ThreadLocalDelegateKt.threadLocal(tmpBuilder.2.INSTANCE);
        }

        private final StringBuilder getTmpBuilder() {
            return (StringBuilder)ThreadLocalDelegateKt.getValue(tmpBuilder$delegate, this, $$delegatedProperties[0]);
        }

        @JvmStatic
        @NotNull
        public static final String convert(@NotNull String h) {
            Intrinsics.checkParameterIsNotNull((Object)h, (String)"h");
            try {
                Object object;
                MessageDigest md = MessageDigest.getInstance("MD5");
                String string2 = h;
                Object object2 = "UTF-8";
                MessageDigest messageDigest = md;
                boolean bl = false;
                Charset charset = Charset.forName((String)object2);
                Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"Charset.forName(charsetName)");
                object2 = object = charset;
                bl = false;
                byte[] byArray = string2.getBytes((Charset)object2);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                object = byArray;
                byte[] md52 = messageDigest.digest((byte[])object);
                INSTANCE.getTmpBuilder().setLength(0);
                Intrinsics.checkExpressionValueIsNotNull((Object)md52, (String)"md5");
                MD5.hex(md52);
                String string3 = INSTANCE.getTmpBuilder().toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"tmpBuilder.toString()");
                return string3;
            }
            catch (Exception exception) {
                return "";
            }
        }

        @JvmStatic
        private static final void hex(byte[] b) {
            for (byte aB : b) {
                INSTANCE.getTmpBuilder().append(hex[(aB & 0xF0) >> 4]);
                INSTANCE.getTmpBuilder().append(hex[aB & 0xF]);
            }
        }

        private MD5() {
        }
    }
}

