/*
 * Decompiled with CFR 0.152.
 */
package com.vk.api.sdk.streaming.queries.stream;

import com.google.gson.Gson;
import com.vk.api.sdk.streaming.clients.StreamingEventHandler;
import com.vk.api.sdk.streaming.clients.VkStreamingApiClient;
import com.vk.api.sdk.streaming.clients.actors.StreamingActor;
import com.vk.api.sdk.streaming.clients.websocket.WSMessageListener;
import com.vk.api.sdk.streaming.clients.websocket.WSPingListener;
import java.util.concurrent.ExecutionException;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.ws.WebSocket;
import org.asynchttpclient.ws.WebSocketListener;
import org.asynchttpclient.ws.WebSocketUpgradeHandler;

public class StreamingStreamQuery {
    private static final String WEB_SOCKET_SCHEMA = "wss://";
    private StreamingEventHandler handler;
    private Gson gson;
    private String url;
    private AsyncHttpClient client;

    public StreamingStreamQuery(VkStreamingApiClient client, StreamingActor actor, StreamingEventHandler handler) {
        this.client = client.getAsyncHttpClient();
        this.gson = client.getGson();
        this.url = this.buildUrl(actor);
        this.handler = handler;
    }

    public WebSocket execute() throws ExecutionException, InterruptedException {
        return (WebSocket)this.client.prepareGet(this.url).execute((AsyncHandler)new WebSocketUpgradeHandler.Builder().addWebSocketListener((WebSocketListener)new WSMessageListener(this.gson, this.handler)).addWebSocketListener((WebSocketListener)new WSPingListener()).build()).get();
    }

    private String buildUrl(StreamingActor actor) {
        return WEB_SOCKET_SCHEMA + actor.getEndpoint() + "/stream?key=" + actor.getKey();
    }
}

