// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.actions;

import com.vk.api.sdk.client.AbstractAction;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.objects.ads.CheckLinkLinkType;
import com.vk.api.sdk.objects.ads.GetDemographicsIdsType;
import com.vk.api.sdk.objects.ads.GetDemographicsPeriod;
import com.vk.api.sdk.objects.ads.GetPostsReachIdsType;
import com.vk.api.sdk.objects.ads.GetStatisticsIdsType;
import com.vk.api.sdk.objects.ads.GetStatisticsPeriod;
import com.vk.api.sdk.objects.ads.GetSuggestionsSection;
import com.vk.api.sdk.objects.ads.GetUploadURLAdFormat;
import com.vk.api.sdk.objects.ads.UserSpecification;
import com.vk.api.sdk.objects.ads.UserSpecificationCutted;
import com.vk.api.sdk.objects.annotations.ApiMethod;
import com.vk.api.sdk.queries.ads.AdsAddOfficeUsersQuery;
import com.vk.api.sdk.queries.ads.AdsCheckLinkQuery;
import com.vk.api.sdk.queries.ads.AdsCreateAdsQuery;
import com.vk.api.sdk.queries.ads.AdsCreateCampaignsQuery;
import com.vk.api.sdk.queries.ads.AdsCreateClientsQuery;
import com.vk.api.sdk.queries.ads.AdsCreateLookalikeRequestQuery;
import com.vk.api.sdk.queries.ads.AdsCreateTargetGroupQuery;
import com.vk.api.sdk.queries.ads.AdsCreateTargetPixelQuery;
import com.vk.api.sdk.queries.ads.AdsDeleteAdsQuery;
import com.vk.api.sdk.queries.ads.AdsDeleteCampaignsQuery;
import com.vk.api.sdk.queries.ads.AdsDeleteClientsQuery;
import com.vk.api.sdk.queries.ads.AdsDeleteTargetGroupQuery;
import com.vk.api.sdk.queries.ads.AdsDeleteTargetPixelQuery;
import com.vk.api.sdk.queries.ads.AdsGetAccountsQuery;
import com.vk.api.sdk.queries.ads.AdsGetAdsLayoutQuery;
import com.vk.api.sdk.queries.ads.AdsGetAdsQuery;
import com.vk.api.sdk.queries.ads.AdsGetAdsTargetingQuery;
import com.vk.api.sdk.queries.ads.AdsGetBudgetQuery;
import com.vk.api.sdk.queries.ads.AdsGetCampaignsQuery;
import com.vk.api.sdk.queries.ads.AdsGetCategoriesQuery;
import com.vk.api.sdk.queries.ads.AdsGetClientsQuery;
import com.vk.api.sdk.queries.ads.AdsGetDemographicsQuery;
import com.vk.api.sdk.queries.ads.AdsGetFloodStatsQuery;
import com.vk.api.sdk.queries.ads.AdsGetLookalikeRequestsQuery;
import com.vk.api.sdk.queries.ads.AdsGetMusiciansByIdsQuery;
import com.vk.api.sdk.queries.ads.AdsGetMusiciansQuery;
import com.vk.api.sdk.queries.ads.AdsGetOfficeUsersQuery;
import com.vk.api.sdk.queries.ads.AdsGetPostsReachQuery;
import com.vk.api.sdk.queries.ads.AdsGetRejectionReasonQuery;
import com.vk.api.sdk.queries.ads.AdsGetStatisticsQuery;
import com.vk.api.sdk.queries.ads.AdsGetSuggestionsQuery;
import com.vk.api.sdk.queries.ads.AdsGetSuggestionsQueryWithCities;
import com.vk.api.sdk.queries.ads.AdsGetSuggestionsQueryWithRegions;
import com.vk.api.sdk.queries.ads.AdsGetSuggestionsQueryWithSchools;
import com.vk.api.sdk.queries.ads.AdsGetTargetGroupsQuery;
import com.vk.api.sdk.queries.ads.AdsGetTargetPixelsQuery;
import com.vk.api.sdk.queries.ads.AdsGetTargetingStatsQuery;
import com.vk.api.sdk.queries.ads.AdsGetUploadURLQuery;
import com.vk.api.sdk.queries.ads.AdsGetVideoUploadURLQuery;
import com.vk.api.sdk.queries.ads.AdsImportTargetContactsQuery;
import com.vk.api.sdk.queries.ads.AdsRemoveOfficeUsersQuery;
import com.vk.api.sdk.queries.ads.AdsRemoveTargetContactsQuery;
import com.vk.api.sdk.queries.ads.AdsSaveLookalikeRequestResultQuery;
import com.vk.api.sdk.queries.ads.AdsShareTargetGroupQuery;
import com.vk.api.sdk.queries.ads.AdsUpdateAdsQuery;
import com.vk.api.sdk.queries.ads.AdsUpdateCampaignsQuery;
import com.vk.api.sdk.queries.ads.AdsUpdateClientsQuery;
import com.vk.api.sdk.queries.ads.AdsUpdateOfficeUsersQuery;
import com.vk.api.sdk.queries.ads.AdsUpdateTargetGroupQuery;
import com.vk.api.sdk.queries.ads.AdsUpdateTargetPixelQuery;
import java.util.List;

/**
 * List of Ads methods
 */
public class Ads extends AbstractAction {
    /**
     * Constructor
     *
     * @param client vk api client
     */
    public Ads(VkApiClient client) {
        super(client);
    }

    /**
     * Adds managers and/or supervisors to advertising account.
     *
     * @param actor vk user actor
     * @param accountId Advertising account ID.
     * @param data Serialized JSON array of objects that describe added managers. Description of 'user_specification' objects see below.
     * @return query
     */
    @ApiMethod("ads.addOfficeUsers")
    public AdsAddOfficeUsersQuery addOfficeUsers(UserActor actor, Integer accountId,
            UserSpecificationCutted... data) {
        return new AdsAddOfficeUsersQuery(getClient(), actor, accountId, data);
    }

    /**
     * Adds managers and/or supervisors to advertising account.
     *
     * @param actor vk user actor
     * @param accountId Advertising account ID.
     * @param data Serialized JSON array of objects that describe added managers. Description of 'user_specification' objects see below.
     * @return query
     */
    @ApiMethod("ads.addOfficeUsers")
    public AdsAddOfficeUsersQuery addOfficeUsers(UserActor actor, Integer accountId,
            List<UserSpecificationCutted> data) {
        return new AdsAddOfficeUsersQuery(getClient(), actor, accountId, data);
    }

    /**
     * Adds managers and/or supervisors to advertising account.
     *
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("ads.addOfficeUsers")
    public AdsAddOfficeUsersQuery addOfficeUsers(UserActor actor) {
        return new AdsAddOfficeUsersQuery(getClient(), actor);
    }

    /**
     * Allows to check the ad link.
     *
     * @param actor vk user actor
     * @param accountId Advertising account ID.
     * @param linkType Object type: *'community' - community,, *'post' - community post,, *'application' - VK application,, *'video' - video,, *'site' - external site.
     * @param linkUrl Object URL.
     * @return query
     */
    @ApiMethod("ads.checkLink")
    public AdsCheckLinkQuery checkLink(UserActor actor, Integer accountId,
            CheckLinkLinkType linkType, String linkUrl) {
        return new AdsCheckLinkQuery(getClient(), actor, accountId, linkType, linkUrl);
    }

    /**
     * Allows to check the ad link.
     *
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("ads.checkLink")
    public AdsCheckLinkQuery checkLink(UserActor actor) {
        return new AdsCheckLinkQuery(getClient(), actor);
    }

    /**
     * Creates ads.
     *
     * @param actor vk user actor
     * @param accountId Advertising account ID.
     * @param data Serialized JSON array of objects that describe created ads. Description of 'ad_specification' objects see below.
     * @return query
     */
    @ApiMethod("ads.createAds")
    public AdsCreateAdsQuery createAds(UserActor actor, Integer accountId, String data) {
        return new AdsCreateAdsQuery(getClient(), actor, accountId, data);
    }

    /**
     * Creates ads.
     *
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("ads.createAds")
    public AdsCreateAdsQuery createAds(UserActor actor) {
        return new AdsCreateAdsQuery(getClient(), actor);
    }

    /**
     * Creates advertising campaigns.
     *
     * @param actor vk user actor
     * @param accountId Advertising account ID.
     * @param data Serialized JSON array of objects that describe created campaigns. Description of 'campaign_specification' objects see below.
     * @return query
     */
    @ApiMethod("ads.createCampaigns")
    public AdsCreateCampaignsQuery createCampaigns(UserActor actor, Integer accountId,
            String data) {
        return new AdsCreateCampaignsQuery(getClient(), actor, accountId, data);
    }

    /**
     * Creates advertising campaigns.
     *
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("ads.createCampaigns")
    public AdsCreateCampaignsQuery createCampaigns(UserActor actor) {
        return new AdsCreateCampaignsQuery(getClient(), actor);
    }

    /**
     * Creates clients of an advertising agency.
     *
     * @param actor vk user actor
     * @param accountId Advertising account ID.
     * @param data Serialized JSON array of objects that describe created campaigns. Description of 'client_specification' objects see below.
     * @return query
     */
    @ApiMethod("ads.createClients")
    public AdsCreateClientsQuery createClients(UserActor actor, Integer accountId, String data) {
        return new AdsCreateClientsQuery(getClient(), actor, accountId, data);
    }

    /**
     * Creates clients of an advertising agency.
     *
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("ads.createClients")
    public AdsCreateClientsQuery createClients(UserActor actor) {
        return new AdsCreateClientsQuery(getClient(), actor);
    }

    /**
     * @param actor vk user actor
     * @param accountId
     * @param sourceType
     * @return query
     */
    @ApiMethod("ads.createLookalikeRequest")
    public AdsCreateLookalikeRequestQuery createLookalikeRequest(UserActor actor, Integer accountId,
            String sourceType) {
        return new AdsCreateLookalikeRequestQuery(getClient(), actor, accountId, sourceType);
    }

    /**
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("ads.createLookalikeRequest")
    public AdsCreateLookalikeRequestQuery createLookalikeRequest(UserActor actor) {
        return new AdsCreateLookalikeRequestQuery(getClient(), actor);
    }

    /**
     * Creates a group to re-target ads for users who visited advertiser's site (viewed information about the product, registered, etc.).
     *
     * @param actor vk user actor
     * @param accountId Advertising account ID.
     * @param name Name of the target group - a string up to 64 characters long.
     * @param lifetime 'For groups with auditory created with pixel code only.', , Number of days after that users will be automatically removed from the group.
     * @return query
     */
    @ApiMethod("ads.createTargetGroup")
    public AdsCreateTargetGroupQuery createTargetGroup(UserActor actor, Integer accountId,
            String name, Integer lifetime) {
        return new AdsCreateTargetGroupQuery(getClient(), actor, accountId, name, lifetime);
    }

    /**
     * Creates a group to re-target ads for users who visited advertiser's site (viewed information about the product, registered, etc.).
     *
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("ads.createTargetGroup")
    public AdsCreateTargetGroupQuery createTargetGroup(UserActor actor) {
        return new AdsCreateTargetGroupQuery(getClient(), actor);
    }

    /**
     * @param actor vk user actor
     * @param accountId
     * @param name
     * @param categoryId
     * @return query
     */
    @ApiMethod("ads.createTargetPixel")
    public AdsCreateTargetPixelQuery createTargetPixel(UserActor actor, Integer accountId,
            String name, Integer categoryId) {
        return new AdsCreateTargetPixelQuery(getClient(), actor, accountId, name, categoryId);
    }

    /**
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("ads.createTargetPixel")
    public AdsCreateTargetPixelQuery createTargetPixel(UserActor actor) {
        return new AdsCreateTargetPixelQuery(getClient(), actor);
    }

    /**
     * Archives ads.
     *
     * @param actor vk user actor
     * @param accountId Advertising account ID.
     * @param ids Serialized JSON array with ad IDs.
     * @return query
     */
    @ApiMethod("ads.deleteAds")
    public AdsDeleteAdsQuery deleteAds(UserActor actor, Integer accountId, String ids) {
        return new AdsDeleteAdsQuery(getClient(), actor, accountId, ids);
    }

    /**
     * Archives ads.
     *
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("ads.deleteAds")
    public AdsDeleteAdsQuery deleteAds(UserActor actor) {
        return new AdsDeleteAdsQuery(getClient(), actor);
    }

    /**
     * Archives advertising campaigns.
     *
     * @param actor vk user actor
     * @param accountId Advertising account ID.
     * @param ids Serialized JSON array with IDs of deleted campaigns.
     * @return query
     */
    @ApiMethod("ads.deleteCampaigns")
    public AdsDeleteCampaignsQuery deleteCampaigns(UserActor actor, Integer accountId, String ids) {
        return new AdsDeleteCampaignsQuery(getClient(), actor, accountId, ids);
    }

    /**
     * Archives advertising campaigns.
     *
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("ads.deleteCampaigns")
    public AdsDeleteCampaignsQuery deleteCampaigns(UserActor actor) {
        return new AdsDeleteCampaignsQuery(getClient(), actor);
    }

    /**
     * Archives clients of an advertising agency.
     *
     * @param actor vk user actor
     * @param accountId Advertising account ID.
     * @param ids Serialized JSON array with IDs of deleted clients.
     * @return query
     */
    @ApiMethod("ads.deleteClients")
    public AdsDeleteClientsQuery deleteClients(UserActor actor, Integer accountId, String ids) {
        return new AdsDeleteClientsQuery(getClient(), actor, accountId, ids);
    }

    /**
     * Archives clients of an advertising agency.
     *
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("ads.deleteClients")
    public AdsDeleteClientsQuery deleteClients(UserActor actor) {
        return new AdsDeleteClientsQuery(getClient(), actor);
    }

    /**
     * Deletes a retarget group.
     *
     * @param actor vk user actor
     * @param accountId Advertising account ID.
     * @param targetGroupId Group ID.
     * @return query
     */
    @ApiMethod("ads.deleteTargetGroup")
    public AdsDeleteTargetGroupQuery deleteTargetGroup(UserActor actor, Integer accountId,
            Integer targetGroupId) {
        return new AdsDeleteTargetGroupQuery(getClient(), actor, accountId, targetGroupId);
    }

    /**
     * Deletes a retarget group.
     *
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("ads.deleteTargetGroup")
    public AdsDeleteTargetGroupQuery deleteTargetGroup(UserActor actor) {
        return new AdsDeleteTargetGroupQuery(getClient(), actor);
    }

    /**
     * @param actor vk user actor
     * @param accountId
     * @param targetPixelId
     * @return query
     */
    @ApiMethod("ads.deleteTargetPixel")
    public AdsDeleteTargetPixelQuery deleteTargetPixel(UserActor actor, Integer accountId,
            Integer targetPixelId) {
        return new AdsDeleteTargetPixelQuery(getClient(), actor, accountId, targetPixelId);
    }

    /**
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("ads.deleteTargetPixel")
    public AdsDeleteTargetPixelQuery deleteTargetPixel(UserActor actor) {
        return new AdsDeleteTargetPixelQuery(getClient(), actor);
    }

    /**
     * Returns a list of advertising accounts.
     *
     * @param actor vk user actor
     * @return query
     */
    @ApiMethod("ads.getAccounts")
    public AdsGetAccountsQuery getAccounts(UserActor actor) {
        return new AdsGetAccountsQuery(getClient(), actor);
    }

    /**
     * Returns number of ads.
     *
     * @param actor vk user actor
     * @param accountId Advertising account ID.
     * @return query
     */
    @ApiMethod("ads.getAds")
    public AdsGetAdsQuery getAds(UserActor actor, Integer accountId) {
        return new AdsGetAdsQuery(getClient(), actor, accountId);
    }

    /**
     * Returns number of ads.
     *
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("ads.getAds")
    public AdsGetAdsQuery getAds(UserActor actor) {
        return new AdsGetAdsQuery(getClient(), actor);
    }

    /**
     * Returns descriptions of ad layouts.
     *
     * @param actor vk user actor
     * @param accountId Advertising account ID.
     * @return query
     */
    @ApiMethod("ads.getAdsLayout")
    public AdsGetAdsLayoutQuery getAdsLayout(UserActor actor, Integer accountId) {
        return new AdsGetAdsLayoutQuery(getClient(), actor, accountId);
    }

    /**
     * Returns descriptions of ad layouts.
     *
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("ads.getAdsLayout")
    public AdsGetAdsLayoutQuery getAdsLayout(UserActor actor) {
        return new AdsGetAdsLayoutQuery(getClient(), actor);
    }

    /**
     * Returns ad targeting parameters.
     *
     * @param actor vk user actor
     * @param accountId Advertising account ID.
     * @return query
     */
    @ApiMethod("ads.getAdsTargeting")
    public AdsGetAdsTargetingQuery getAdsTargeting(UserActor actor, Integer accountId) {
        return new AdsGetAdsTargetingQuery(getClient(), actor, accountId);
    }

    /**
     * Returns ad targeting parameters.
     *
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("ads.getAdsTargeting")
    public AdsGetAdsTargetingQuery getAdsTargeting(UserActor actor) {
        return new AdsGetAdsTargetingQuery(getClient(), actor);
    }

    /**
     * Returns current budget of the advertising account.
     *
     * @param actor vk user actor
     * @param accountId Advertising account ID.
     * @return query
     */
    @ApiMethod("ads.getBudget")
    public AdsGetBudgetQuery getBudget(UserActor actor, Integer accountId) {
        return new AdsGetBudgetQuery(getClient(), actor, accountId);
    }

    /**
     * Returns current budget of the advertising account.
     *
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("ads.getBudget")
    public AdsGetBudgetQuery getBudget(UserActor actor) {
        return new AdsGetBudgetQuery(getClient(), actor);
    }

    /**
     * Returns a list of campaigns in an advertising account.
     *
     * @param actor vk user actor
     * @param accountId Advertising account ID.
     * @return query
     */
    @ApiMethod("ads.getCampaigns")
    public AdsGetCampaignsQuery getCampaigns(UserActor actor, Integer accountId) {
        return new AdsGetCampaignsQuery(getClient(), actor, accountId);
    }

    /**
     * Returns a list of campaigns in an advertising account.
     *
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("ads.getCampaigns")
    public AdsGetCampaignsQuery getCampaigns(UserActor actor) {
        return new AdsGetCampaignsQuery(getClient(), actor);
    }

    /**
     * Returns a list of possible ad categories.
     *
     * @param actor vk user actor
     * @return query
     */
    @ApiMethod("ads.getCategories")
    public AdsGetCategoriesQuery getCategories(UserActor actor) {
        return new AdsGetCategoriesQuery(getClient(), actor);
    }

    /**
     * Returns a list of advertising agency's clients.
     *
     * @param actor vk user actor
     * @param accountId Advertising account ID.
     * @return query
     */
    @ApiMethod("ads.getClients")
    public AdsGetClientsQuery getClients(UserActor actor, Integer accountId) {
        return new AdsGetClientsQuery(getClient(), actor, accountId);
    }

    /**
     * Returns a list of advertising agency's clients.
     *
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("ads.getClients")
    public AdsGetClientsQuery getClients(UserActor actor) {
        return new AdsGetClientsQuery(getClient(), actor);
    }

    /**
     * Returns demographics for ads or campaigns.
     *
     * @param actor vk user actor
     * @param accountId Advertising account ID.
     * @param idsType Type of requested objects listed in 'ids' parameter: *ad - ads,, *campaign - campaigns.
     * @param ids IDs requested ads or campaigns, separated with a comma, depending on the value set in 'ids_type'. Maximum 2000 objects.
     * @param period Data grouping by dates: *day - statistics by days,, *month - statistics by months,, *overall - overall statistics. 'date_from' and 'date_to' parameters set temporary limits.
     * @param dateFrom Date to show statistics from. For different value of 'period' different date format is used: *day: YYYY-MM-DD, example: 2011-09-27 - September 27, 2011, **0 - day it was created on,, *month: YYYY-MM, example: 2011-09 - September 2011, **0 - month it was created in,, *overall: 0.
     * @param dateTo Date to show statistics to. For different value of 'period' different date format is used: *day: YYYY-MM-DD, example: 2011-09-27 - September 27, 2011, **0 - current day,, *month: YYYY-MM, example: 2011-09 - September 2011, **0 - current month,, *overall: 0.
     * @return query
     */
    @ApiMethod("ads.getDemographics")
    public AdsGetDemographicsQuery getDemographics(UserActor actor, Integer accountId,
            GetDemographicsIdsType idsType, String ids, GetDemographicsPeriod period,
            String dateFrom, String dateTo) {
        return new AdsGetDemographicsQuery(getClient(), actor, accountId, idsType, ids, period, dateFrom, dateTo);
    }

    /**
     * Returns demographics for ads or campaigns.
     *
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("ads.getDemographics")
    public AdsGetDemographicsQuery getDemographics(UserActor actor) {
        return new AdsGetDemographicsQuery(getClient(), actor);
    }

    /**
     * Returns information about current state of a counter - number of remaining runs of methods and time to the next counter nulling in seconds.
     *
     * @param actor vk user actor
     * @param accountId Advertising account ID.
     * @return query
     */
    @ApiMethod("ads.getFloodStats")
    public AdsGetFloodStatsQuery getFloodStats(UserActor actor, Integer accountId) {
        return new AdsGetFloodStatsQuery(getClient(), actor, accountId);
    }

    /**
     * Returns information about current state of a counter - number of remaining runs of methods and time to the next counter nulling in seconds.
     *
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("ads.getFloodStats")
    public AdsGetFloodStatsQuery getFloodStats(UserActor actor) {
        return new AdsGetFloodStatsQuery(getClient(), actor);
    }

    /**
     * @param actor vk user actor
     * @param accountId
     * @return query
     */
    @ApiMethod("ads.getLookalikeRequests")
    public AdsGetLookalikeRequestsQuery getLookalikeRequests(UserActor actor, Integer accountId) {
        return new AdsGetLookalikeRequestsQuery(getClient(), actor, accountId);
    }

    /**
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("ads.getLookalikeRequests")
    public AdsGetLookalikeRequestsQuery getLookalikeRequests(UserActor actor) {
        return new AdsGetLookalikeRequestsQuery(getClient(), actor);
    }

    /**
     * @param actor vk user actor
     * @param artistName
     * @return query
     */
    @ApiMethod("ads.getMusicians")
    public AdsGetMusiciansQuery getMusicians(UserActor actor, String artistName) {
        return new AdsGetMusiciansQuery(getClient(), actor, artistName);
    }

    /**
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("ads.getMusicians")
    public AdsGetMusiciansQuery getMusicians(UserActor actor) {
        return new AdsGetMusiciansQuery(getClient(), actor);
    }

    /**
     * @param actor vk user actor
     * @param ids
     * @return query
     */
    @ApiMethod("ads.getMusiciansByIds")
    public AdsGetMusiciansByIdsQuery getMusiciansByIds(UserActor actor, Long... ids) {
        return new AdsGetMusiciansByIdsQuery(getClient(), actor, ids);
    }

    /**
     * @param actor vk user actor
     * @param ids
     * @return query
     */
    @ApiMethod("ads.getMusiciansByIds")
    public AdsGetMusiciansByIdsQuery getMusiciansByIds(UserActor actor, List<Long> ids) {
        return new AdsGetMusiciansByIdsQuery(getClient(), actor, ids);
    }

    /**
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("ads.getMusiciansByIds")
    public AdsGetMusiciansByIdsQuery getMusiciansByIds(UserActor actor) {
        return new AdsGetMusiciansByIdsQuery(getClient(), actor);
    }

    /**
     * Returns a list of managers and supervisors of advertising account.
     *
     * @param actor vk user actor
     * @param accountId Advertising account ID.
     * @return query
     */
    @ApiMethod("ads.getOfficeUsers")
    public AdsGetOfficeUsersQuery getOfficeUsers(UserActor actor, Integer accountId) {
        return new AdsGetOfficeUsersQuery(getClient(), actor, accountId);
    }

    /**
     * Returns a list of managers and supervisors of advertising account.
     *
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("ads.getOfficeUsers")
    public AdsGetOfficeUsersQuery getOfficeUsers(UserActor actor) {
        return new AdsGetOfficeUsersQuery(getClient(), actor);
    }

    /**
     * Returns detailed statistics of promoted posts reach from campaigns and ads.
     *
     * @param actor vk user actor
     * @param accountId Advertising account ID.
     * @param idsType Type of requested objects listed in 'ids' parameter: *ad - ads,, *campaign - campaigns.
     * @param ids IDs requested ads or campaigns, separated with a comma, depending on the value set in 'ids_type'. Maximum 100 objects.
     * @return query
     */
    @ApiMethod("ads.getPostsReach")
    public AdsGetPostsReachQuery getPostsReach(UserActor actor, Integer accountId,
            GetPostsReachIdsType idsType, String ids) {
        return new AdsGetPostsReachQuery(getClient(), actor, accountId, idsType, ids);
    }

    /**
     * Returns detailed statistics of promoted posts reach from campaigns and ads.
     *
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("ads.getPostsReach")
    public AdsGetPostsReachQuery getPostsReach(UserActor actor) {
        return new AdsGetPostsReachQuery(getClient(), actor);
    }

    /**
     * Returns a reason of ad rejection for pre-moderation.
     *
     * @param actor vk user actor
     * @param accountId Advertising account ID.
     * @param adId Ad ID.
     * @return query
     */
    @ApiMethod("ads.getRejectionReason")
    public AdsGetRejectionReasonQuery getRejectionReason(UserActor actor, Integer accountId,
            Integer adId) {
        return new AdsGetRejectionReasonQuery(getClient(), actor, accountId, adId);
    }

    /**
     * Returns a reason of ad rejection for pre-moderation.
     *
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("ads.getRejectionReason")
    public AdsGetRejectionReasonQuery getRejectionReason(UserActor actor) {
        return new AdsGetRejectionReasonQuery(getClient(), actor);
    }

    /**
     * Returns statistics of performance indicators for ads, campaigns, clients or the whole account.
     *
     * @param actor vk user actor
     * @param accountId Advertising account ID.
     * @param idsType Type of requested objects listed in 'ids' parameter: *ad - ads,, *campaign - campaigns,, *client - clients,, *office - account.
     * @param ids IDs requested ads, campaigns, clients or account, separated with a comma, depending on the value set in 'ids_type'. Maximum 2000 objects.
     * @param period Data grouping by dates: *day - statistics by days,, *month - statistics by months,, *overall - overall statistics. 'date_from' and 'date_to' parameters set temporary limits.
     * @param dateFrom Date to show statistics from. For different value of 'period' different date format is used: *day: YYYY-MM-DD, example: 2011-09-27 - September 27, 2011, **0 - day it was created on,, *month: YYYY-MM, example: 2011-09 - September 2011, **0 - month it was created in,, *overall: 0.
     * @param dateTo Date to show statistics to. For different value of 'period' different date format is used: *day: YYYY-MM-DD, example: 2011-09-27 - September 27, 2011, **0 - current day,, *month: YYYY-MM, example: 2011-09 - September 2011, **0 - current month,, *overall: 0.
     * @return query
     */
    @ApiMethod("ads.getStatistics")
    public AdsGetStatisticsQuery getStatistics(UserActor actor, Integer accountId,
            GetStatisticsIdsType idsType, String ids, GetStatisticsPeriod period, String dateFrom,
            String dateTo) {
        return new AdsGetStatisticsQuery(getClient(), actor, accountId, idsType, ids, period, dateFrom, dateTo);
    }

    /**
     * Returns statistics of performance indicators for ads, campaigns, clients or the whole account.
     *
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("ads.getStatistics")
    public AdsGetStatisticsQuery getStatistics(UserActor actor) {
        return new AdsGetStatisticsQuery(getClient(), actor);
    }

    /**
     * Returns a set of auto-suggestions for various targeting parameters.
     *
     * @param actor vk user actor
     * @param section Section, suggestions are retrieved in. Available values: *countries - request of a list of countries. If q is not set or blank, a short list of countries is shown. Otherwise, a full list of countries is shown. *regions - requested list of regions. 'country' parameter is required. *cities - requested list of cities. 'country' parameter is required. *districts - requested list of districts. 'cities' parameter is required. *stations - requested list of subway stations. 'cities' parameter is required. *streets - requested list of streets. 'cities' parameter is required. *schools - requested list of educational organizations. 'cities' parameter is required. *interests - requested list of interests. *positions - requested list of positions (professions). *group_types - requested list of group types. *religions - requested list of religious commitments. *browsers - requested list of browsers and mobile devices.
     * @return query
     */
    @ApiMethod("ads.getSuggestions")
    public AdsGetSuggestionsQuery getSuggestions(UserActor actor, GetSuggestionsSection section) {
        return new AdsGetSuggestionsQuery(getClient(), actor, section);
    }

    /**
     * Returns a set of auto-suggestions for various targeting parameters.
     *
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("ads.getSuggestions")
    public AdsGetSuggestionsQuery getSuggestions(UserActor actor) {
        return new AdsGetSuggestionsQuery(getClient(), actor);
    }

    /**
     * Returns a set of auto-suggestions for various targeting parameters.
     *
     * @param actor vk user actor
     * @param section Section, suggestions are retrieved in. Available values: *countries - request of a list of countries. If q is not set or blank, a short list of countries is shown. Otherwise, a full list of countries is shown. *regions - requested list of regions. 'country' parameter is required. *cities - requested list of cities. 'country' parameter is required. *districts - requested list of districts. 'cities' parameter is required. *stations - requested list of subway stations. 'cities' parameter is required. *streets - requested list of streets. 'cities' parameter is required. *schools - requested list of educational organizations. 'cities' parameter is required. *interests - requested list of interests. *positions - requested list of positions (professions). *group_types - requested list of group types. *religions - requested list of religious commitments. *browsers - requested list of browsers and mobile devices.
     * @return query
     */
    @ApiMethod("ads.getSuggestions")
    public AdsGetSuggestionsQueryWithRegions getSuggestionsRegions(UserActor actor,
            GetSuggestionsSection section) {
        return new AdsGetSuggestionsQueryWithRegions(getClient(), actor, section);
    }

    /**
     * Returns a set of auto-suggestions for various targeting parameters.
     *
     * @param actor vk user actor
     * @param section Section, suggestions are retrieved in. Available values: *countries - request of a list of countries. If q is not set or blank, a short list of countries is shown. Otherwise, a full list of countries is shown. *regions - requested list of regions. 'country' parameter is required. *cities - requested list of cities. 'country' parameter is required. *districts - requested list of districts. 'cities' parameter is required. *stations - requested list of subway stations. 'cities' parameter is required. *streets - requested list of streets. 'cities' parameter is required. *schools - requested list of educational organizations. 'cities' parameter is required. *interests - requested list of interests. *positions - requested list of positions (professions). *group_types - requested list of group types. *religions - requested list of religious commitments. *browsers - requested list of browsers and mobile devices.
     * @return query
     */
    @ApiMethod("ads.getSuggestions")
    public AdsGetSuggestionsQueryWithSchools getSuggestionsSchools(UserActor actor,
            GetSuggestionsSection section) {
        return new AdsGetSuggestionsQueryWithSchools(getClient(), actor, section);
    }

    /**
     * Returns a set of auto-suggestions for various targeting parameters.
     *
     * @param actor vk user actor
     * @param section Section, suggestions are retrieved in. Available values: *countries - request of a list of countries. If q is not set or blank, a short list of countries is shown. Otherwise, a full list of countries is shown. *regions - requested list of regions. 'country' parameter is required. *cities - requested list of cities. 'country' parameter is required. *districts - requested list of districts. 'cities' parameter is required. *stations - requested list of subway stations. 'cities' parameter is required. *streets - requested list of streets. 'cities' parameter is required. *schools - requested list of educational organizations. 'cities' parameter is required. *interests - requested list of interests. *positions - requested list of positions (professions). *group_types - requested list of group types. *religions - requested list of religious commitments. *browsers - requested list of browsers and mobile devices.
     * @param cities IDs of cities where objects are searched in, separated with a comma.
     * @return query
     */
    @ApiMethod("ads.getSuggestions")
    public AdsGetSuggestionsQueryWithCities getSuggestionsWithCities(UserActor actor,
            GetSuggestionsSection section, String cities) {
        return new AdsGetSuggestionsQueryWithCities(getClient(), actor, section, cities);
    }

    /**
     * Returns a list of target groups.
     *
     * @param actor vk user actor
     * @param accountId Advertising account ID.
     * @return query
     */
    @ApiMethod("ads.getTargetGroups")
    public AdsGetTargetGroupsQuery getTargetGroups(UserActor actor, Integer accountId) {
        return new AdsGetTargetGroupsQuery(getClient(), actor, accountId);
    }

    /**
     * Returns a list of target groups.
     *
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("ads.getTargetGroups")
    public AdsGetTargetGroupsQuery getTargetGroups(UserActor actor) {
        return new AdsGetTargetGroupsQuery(getClient(), actor);
    }

    /**
     * @param actor vk user actor
     * @param accountId
     * @return query
     */
    @ApiMethod("ads.getTargetPixels")
    public AdsGetTargetPixelsQuery getTargetPixels(UserActor actor, Integer accountId) {
        return new AdsGetTargetPixelsQuery(getClient(), actor, accountId);
    }

    /**
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("ads.getTargetPixels")
    public AdsGetTargetPixelsQuery getTargetPixels(UserActor actor) {
        return new AdsGetTargetPixelsQuery(getClient(), actor);
    }

    /**
     * Returns the size of targeting audience, and also recommended values for CPC and CPM.
     *
     * @param actor vk user actor
     * @param accountId Advertising account ID.
     * @param linkUrl URL for the advertised object.
     * @return query
     */
    @ApiMethod("ads.getTargetingStats")
    public AdsGetTargetingStatsQuery getTargetingStats(UserActor actor, Integer accountId,
            String linkUrl) {
        return new AdsGetTargetingStatsQuery(getClient(), actor, accountId, linkUrl);
    }

    /**
     * Returns the size of targeting audience, and also recommended values for CPC and CPM.
     *
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("ads.getTargetingStats")
    public AdsGetTargetingStatsQuery getTargetingStats(UserActor actor) {
        return new AdsGetTargetingStatsQuery(getClient(), actor);
    }

    /**
     * Returns URL to upload an ad photo to.
     *
     * @param actor vk user actor
     * @param adFormat Ad format: *1 - image and text,, *2 - big image,, *3 - exclusive format,, *4 - community, square image,, *7 - special app format.
     * @return query
     */
    @ApiMethod("ads.getUploadURL")
    public AdsGetUploadURLQuery getUploadURL(UserActor actor, GetUploadURLAdFormat adFormat) {
        return new AdsGetUploadURLQuery(getClient(), actor, adFormat);
    }

    /**
     * Returns URL to upload an ad photo to.
     *
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("ads.getUploadURL")
    public AdsGetUploadURLQuery getUploadURL(UserActor actor) {
        return new AdsGetUploadURLQuery(getClient(), actor);
    }

    /**
     * Returns URL to upload an ad video to.
     *
     * @param actor vk user actor
     * @return query
     */
    @ApiMethod("ads.getVideoUploadURL")
    public AdsGetVideoUploadURLQuery getVideoUploadURL(UserActor actor) {
        return new AdsGetVideoUploadURLQuery(getClient(), actor);
    }

    /**
     * Imports a list of advertiser's contacts to count VK registered users against the target group.
     *
     * @param actor vk user actor
     * @param accountId Advertising account ID.
     * @param targetGroupId Target group ID.
     * @param contacts List of phone numbers, emails or user IDs separated with a comma.
     * @return query
     */
    @ApiMethod("ads.importTargetContacts")
    public AdsImportTargetContactsQuery importTargetContacts(UserActor actor, Integer accountId,
            Integer targetGroupId, String contacts) {
        return new AdsImportTargetContactsQuery(getClient(), actor, accountId, targetGroupId, contacts);
    }

    /**
     * Imports a list of advertiser's contacts to count VK registered users against the target group.
     *
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("ads.importTargetContacts")
    public AdsImportTargetContactsQuery importTargetContacts(UserActor actor) {
        return new AdsImportTargetContactsQuery(getClient(), actor);
    }

    /**
     * Removes managers and/or supervisors from advertising account.
     *
     * @param actor vk user actor
     * @param accountId Advertising account ID.
     * @param ids Serialized JSON array with IDs of deleted managers.
     * @return query
     */
    @ApiMethod("ads.removeOfficeUsers")
    public AdsRemoveOfficeUsersQuery removeOfficeUsers(UserActor actor, Integer accountId,
            String ids) {
        return new AdsRemoveOfficeUsersQuery(getClient(), actor, accountId, ids);
    }

    /**
     * Removes managers and/or supervisors from advertising account.
     *
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("ads.removeOfficeUsers")
    public AdsRemoveOfficeUsersQuery removeOfficeUsers(UserActor actor) {
        return new AdsRemoveOfficeUsersQuery(getClient(), actor);
    }

    /**
     * @param actor vk user actor
     * @param accountId
     * @param targetGroupId
     * @param contacts
     * @return query
     */
    @ApiMethod("ads.removeTargetContacts")
    public AdsRemoveTargetContactsQuery removeTargetContacts(UserActor actor, Integer accountId,
            Integer targetGroupId, String contacts) {
        return new AdsRemoveTargetContactsQuery(getClient(), actor, accountId, targetGroupId, contacts);
    }

    /**
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("ads.removeTargetContacts")
    public AdsRemoveTargetContactsQuery removeTargetContacts(UserActor actor) {
        return new AdsRemoveTargetContactsQuery(getClient(), actor);
    }

    /**
     * @param actor vk user actor
     * @param accountId
     * @param requestId
     * @param level
     * @return query
     */
    @ApiMethod("ads.saveLookalikeRequestResult")
    public AdsSaveLookalikeRequestResultQuery saveLookalikeRequestResult(UserActor actor,
            Integer accountId, Integer requestId, Integer level) {
        return new AdsSaveLookalikeRequestResultQuery(getClient(), actor, accountId, requestId, level);
    }

    /**
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("ads.saveLookalikeRequestResult")
    public AdsSaveLookalikeRequestResultQuery saveLookalikeRequestResult(UserActor actor) {
        return new AdsSaveLookalikeRequestResultQuery(getClient(), actor);
    }

    /**
     * @param actor vk user actor
     * @param accountId
     * @param targetGroupId
     * @return query
     */
    @ApiMethod("ads.shareTargetGroup")
    public AdsShareTargetGroupQuery shareTargetGroup(UserActor actor, Integer accountId,
            Integer targetGroupId) {
        return new AdsShareTargetGroupQuery(getClient(), actor, accountId, targetGroupId);
    }

    /**
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("ads.shareTargetGroup")
    public AdsShareTargetGroupQuery shareTargetGroup(UserActor actor) {
        return new AdsShareTargetGroupQuery(getClient(), actor);
    }

    /**
     * Edits ads.
     *
     * @param actor vk user actor
     * @param accountId Advertising account ID.
     * @param data Serialized JSON array of objects that describe changes in ads. Description of 'ad_edit_specification' objects see below.
     * @return query
     */
    @ApiMethod("ads.updateAds")
    public AdsUpdateAdsQuery updateAds(UserActor actor, Integer accountId, String data) {
        return new AdsUpdateAdsQuery(getClient(), actor, accountId, data);
    }

    /**
     * Edits ads.
     *
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("ads.updateAds")
    public AdsUpdateAdsQuery updateAds(UserActor actor) {
        return new AdsUpdateAdsQuery(getClient(), actor);
    }

    /**
     * Edits advertising campaigns.
     *
     * @param actor vk user actor
     * @param accountId Advertising account ID.
     * @param data Serialized JSON array of objects that describe changes in campaigns. Description of 'campaign_mod' objects see below.
     * @return query
     */
    @ApiMethod("ads.updateCampaigns")
    public AdsUpdateCampaignsQuery updateCampaigns(UserActor actor, Integer accountId,
            String data) {
        return new AdsUpdateCampaignsQuery(getClient(), actor, accountId, data);
    }

    /**
     * Edits advertising campaigns.
     *
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("ads.updateCampaigns")
    public AdsUpdateCampaignsQuery updateCampaigns(UserActor actor) {
        return new AdsUpdateCampaignsQuery(getClient(), actor);
    }

    /**
     * Edits clients of an advertising agency.
     *
     * @param actor vk user actor
     * @param accountId Advertising account ID.
     * @param data Serialized JSON array of objects that describe changes in clients. Description of 'client_mod' objects see below.
     * @return query
     */
    @ApiMethod("ads.updateClients")
    public AdsUpdateClientsQuery updateClients(UserActor actor, Integer accountId, String data) {
        return new AdsUpdateClientsQuery(getClient(), actor, accountId, data);
    }

    /**
     * Edits clients of an advertising agency.
     *
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("ads.updateClients")
    public AdsUpdateClientsQuery updateClients(UserActor actor) {
        return new AdsUpdateClientsQuery(getClient(), actor);
    }

    /**
     * Adds managers and/or supervisors to advertising account.
     *
     * @param actor vk user actor
     * @param accountId Advertising account ID.
     * @param data Serialized JSON array of objects that describe added managers. Description of 'user_specification' objects see below.
     * @return query
     */
    @ApiMethod("ads.updateOfficeUsers")
    public AdsUpdateOfficeUsersQuery updateOfficeUsers(UserActor actor, Integer accountId,
            UserSpecification... data) {
        return new AdsUpdateOfficeUsersQuery(getClient(), actor, accountId, data);
    }

    /**
     * Adds managers and/or supervisors to advertising account.
     *
     * @param actor vk user actor
     * @param accountId Advertising account ID.
     * @param data Serialized JSON array of objects that describe added managers. Description of 'user_specification' objects see below.
     * @return query
     */
    @ApiMethod("ads.updateOfficeUsers")
    public AdsUpdateOfficeUsersQuery updateOfficeUsers(UserActor actor, Integer accountId,
            List<UserSpecification> data) {
        return new AdsUpdateOfficeUsersQuery(getClient(), actor, accountId, data);
    }

    /**
     * Adds managers and/or supervisors to advertising account.
     *
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("ads.updateOfficeUsers")
    public AdsUpdateOfficeUsersQuery updateOfficeUsers(UserActor actor) {
        return new AdsUpdateOfficeUsersQuery(getClient(), actor);
    }

    /**
     * Edits a retarget group.
     *
     * @param actor vk user actor
     * @param accountId Advertising account ID.
     * @param targetGroupId Group ID.
     * @param name New name of the target group - a string up to 64 characters long.
     * @param lifetime 'Only for the groups that get audience from sites with user accounting code.', Time in days when users added to a retarget group will be automatically excluded from it. '0' - automatic exclusion is off.
     * @return query
     */
    @ApiMethod("ads.updateTargetGroup")
    public AdsUpdateTargetGroupQuery updateTargetGroup(UserActor actor, Integer accountId,
            Integer targetGroupId, String name, Integer lifetime) {
        return new AdsUpdateTargetGroupQuery(getClient(), actor, accountId, targetGroupId, name, lifetime);
    }

    /**
     * Edits a retarget group.
     *
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("ads.updateTargetGroup")
    public AdsUpdateTargetGroupQuery updateTargetGroup(UserActor actor) {
        return new AdsUpdateTargetGroupQuery(getClient(), actor);
    }

    /**
     * @param actor vk user actor
     * @param accountId
     * @param targetPixelId
     * @param name
     * @param categoryId
     * @return query
     */
    @ApiMethod("ads.updateTargetPixel")
    public AdsUpdateTargetPixelQuery updateTargetPixel(UserActor actor, Integer accountId,
            Integer targetPixelId, String name, Integer categoryId) {
        return new AdsUpdateTargetPixelQuery(getClient(), actor, accountId, targetPixelId, name, categoryId);
    }

    /**
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("ads.updateTargetPixel")
    public AdsUpdateTargetPixelQuery updateTargetPixel(UserActor actor) {
        return new AdsUpdateTargetPixelQuery(getClient(), actor);
    }
}
