// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.actions;

import com.vk.api.sdk.client.AbstractAction;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.GroupActor;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.objects.annotations.ApiMethod;
import com.vk.api.sdk.queries.docs.DocsAddQuery;
import com.vk.api.sdk.queries.docs.DocsDeleteQuery;
import com.vk.api.sdk.queries.docs.DocsEditQuery;
import com.vk.api.sdk.queries.docs.DocsGetByIdQuery;
import com.vk.api.sdk.queries.docs.DocsGetMessagesUploadServerQuery;
import com.vk.api.sdk.queries.docs.DocsGetQuery;
import com.vk.api.sdk.queries.docs.DocsGetTypesQuery;
import com.vk.api.sdk.queries.docs.DocsGetUploadServerQuery;
import com.vk.api.sdk.queries.docs.DocsGetWallUploadServerQuery;
import com.vk.api.sdk.queries.docs.DocsRestoreQuery;
import com.vk.api.sdk.queries.docs.DocsSaveQuery;
import com.vk.api.sdk.queries.docs.DocsSearchQuery;
import java.util.List;

/**
 * List of Docs methods
 */
public class Docs extends AbstractAction {
    /**
     * Constructor
     *
     * @param client vk api client
     */
    public Docs(VkApiClient client) {
        super(client);
    }

    /**
     * Copies a document to a user's or community's document list.
     *
     * @param actor vk user actor
     * @param ownerId ID of the user or community that owns the document. Use a negative value to designate a community ID.
     * @param docId Document ID.
     * @return query
     */
    @ApiMethod("docs.add")
    public DocsAddQuery add(UserActor actor, Long ownerId, Integer docId) {
        return new DocsAddQuery(getClient(), actor, ownerId, docId);
    }

    /**
     * Copies a document to a user's or community's document list.
     *
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("docs.add")
    public DocsAddQuery add(UserActor actor) {
        return new DocsAddQuery(getClient(), actor);
    }

    /**
     * Deletes a user or community document.
     *
     * @param actor vk user actor
     * @param ownerId ID of the user or community that owns the document. Use a negative value to designate a community ID.
     * @param docId Document ID.
     * @return query
     */
    @ApiMethod("docs.delete")
    public DocsDeleteQuery delete(UserActor actor, Long ownerId, Integer docId) {
        return new DocsDeleteQuery(getClient(), actor, ownerId, docId);
    }

    /**
     * Deletes a user or community document.
     *
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("docs.delete")
    public DocsDeleteQuery delete(UserActor actor) {
        return new DocsDeleteQuery(getClient(), actor);
    }

    /**
     * Edits a document.
     *
     * @param actor vk user actor
     * @param docId Document ID.
     * @param title Document title.
     * @return query
     */
    @ApiMethod("docs.edit")
    public DocsEditQuery edit(UserActor actor, Integer docId, String title) {
        return new DocsEditQuery(getClient(), actor, docId, title);
    }

    /**
     * Edits a document.
     *
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("docs.edit")
    public DocsEditQuery edit(UserActor actor) {
        return new DocsEditQuery(getClient(), actor);
    }

    /**
     * Returns detailed information about user or community documents.
     *
     * @param actor vk user actor
     * @return query
     */
    @ApiMethod("docs.get")
    public DocsGetQuery get(UserActor actor) {
        return new DocsGetQuery(getClient(), actor);
    }

    /**
     * Returns information about documents by their IDs.
     *
     * @param actor vk user actor
     * @param docs Document IDs. Example: , "66748_91488,66748_91455",
     * @return query
     */
    @ApiMethod("docs.getById")
    public DocsGetByIdQuery getById(UserActor actor, String... docs) {
        return new DocsGetByIdQuery(getClient(), actor, docs);
    }

    /**
     * Returns information about documents by their IDs.
     *
     * @param actor vk user actor
     * @param docs Document IDs. Example: , "66748_91488,66748_91455",
     * @return query
     */
    @ApiMethod("docs.getById")
    public DocsGetByIdQuery getById(UserActor actor, List<String> docs) {
        return new DocsGetByIdQuery(getClient(), actor, docs);
    }

    /**
     * Returns information about documents by their IDs.
     *
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("docs.getById")
    public DocsGetByIdQuery getById(UserActor actor) {
        return new DocsGetByIdQuery(getClient(), actor);
    }

    /**
     * Returns information about documents by their IDs.
     *
     * @param actor vk group actor
     * @param docs Document IDs. Example: , "66748_91488,66748_91455",
     * @return query
     */
    @ApiMethod("docs.getById")
    public DocsGetByIdQuery getById(GroupActor actor, String... docs) {
        return new DocsGetByIdQuery(getClient(), actor, docs);
    }

    /**
     * Returns information about documents by their IDs.
     *
     * @param actor vk group actor
     * @param docs Document IDs. Example: , "66748_91488,66748_91455",
     * @return query
     */
    @ApiMethod("docs.getById")
    public DocsGetByIdQuery getById(GroupActor actor, List<String> docs) {
        return new DocsGetByIdQuery(getClient(), actor, docs);
    }

    /**
     * Returns information about documents by their IDs.
     *
     * @param actor vk group actor
     * @return only actor query 
     */
    @ApiMethod("docs.getById")
    public DocsGetByIdQuery getById(GroupActor actor) {
        return new DocsGetByIdQuery(getClient(), actor);
    }

    /**
     * Returns the server address for document upload.
     *
     * @param actor vk user actor
     * @return query
     */
    @ApiMethod("docs.getMessagesUploadServer")
    public DocsGetMessagesUploadServerQuery getMessagesUploadServer(UserActor actor) {
        return new DocsGetMessagesUploadServerQuery(getClient(), actor);
    }

    /**
     * Returns the server address for document upload.
     *
     * @param actor vk group actor
     * @return query
     */
    @ApiMethod("docs.getMessagesUploadServer")
    public DocsGetMessagesUploadServerQuery getMessagesUploadServer(GroupActor actor) {
        return new DocsGetMessagesUploadServerQuery(getClient(), actor);
    }

    /**
     * Returns documents types available for current user.
     *
     * @param actor vk user actor
     * @return query
     */
    @ApiMethod("docs.getTypes")
    public DocsGetTypesQuery getTypes(UserActor actor) {
        return new DocsGetTypesQuery(getClient(), actor);
    }

    /**
     * Returns the server address for document upload.
     *
     * @param actor vk user actor
     * @return query
     */
    @ApiMethod("docs.getUploadServer")
    public DocsGetUploadServerQuery getUploadServer(UserActor actor) {
        return new DocsGetUploadServerQuery(getClient(), actor);
    }

    /**
     * Returns the server address for document upload onto a user's or community's wall.
     *
     * @param actor vk user actor
     * @return query
     */
    @ApiMethod("docs.getWallUploadServer")
    public DocsGetWallUploadServerQuery getWallUploadServer(UserActor actor) {
        return new DocsGetWallUploadServerQuery(getClient(), actor);
    }

    /**
     * Returns the server address for document upload onto a user's or community's wall.
     *
     * @param actor vk group actor
     * @return query
     */
    @ApiMethod("docs.getWallUploadServer")
    public DocsGetWallUploadServerQuery getWallUploadServer(GroupActor actor) {
        return new DocsGetWallUploadServerQuery(getClient(), actor);
    }

    /**
     * @param actor vk user actor
     * @param ownerId
     * @param docId
     * @return query
     */
    @ApiMethod("docs.restore")
    public DocsRestoreQuery restore(UserActor actor, Long ownerId, Integer docId) {
        return new DocsRestoreQuery(getClient(), actor, ownerId, docId);
    }

    /**
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("docs.restore")
    public DocsRestoreQuery restore(UserActor actor) {
        return new DocsRestoreQuery(getClient(), actor);
    }

    /**
     * Saves a document after [vk.com/dev/upload_files_2|uploading it to a server].
     *
     * @param actor vk user actor
     * @param file This parameter is returned when the file is [vk.com/dev/upload_files_2|uploaded to the server].
     * @return query
     */
    @ApiMethod("docs.save")
    public DocsSaveQuery save(UserActor actor, String file) {
        return new DocsSaveQuery(getClient(), actor, file);
    }

    /**
     * Saves a document after [vk.com/dev/upload_files_2|uploading it to a server].
     *
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("docs.save")
    public DocsSaveQuery save(UserActor actor) {
        return new DocsSaveQuery(getClient(), actor);
    }

    /**
     * Saves a document after [vk.com/dev/upload_files_2|uploading it to a server].
     *
     * @param actor vk group actor
     * @param file This parameter is returned when the file is [vk.com/dev/upload_files_2|uploaded to the server].
     * @return query
     */
    @ApiMethod("docs.save")
    public DocsSaveQuery save(GroupActor actor, String file) {
        return new DocsSaveQuery(getClient(), actor, file);
    }

    /**
     * Saves a document after [vk.com/dev/upload_files_2|uploading it to a server].
     *
     * @param actor vk group actor
     * @return only actor query 
     */
    @ApiMethod("docs.save")
    public DocsSaveQuery save(GroupActor actor) {
        return new DocsSaveQuery(getClient(), actor);
    }

    /**
     * Returns a list of documents matching the search criteria.
     *
     * @param actor vk user actor
     * @return query
     */
    @ApiMethod("docs.search")
    public DocsSearchQuery search(UserActor actor) {
        return new DocsSearchQuery(getClient(), actor);
    }

    /**
     * Returns a list of documents matching the search criteria.
     *
     * @param actor vk group actor
     * @return query
     */
    @ApiMethod("docs.search")
    public DocsSearchQuery search(GroupActor actor) {
        return new DocsSearchQuery(getClient(), actor);
    }
}
