// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.actions;

import com.vk.api.sdk.client.AbstractAction;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.objects.annotations.ApiMethod;
import com.vk.api.sdk.objects.users.Fields;
import com.vk.api.sdk.queries.polls.PollsAddVoteQuery;
import com.vk.api.sdk.queries.polls.PollsCreateQuery;
import com.vk.api.sdk.queries.polls.PollsDeleteVoteQuery;
import com.vk.api.sdk.queries.polls.PollsEditQuery;
import com.vk.api.sdk.queries.polls.PollsGetBackgroundsQuery;
import com.vk.api.sdk.queries.polls.PollsGetByIdQuery;
import com.vk.api.sdk.queries.polls.PollsGetPhotoUploadServerQuery;
import com.vk.api.sdk.queries.polls.PollsGetVotersQuery;
import com.vk.api.sdk.queries.polls.PollsGetVotersQueryWithFields;
import com.vk.api.sdk.queries.polls.PollsSavePhotoQuery;
import java.util.List;

/**
 * List of Polls methods
 */
public class Polls extends AbstractAction {
    /**
     * Constructor
     *
     * @param client vk api client
     */
    public Polls(VkApiClient client) {
        super(client);
    }

    /**
     * Adds the current user's vote to the selected answer in the poll.
     *
     * @param actor vk user actor
     * @param pollId Poll ID.
     * @param answerIds
     * @return query
     */
    @ApiMethod("polls.addVote")
    public PollsAddVoteQuery addVote(UserActor actor, Integer pollId, Long... answerIds) {
        return new PollsAddVoteQuery(getClient(), actor, pollId, answerIds);
    }

    /**
     * Adds the current user's vote to the selected answer in the poll.
     *
     * @param actor vk user actor
     * @param pollId Poll ID.
     * @param answerIds
     * @return query
     */
    @ApiMethod("polls.addVote")
    public PollsAddVoteQuery addVote(UserActor actor, Integer pollId, List<Long> answerIds) {
        return new PollsAddVoteQuery(getClient(), actor, pollId, answerIds);
    }

    /**
     * Adds the current user's vote to the selected answer in the poll.
     *
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("polls.addVote")
    public PollsAddVoteQuery addVote(UserActor actor) {
        return new PollsAddVoteQuery(getClient(), actor);
    }

    /**
     * Creates polls that can be attached to the users' or communities' posts.
     *
     * @param actor vk user actor
     * @return query
     */
    @ApiMethod("polls.create")
    public PollsCreateQuery create(UserActor actor) {
        return new PollsCreateQuery(getClient(), actor);
    }

    /**
     * Deletes the current user's vote from the selected answer in the poll.
     *
     * @param actor vk user actor
     * @param pollId Poll ID.
     * @return query
     */
    @ApiMethod("polls.deleteVote")
    public PollsDeleteVoteQuery deleteVote(UserActor actor, Integer pollId) {
        return new PollsDeleteVoteQuery(getClient(), actor, pollId);
    }

    /**
     * Deletes the current user's vote from the selected answer in the poll.
     *
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("polls.deleteVote")
    public PollsDeleteVoteQuery deleteVote(UserActor actor) {
        return new PollsDeleteVoteQuery(getClient(), actor);
    }

    /**
     * Edits created polls
     *
     * @param actor vk user actor
     * @param pollId edited poll's id
     * @return query
     */
    @ApiMethod("polls.edit")
    public PollsEditQuery edit(UserActor actor, Integer pollId) {
        return new PollsEditQuery(getClient(), actor, pollId);
    }

    /**
     * Edits created polls
     *
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("polls.edit")
    public PollsEditQuery edit(UserActor actor) {
        return new PollsEditQuery(getClient(), actor);
    }

    /**
     * @param actor vk user actor
     * @return query
     */
    @ApiMethod("polls.getBackgrounds")
    public PollsGetBackgroundsQuery getBackgrounds(UserActor actor) {
        return new PollsGetBackgroundsQuery(getClient(), actor);
    }

    /**
     * Returns detailed information about a poll by its ID.
     *
     * @param actor vk user actor
     * @param pollId Poll ID.
     * @return query
     */
    @ApiMethod("polls.getById")
    public PollsGetByIdQuery getById(UserActor actor, Integer pollId) {
        return new PollsGetByIdQuery(getClient(), actor, pollId);
    }

    /**
     * Returns detailed information about a poll by its ID.
     *
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("polls.getById")
    public PollsGetByIdQuery getById(UserActor actor) {
        return new PollsGetByIdQuery(getClient(), actor);
    }

    /**
     * @param actor vk user actor
     * @return query
     */
    @ApiMethod("polls.getPhotoUploadServer")
    public PollsGetPhotoUploadServerQuery getPhotoUploadServer(UserActor actor) {
        return new PollsGetPhotoUploadServerQuery(getClient(), actor);
    }

    /**
     * Returns a list of IDs of users who selected specific answers in the poll.
     *
     * @param actor vk user actor
     * @param pollId Poll ID.
     * @param answerIds Answer IDs.
     * @param fields Profile fields to return. Sample values: 'nickname', 'screen_name', 'sex', 'bdate (birthdate)', 'city', 'country', 'timezone', 'photo', 'photo_medium', 'photo_big', 'has_mobile', 'rate', 'contacts', 'education', 'online', 'counters'.
     * @return query
     */
    @ApiMethod("polls.getVoters")
    public PollsGetVotersQueryWithFields getVotersWithFields(UserActor actor, Integer pollId,
            Long[] answerIds, Fields... fields) {
        return new PollsGetVotersQueryWithFields(getClient(), actor, pollId, answerIds, fields);
    }

    /**
     * Returns a list of IDs of users who selected specific answers in the poll.
     *
     * @param actor vk user actor
     * @param pollId Poll ID.
     * @param answerIds Answer IDs.
     * @param fields Profile fields to return. Sample values: 'nickname', 'screen_name', 'sex', 'bdate (birthdate)', 'city', 'country', 'timezone', 'photo', 'photo_medium', 'photo_big', 'has_mobile', 'rate', 'contacts', 'education', 'online', 'counters'.
     * @return query
     */
    @ApiMethod("polls.getVoters")
    public PollsGetVotersQueryWithFields getVotersWithFields(UserActor actor, Integer pollId,
            List<Long> answerIds, List<Fields> fields) {
        return new PollsGetVotersQueryWithFields(getClient(), actor, pollId, answerIds, fields);
    }

    /**
     * Returns a list of IDs of users who selected specific answers in the poll.
     *
     * @param actor vk user actor
     * @param pollId Poll ID.
     * @param answerIds Answer IDs.
     * @return query
     */
    @ApiMethod("polls.getVoters")
    public PollsGetVotersQuery getVoters(UserActor actor, Integer pollId, Long... answerIds) {
        return new PollsGetVotersQuery(getClient(), actor, pollId, answerIds);
    }

    /**
     * Returns a list of IDs of users who selected specific answers in the poll.
     *
     * @param actor vk user actor
     * @param pollId Poll ID.
     * @param answerIds Answer IDs.
     * @return query
     */
    @ApiMethod("polls.getVoters")
    public PollsGetVotersQuery getVoters(UserActor actor, Integer pollId, List<Long> answerIds) {
        return new PollsGetVotersQuery(getClient(), actor, pollId, answerIds);
    }

    /**
     * Returns a list of IDs of users who selected specific answers in the poll.
     *
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("polls.getVoters")
    public PollsGetVotersQuery getVoters(UserActor actor) {
        return new PollsGetVotersQuery(getClient(), actor);
    }

    /**
     * @param actor vk user actor
     * @param photo
     * @param hash
     * @return query
     */
    @ApiMethod("polls.savePhoto")
    public PollsSavePhotoQuery savePhoto(UserActor actor, String photo, String hash) {
        return new PollsSavePhotoQuery(getClient(), actor, photo, hash);
    }

    /**
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("polls.savePhoto")
    public PollsSavePhotoQuery savePhoto(UserActor actor) {
        return new PollsSavePhotoQuery(getClient(), actor);
    }
}
