// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.actions;

import com.vk.api.sdk.client.AbstractAction;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.objects.annotations.ApiMethod;
import com.vk.api.sdk.queries.store.StoreAddStickersToFavoriteQuery;
import com.vk.api.sdk.queries.store.StoreGetFavoriteStickersQuery;
import com.vk.api.sdk.queries.store.StoreGetProductsQuery;
import com.vk.api.sdk.queries.store.StoreGetStickersKeywordsQuery;
import com.vk.api.sdk.queries.store.StoreRemoveStickersFromFavoriteQuery;
import java.util.List;

/**
 * List of Store methods
 */
public class Store extends AbstractAction {
    /**
     * Constructor
     *
     * @param client vk api client
     */
    public Store(VkApiClient client) {
        super(client);
    }

    /**
     * Adds given sticker IDs to the list of user's favorite stickers
     *
     * @param actor vk user actor
     * @param stickerIds Sticker IDs to be added
     * @return query
     */
    @ApiMethod("store.addStickersToFavorite")
    public StoreAddStickersToFavoriteQuery addStickersToFavorite(UserActor actor,
            Integer... stickerIds) {
        return new StoreAddStickersToFavoriteQuery(getClient(), actor, stickerIds);
    }

    /**
     * Adds given sticker IDs to the list of user's favorite stickers
     *
     * @param actor vk user actor
     * @param stickerIds Sticker IDs to be added
     * @return query
     */
    @ApiMethod("store.addStickersToFavorite")
    public StoreAddStickersToFavoriteQuery addStickersToFavorite(UserActor actor,
            List<Integer> stickerIds) {
        return new StoreAddStickersToFavoriteQuery(getClient(), actor, stickerIds);
    }

    /**
     * Adds given sticker IDs to the list of user's favorite stickers
     *
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("store.addStickersToFavorite")
    public StoreAddStickersToFavoriteQuery addStickersToFavorite(UserActor actor) {
        return new StoreAddStickersToFavoriteQuery(getClient(), actor);
    }

    /**
     * @param actor vk user actor
     * @return query
     */
    @ApiMethod("store.getFavoriteStickers")
    public StoreGetFavoriteStickersQuery getFavoriteStickers(UserActor actor) {
        return new StoreGetFavoriteStickersQuery(getClient(), actor);
    }

    /**
     * @param actor vk user actor
     * @return query
     */
    @ApiMethod("store.getProducts")
    public StoreGetProductsQuery getProducts(UserActor actor) {
        return new StoreGetProductsQuery(getClient(), actor);
    }

    /**
     * @param actor vk user actor
     * @return query
     */
    @ApiMethod("store.getStickersKeywords")
    public StoreGetStickersKeywordsQuery getStickersKeywords(UserActor actor) {
        return new StoreGetStickersKeywordsQuery(getClient(), actor);
    }

    /**
     * Removes given sticker IDs from the list of user's favorite stickers
     *
     * @param actor vk user actor
     * @param stickerIds Sticker IDs to be removed
     * @return query
     */
    @ApiMethod("store.removeStickersFromFavorite")
    public StoreRemoveStickersFromFavoriteQuery removeStickersFromFavorite(UserActor actor,
            Integer... stickerIds) {
        return new StoreRemoveStickersFromFavoriteQuery(getClient(), actor, stickerIds);
    }

    /**
     * Removes given sticker IDs from the list of user's favorite stickers
     *
     * @param actor vk user actor
     * @param stickerIds Sticker IDs to be removed
     * @return query
     */
    @ApiMethod("store.removeStickersFromFavorite")
    public StoreRemoveStickersFromFavoriteQuery removeStickersFromFavorite(UserActor actor,
            List<Integer> stickerIds) {
        return new StoreRemoveStickersFromFavoriteQuery(getClient(), actor, stickerIds);
    }

    /**
     * Removes given sticker IDs from the list of user's favorite stickers
     *
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("store.removeStickersFromFavorite")
    public StoreRemoveStickersFromFavoriteQuery removeStickersFromFavorite(UserActor actor) {
        return new StoreRemoveStickersFromFavoriteQuery(getClient(), actor);
    }
}
