// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.actions;

import com.vk.api.sdk.client.AbstractAction;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.GroupActor;
import com.vk.api.sdk.client.actors.ServiceActor;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.objects.annotations.ApiMethod;
import com.vk.api.sdk.objects.users.Fields;
import com.vk.api.sdk.objects.users.ReportType;
import com.vk.api.sdk.queries.users.UsersGetFollowersQuery;
import com.vk.api.sdk.queries.users.UsersGetFollowersQueryWithFields;
import com.vk.api.sdk.queries.users.UsersGetQuery;
import com.vk.api.sdk.queries.users.UsersGetSubscriptionsQuery;
import com.vk.api.sdk.queries.users.UsersGetSubscriptionsQueryWithExtended;
import com.vk.api.sdk.queries.users.UsersReportQuery;
import com.vk.api.sdk.queries.users.UsersSearchQuery;

/**
 * List of Users methods
 */
public class Users extends AbstractAction {
    /**
     * Constructor
     *
     * @param client vk api client
     */
    public Users(VkApiClient client) {
        super(client);
    }

    /**
     * Returns detailed information on users.
     *
     * @param actor vk user actor
     * @return query
     */
    @ApiMethod("users.get")
    public UsersGetQuery get(UserActor actor) {
        return new UsersGetQuery(getClient(), actor);
    }

    /**
     * Returns detailed information on users.
     *
     * @param actor vk group actor
     * @return query
     */
    @ApiMethod("users.get")
    public UsersGetQuery get(GroupActor actor) {
        return new UsersGetQuery(getClient(), actor);
    }

    /**
     * Returns detailed information on users.
     *
     * @param actor vk service actor
     * @return query
     */
    @ApiMethod("users.get")
    public UsersGetQuery get(ServiceActor actor) {
        return new UsersGetQuery(getClient(), actor);
    }

    /**
     * Returns a list of IDs of followers of the user in question, sorted by date added, most recent first.
     *
     * @param actor vk user actor
     * @return query
     */
    @ApiMethod("users.getFollowers")
    public UsersGetFollowersQuery getFollowers(UserActor actor) {
        return new UsersGetFollowersQuery(getClient(), actor);
    }

    /**
     * Returns a list of IDs of followers of the user in question, sorted by date added, most recent first.
     *
     * @param actor vk service actor
     * @return query
     */
    @ApiMethod("users.getFollowers")
    public UsersGetFollowersQuery getFollowers(ServiceActor actor) {
        return new UsersGetFollowersQuery(getClient(), actor);
    }

    /**
     * Returns a list of IDs of followers of the user in question, sorted by date added, most recent first.
     *
     * @param actor vk user actor
     * @param fields Profile fields to return. Sample values: 'nickname', 'screen_name', 'sex', 'bdate' (birthdate), 'city', 'country', 'timezone', 'photo', 'photo_medium', 'photo_big', 'has_mobile', 'rate', 'contacts', 'education', 'online'.
     * @return query
     */
    @ApiMethod("users.getFollowers")
    public UsersGetFollowersQueryWithFields getFollowersWithFields(UserActor actor,
            Fields... fields) {
        return new UsersGetFollowersQueryWithFields(getClient(), actor, fields);
    }

    /**
     * Returns a list of IDs of followers of the user in question, sorted by date added, most recent first.
     *
     * @param actor vk service actor
     * @param fields Profile fields to return. Sample values: 'nickname', 'screen_name', 'sex', 'bdate' (birthdate), 'city', 'country', 'timezone', 'photo', 'photo_medium', 'photo_big', 'has_mobile', 'rate', 'contacts', 'education', 'online'.
     * @return query
     */
    @ApiMethod("users.getFollowers")
    public UsersGetFollowersQueryWithFields getFollowersWithFields(ServiceActor actor,
            Fields... fields) {
        return new UsersGetFollowersQueryWithFields(getClient(), actor, fields);
    }

    /**
     * Returns a list of IDs of users and communities followed by the user.
     *
     * @param actor vk user actor
     * @return query
     */
    @ApiMethod("users.getSubscriptions")
    public UsersGetSubscriptionsQueryWithExtended getSubscriptionsExtended(UserActor actor) {
        return new UsersGetSubscriptionsQueryWithExtended(getClient(), actor);
    }

    /**
     * Returns a list of IDs of users and communities followed by the user.
     *
     * @param actor vk service actor
     * @return query
     */
    @ApiMethod("users.getSubscriptions")
    public UsersGetSubscriptionsQueryWithExtended getSubscriptionsExtended(ServiceActor actor) {
        return new UsersGetSubscriptionsQueryWithExtended(getClient(), actor);
    }

    /**
     * Returns a list of IDs of users and communities followed by the user.
     *
     * @param actor vk user actor
     * @return query
     */
    @ApiMethod("users.getSubscriptions")
    public UsersGetSubscriptionsQuery getSubscriptions(UserActor actor) {
        return new UsersGetSubscriptionsQuery(getClient(), actor);
    }

    /**
     * Returns a list of IDs of users and communities followed by the user.
     *
     * @param actor vk service actor
     * @return query
     */
    @ApiMethod("users.getSubscriptions")
    public UsersGetSubscriptionsQuery getSubscriptions(ServiceActor actor) {
        return new UsersGetSubscriptionsQuery(getClient(), actor);
    }

    /**
     * Reports (submits a complain about) a user.
     *
     * @param actor vk user actor
     * @param userId ID of the user about whom a complaint is being made.
     * @param type Type of complaint: 'porn' - pornography, 'spam' - spamming, 'insult' - abusive behavior, 'advertisement' - disruptive advertisements
     * @return query
     */
    @ApiMethod("users.report")
    public UsersReportQuery report(UserActor actor, Long userId, ReportType type) {
        return new UsersReportQuery(getClient(), actor, userId, type);
    }

    /**
     * Reports (submits a complain about) a user.
     *
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("users.report")
    public UsersReportQuery report(UserActor actor) {
        return new UsersReportQuery(getClient(), actor);
    }

    /**
     * Returns a list of users matching the search criteria.
     *
     * @param actor vk user actor
     * @return query
     */
    @ApiMethod("users.search")
    public UsersSearchQuery search(UserActor actor) {
        return new UsersSearchQuery(getClient(), actor);
    }
}
