// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.actions;

import com.vk.api.sdk.client.AbstractAction;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.GroupActor;
import com.vk.api.sdk.client.actors.ServiceActor;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.objects.annotations.ApiMethod;
import com.vk.api.sdk.queries.utils.UtilsCheckLinkQuery;
import com.vk.api.sdk.queries.utils.UtilsDeleteFromLastShortenedQuery;
import com.vk.api.sdk.queries.utils.UtilsGetLastShortenedLinksQuery;
import com.vk.api.sdk.queries.utils.UtilsGetLinkStatsQuery;
import com.vk.api.sdk.queries.utils.UtilsGetLinkStatsQueryWithExtended;
import com.vk.api.sdk.queries.utils.UtilsGetServerTimeQuery;
import com.vk.api.sdk.queries.utils.UtilsGetShortLinkQuery;
import com.vk.api.sdk.queries.utils.UtilsResolveScreenNameQuery;

/**
 * List of Utils methods
 */
public class Utils extends AbstractAction {
    /**
     * Constructor
     *
     * @param client vk api client
     */
    public Utils(VkApiClient client) {
        super(client);
    }

    /**
     * Checks whether a link is blocked in VK.
     *
     * @param actor vk user actor
     * @param url Link to check (e.g., 'http://google.com').
     * @return query
     */
    @ApiMethod("utils.checkLink")
    public UtilsCheckLinkQuery checkLink(UserActor actor, String url) {
        return new UtilsCheckLinkQuery(getClient(), actor, url);
    }

    /**
     * Checks whether a link is blocked in VK.
     *
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("utils.checkLink")
    public UtilsCheckLinkQuery checkLink(UserActor actor) {
        return new UtilsCheckLinkQuery(getClient(), actor);
    }

    /**
     * Checks whether a link is blocked in VK.
     *
     * @param actor vk group actor
     * @param url Link to check (e.g., 'http://google.com').
     * @return query
     */
    @ApiMethod("utils.checkLink")
    public UtilsCheckLinkQuery checkLink(GroupActor actor, String url) {
        return new UtilsCheckLinkQuery(getClient(), actor, url);
    }

    /**
     * Checks whether a link is blocked in VK.
     *
     * @param actor vk group actor
     * @return only actor query 
     */
    @ApiMethod("utils.checkLink")
    public UtilsCheckLinkQuery checkLink(GroupActor actor) {
        return new UtilsCheckLinkQuery(getClient(), actor);
    }

    /**
     * Checks whether a link is blocked in VK.
     *
     * @param actor vk service actor
     * @param url Link to check (e.g., 'http://google.com').
     * @return query
     */
    @ApiMethod("utils.checkLink")
    public UtilsCheckLinkQuery checkLink(ServiceActor actor, String url) {
        return new UtilsCheckLinkQuery(getClient(), actor, url);
    }

    /**
     * Checks whether a link is blocked in VK.
     *
     * @param actor vk service actor
     * @return only actor query 
     */
    @ApiMethod("utils.checkLink")
    public UtilsCheckLinkQuery checkLink(ServiceActor actor) {
        return new UtilsCheckLinkQuery(getClient(), actor);
    }

    /**
     * Deletes shortened link from user's list.
     *
     * @param actor vk user actor
     * @param key Link key (characters after vk.cc/).
     * @return query
     */
    @ApiMethod("utils.deleteFromLastShortened")
    public UtilsDeleteFromLastShortenedQuery deleteFromLastShortened(UserActor actor, String key) {
        return new UtilsDeleteFromLastShortenedQuery(getClient(), actor, key);
    }

    /**
     * Deletes shortened link from user's list.
     *
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("utils.deleteFromLastShortened")
    public UtilsDeleteFromLastShortenedQuery deleteFromLastShortened(UserActor actor) {
        return new UtilsDeleteFromLastShortenedQuery(getClient(), actor);
    }

    /**
     * Returns a list of user's shortened links.
     *
     * @param actor vk user actor
     * @return query
     */
    @ApiMethod("utils.getLastShortenedLinks")
    public UtilsGetLastShortenedLinksQuery getLastShortenedLinks(UserActor actor) {
        return new UtilsGetLastShortenedLinksQuery(getClient(), actor);
    }

    /**
     * Returns stats data for shortened link.
     *
     * @param actor vk user actor
     * @param key Link key (characters after vk.cc/).
     * @return query
     */
    @ApiMethod("utils.getLinkStats")
    public UtilsGetLinkStatsQueryWithExtended getLinkStatsExtended(UserActor actor, String key) {
        return new UtilsGetLinkStatsQueryWithExtended(getClient(), actor, key);
    }

    /**
     * Returns stats data for shortened link.
     *
     * @param actor vk group actor
     * @param key Link key (characters after vk.cc/).
     * @return query
     */
    @ApiMethod("utils.getLinkStats")
    public UtilsGetLinkStatsQueryWithExtended getLinkStatsExtended(GroupActor actor, String key) {
        return new UtilsGetLinkStatsQueryWithExtended(getClient(), actor, key);
    }

    /**
     * Returns stats data for shortened link.
     *
     * @param actor vk service actor
     * @param key Link key (characters after vk.cc/).
     * @return query
     */
    @ApiMethod("utils.getLinkStats")
    public UtilsGetLinkStatsQueryWithExtended getLinkStatsExtended(ServiceActor actor, String key) {
        return new UtilsGetLinkStatsQueryWithExtended(getClient(), actor, key);
    }

    /**
     * Returns stats data for shortened link.
     *
     * @param actor vk user actor
     * @param key Link key (characters after vk.cc/).
     * @return query
     */
    @ApiMethod("utils.getLinkStats")
    public UtilsGetLinkStatsQuery getLinkStats(UserActor actor, String key) {
        return new UtilsGetLinkStatsQuery(getClient(), actor, key);
    }

    /**
     * Returns stats data for shortened link.
     *
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("utils.getLinkStats")
    public UtilsGetLinkStatsQuery getLinkStats(UserActor actor) {
        return new UtilsGetLinkStatsQuery(getClient(), actor);
    }

    /**
     * Returns stats data for shortened link.
     *
     * @param actor vk group actor
     * @param key Link key (characters after vk.cc/).
     * @return query
     */
    @ApiMethod("utils.getLinkStats")
    public UtilsGetLinkStatsQuery getLinkStats(GroupActor actor, String key) {
        return new UtilsGetLinkStatsQuery(getClient(), actor, key);
    }

    /**
     * Returns stats data for shortened link.
     *
     * @param actor vk group actor
     * @return only actor query 
     */
    @ApiMethod("utils.getLinkStats")
    public UtilsGetLinkStatsQuery getLinkStats(GroupActor actor) {
        return new UtilsGetLinkStatsQuery(getClient(), actor);
    }

    /**
     * Returns stats data for shortened link.
     *
     * @param actor vk service actor
     * @param key Link key (characters after vk.cc/).
     * @return query
     */
    @ApiMethod("utils.getLinkStats")
    public UtilsGetLinkStatsQuery getLinkStats(ServiceActor actor, String key) {
        return new UtilsGetLinkStatsQuery(getClient(), actor, key);
    }

    /**
     * Returns stats data for shortened link.
     *
     * @param actor vk service actor
     * @return only actor query 
     */
    @ApiMethod("utils.getLinkStats")
    public UtilsGetLinkStatsQuery getLinkStats(ServiceActor actor) {
        return new UtilsGetLinkStatsQuery(getClient(), actor);
    }

    /**
     * Returns the current time of the VK server.
     *
     * @param actor vk user actor
     * @return query
     */
    @ApiMethod("utils.getServerTime")
    public UtilsGetServerTimeQuery getServerTime(UserActor actor) {
        return new UtilsGetServerTimeQuery(getClient(), actor);
    }

    /**
     * Returns the current time of the VK server.
     *
     * @param actor vk group actor
     * @return query
     */
    @ApiMethod("utils.getServerTime")
    public UtilsGetServerTimeQuery getServerTime(GroupActor actor) {
        return new UtilsGetServerTimeQuery(getClient(), actor);
    }

    /**
     * Returns the current time of the VK server.
     *
     * @param actor vk service actor
     * @return query
     */
    @ApiMethod("utils.getServerTime")
    public UtilsGetServerTimeQuery getServerTime(ServiceActor actor) {
        return new UtilsGetServerTimeQuery(getClient(), actor);
    }

    /**
     * Allows to receive a link shortened via vk.cc.
     *
     * @param actor vk user actor
     * @param url URL to be shortened.
     * @return query
     */
    @ApiMethod("utils.getShortLink")
    public UtilsGetShortLinkQuery getShortLink(UserActor actor, String url) {
        return new UtilsGetShortLinkQuery(getClient(), actor, url);
    }

    /**
     * Allows to receive a link shortened via vk.cc.
     *
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("utils.getShortLink")
    public UtilsGetShortLinkQuery getShortLink(UserActor actor) {
        return new UtilsGetShortLinkQuery(getClient(), actor);
    }

    /**
     * Allows to receive a link shortened via vk.cc.
     *
     * @param actor vk group actor
     * @param url URL to be shortened.
     * @return query
     */
    @ApiMethod("utils.getShortLink")
    public UtilsGetShortLinkQuery getShortLink(GroupActor actor, String url) {
        return new UtilsGetShortLinkQuery(getClient(), actor, url);
    }

    /**
     * Allows to receive a link shortened via vk.cc.
     *
     * @param actor vk group actor
     * @return only actor query 
     */
    @ApiMethod("utils.getShortLink")
    public UtilsGetShortLinkQuery getShortLink(GroupActor actor) {
        return new UtilsGetShortLinkQuery(getClient(), actor);
    }

    /**
     * Allows to receive a link shortened via vk.cc.
     *
     * @param actor vk service actor
     * @param url URL to be shortened.
     * @return query
     */
    @ApiMethod("utils.getShortLink")
    public UtilsGetShortLinkQuery getShortLink(ServiceActor actor, String url) {
        return new UtilsGetShortLinkQuery(getClient(), actor, url);
    }

    /**
     * Allows to receive a link shortened via vk.cc.
     *
     * @param actor vk service actor
     * @return only actor query 
     */
    @ApiMethod("utils.getShortLink")
    public UtilsGetShortLinkQuery getShortLink(ServiceActor actor) {
        return new UtilsGetShortLinkQuery(getClient(), actor);
    }

    /**
     * Detects a type of object (e.g., user, community, application) and its ID by screen name.
     *
     * @param actor vk user actor
     * @param screenName Screen name of the user, community (e.g., 'apiclub,' 'andrew', or 'rules_of_war'), or application.
     * @return query
     */
    @ApiMethod("utils.resolveScreenName")
    public UtilsResolveScreenNameQuery resolveScreenName(UserActor actor, String screenName) {
        return new UtilsResolveScreenNameQuery(getClient(), actor, screenName);
    }

    /**
     * Detects a type of object (e.g., user, community, application) and its ID by screen name.
     *
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("utils.resolveScreenName")
    public UtilsResolveScreenNameQuery resolveScreenName(UserActor actor) {
        return new UtilsResolveScreenNameQuery(getClient(), actor);
    }

    /**
     * Detects a type of object (e.g., user, community, application) and its ID by screen name.
     *
     * @param actor vk group actor
     * @param screenName Screen name of the user, community (e.g., 'apiclub,' 'andrew', or 'rules_of_war'), or application.
     * @return query
     */
    @ApiMethod("utils.resolveScreenName")
    public UtilsResolveScreenNameQuery resolveScreenName(GroupActor actor, String screenName) {
        return new UtilsResolveScreenNameQuery(getClient(), actor, screenName);
    }

    /**
     * Detects a type of object (e.g., user, community, application) and its ID by screen name.
     *
     * @param actor vk group actor
     * @return only actor query 
     */
    @ApiMethod("utils.resolveScreenName")
    public UtilsResolveScreenNameQuery resolveScreenName(GroupActor actor) {
        return new UtilsResolveScreenNameQuery(getClient(), actor);
    }

    /**
     * Detects a type of object (e.g., user, community, application) and its ID by screen name.
     *
     * @param actor vk service actor
     * @param screenName Screen name of the user, community (e.g., 'apiclub,' 'andrew', or 'rules_of_war'), or application.
     * @return query
     */
    @ApiMethod("utils.resolveScreenName")
    public UtilsResolveScreenNameQuery resolveScreenName(ServiceActor actor, String screenName) {
        return new UtilsResolveScreenNameQuery(getClient(), actor, screenName);
    }

    /**
     * Detects a type of object (e.g., user, community, application) and its ID by screen name.
     *
     * @param actor vk service actor
     * @return only actor query 
     */
    @ApiMethod("utils.resolveScreenName")
    public UtilsResolveScreenNameQuery resolveScreenName(ServiceActor actor) {
        return new UtilsResolveScreenNameQuery(getClient(), actor);
    }
}
