// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.actions;

import com.vk.api.sdk.client.AbstractAction;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.objects.annotations.ApiMethod;
import com.vk.api.sdk.queries.video.VideoAddAlbumQuery;
import com.vk.api.sdk.queries.video.VideoAddQuery;
import com.vk.api.sdk.queries.video.VideoAddToAlbumQuery;
import com.vk.api.sdk.queries.video.VideoCreateCommentQuery;
import com.vk.api.sdk.queries.video.VideoDeleteAlbumQuery;
import com.vk.api.sdk.queries.video.VideoDeleteCommentQuery;
import com.vk.api.sdk.queries.video.VideoDeleteQuery;
import com.vk.api.sdk.queries.video.VideoEditAlbumQuery;
import com.vk.api.sdk.queries.video.VideoEditCommentQuery;
import com.vk.api.sdk.queries.video.VideoEditQuery;
import com.vk.api.sdk.queries.video.VideoGetAlbumByIdQuery;
import com.vk.api.sdk.queries.video.VideoGetAlbumsByVideoQuery;
import com.vk.api.sdk.queries.video.VideoGetAlbumsByVideoQueryWithExtended;
import com.vk.api.sdk.queries.video.VideoGetAlbumsQuery;
import com.vk.api.sdk.queries.video.VideoGetAlbumsQueryWithExtended;
import com.vk.api.sdk.queries.video.VideoGetCommentsQuery;
import com.vk.api.sdk.queries.video.VideoGetCommentsQueryWithExtended;
import com.vk.api.sdk.queries.video.VideoGetLongPollServerQuery;
import com.vk.api.sdk.queries.video.VideoGetQuery;
import com.vk.api.sdk.queries.video.VideoLiveGetCategoriesQuery;
import com.vk.api.sdk.queries.video.VideoRemoveFromAlbumQuery;
import com.vk.api.sdk.queries.video.VideoReorderAlbumsQuery;
import com.vk.api.sdk.queries.video.VideoReorderVideosQuery;
import com.vk.api.sdk.queries.video.VideoReportCommentQuery;
import com.vk.api.sdk.queries.video.VideoReportQuery;
import com.vk.api.sdk.queries.video.VideoRestoreCommentQuery;
import com.vk.api.sdk.queries.video.VideoRestoreQuery;
import com.vk.api.sdk.queries.video.VideoSaveQuery;
import com.vk.api.sdk.queries.video.VideoSearchQuery;
import com.vk.api.sdk.queries.video.VideoSearchQueryWithExtended;
import com.vk.api.sdk.queries.video.VideoStartStreamingQuery;
import com.vk.api.sdk.queries.video.VideoStopStreamingQuery;
import com.vk.api.sdk.queries.video.VideoUnpinCommentQuery;

/**
 * List of Video methods
 */
public class Video extends AbstractAction {
    /**
     * Constructor
     *
     * @param client vk api client
     */
    public Video(VkApiClient client) {
        super(client);
    }

    /**
     * Adds a video to a user or community page.
     *
     * @param actor vk user actor
     * @param videoId Video ID.
     * @param ownerId ID of the user or community that owns the video. Use a negative value to designate a community ID.
     * @return query
     */
    @ApiMethod("video.add")
    public VideoAddQuery add(UserActor actor, Integer videoId, Long ownerId) {
        return new VideoAddQuery(getClient(), actor, videoId, ownerId);
    }

    /**
     * Adds a video to a user or community page.
     *
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("video.add")
    public VideoAddQuery add(UserActor actor) {
        return new VideoAddQuery(getClient(), actor);
    }

    /**
     * Creates an empty album for videos.
     *
     * @param actor vk user actor
     * @return query
     */
    @ApiMethod("video.addAlbum")
    public VideoAddAlbumQuery addAlbum(UserActor actor) {
        return new VideoAddAlbumQuery(getClient(), actor);
    }

    /**
     * @param actor vk user actor
     * @param ownerId
     * @param videoId
     * @return query
     */
    @ApiMethod("video.addToAlbum")
    public VideoAddToAlbumQuery addToAlbum(UserActor actor, Long ownerId, Integer videoId) {
        return new VideoAddToAlbumQuery(getClient(), actor, ownerId, videoId);
    }

    /**
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("video.addToAlbum")
    public VideoAddToAlbumQuery addToAlbum(UserActor actor) {
        return new VideoAddToAlbumQuery(getClient(), actor);
    }

    /**
     * Adds a new comment on a video.
     *
     * @param actor vk user actor
     * @param videoId Video ID.
     * @return query
     */
    @ApiMethod("video.createComment")
    public VideoCreateCommentQuery createComment(UserActor actor, Integer videoId) {
        return new VideoCreateCommentQuery(getClient(), actor, videoId);
    }

    /**
     * Adds a new comment on a video.
     *
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("video.createComment")
    public VideoCreateCommentQuery createComment(UserActor actor) {
        return new VideoCreateCommentQuery(getClient(), actor);
    }

    /**
     * Deletes a video from a user or community page.
     *
     * @param actor vk user actor
     * @param videoId Video ID.
     * @return query
     */
    @ApiMethod("video.delete")
    public VideoDeleteQuery delete(UserActor actor, Integer videoId) {
        return new VideoDeleteQuery(getClient(), actor, videoId);
    }

    /**
     * Deletes a video from a user or community page.
     *
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("video.delete")
    public VideoDeleteQuery delete(UserActor actor) {
        return new VideoDeleteQuery(getClient(), actor);
    }

    /**
     * Deletes a video album.
     *
     * @param actor vk user actor
     * @param albumId Album ID.
     * @return query
     */
    @ApiMethod("video.deleteAlbum")
    public VideoDeleteAlbumQuery deleteAlbum(UserActor actor, Integer albumId) {
        return new VideoDeleteAlbumQuery(getClient(), actor, albumId);
    }

    /**
     * Deletes a video album.
     *
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("video.deleteAlbum")
    public VideoDeleteAlbumQuery deleteAlbum(UserActor actor) {
        return new VideoDeleteAlbumQuery(getClient(), actor);
    }

    /**
     * Deletes a comment on a video.
     *
     * @param actor vk user actor
     * @param commentId ID of the comment to be deleted.
     * @return query
     */
    @ApiMethod("video.deleteComment")
    public VideoDeleteCommentQuery deleteComment(UserActor actor, Integer commentId) {
        return new VideoDeleteCommentQuery(getClient(), actor, commentId);
    }

    /**
     * Deletes a comment on a video.
     *
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("video.deleteComment")
    public VideoDeleteCommentQuery deleteComment(UserActor actor) {
        return new VideoDeleteCommentQuery(getClient(), actor);
    }

    /**
     * Edits information about a video on a user or community page.
     *
     * @param actor vk user actor
     * @param videoId Video ID.
     * @return query
     */
    @ApiMethod("video.edit")
    public VideoEditQuery edit(UserActor actor, Integer videoId) {
        return new VideoEditQuery(getClient(), actor, videoId);
    }

    /**
     * Edits information about a video on a user or community page.
     *
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("video.edit")
    public VideoEditQuery edit(UserActor actor) {
        return new VideoEditQuery(getClient(), actor);
    }

    /**
     * Edits the title of a video album.
     *
     * @param actor vk user actor
     * @param albumId Album ID.
     * @return query
     */
    @ApiMethod("video.editAlbum")
    public VideoEditAlbumQuery editAlbum(UserActor actor, Integer albumId) {
        return new VideoEditAlbumQuery(getClient(), actor, albumId);
    }

    /**
     * Edits the title of a video album.
     *
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("video.editAlbum")
    public VideoEditAlbumQuery editAlbum(UserActor actor) {
        return new VideoEditAlbumQuery(getClient(), actor);
    }

    /**
     * Edits the text of a comment on a video.
     *
     * @param actor vk user actor
     * @param commentId Comment ID.
     * @return query
     */
    @ApiMethod("video.editComment")
    public VideoEditCommentQuery editComment(UserActor actor, Integer commentId) {
        return new VideoEditCommentQuery(getClient(), actor, commentId);
    }

    /**
     * Edits the text of a comment on a video.
     *
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("video.editComment")
    public VideoEditCommentQuery editComment(UserActor actor) {
        return new VideoEditCommentQuery(getClient(), actor);
    }

    /**
     * Returns detailed information about videos.
     *
     * @param actor vk user actor
     * @return query
     */
    @ApiMethod("video.get")
    public VideoGetQuery get(UserActor actor) {
        return new VideoGetQuery(getClient(), actor);
    }

    /**
     * Returns video album info
     *
     * @param actor vk user actor
     * @param albumId Album ID.
     * @return query
     */
    @ApiMethod("video.getAlbumById")
    public VideoGetAlbumByIdQuery getAlbumById(UserActor actor, Integer albumId) {
        return new VideoGetAlbumByIdQuery(getClient(), actor, albumId);
    }

    /**
     * Returns video album info
     *
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("video.getAlbumById")
    public VideoGetAlbumByIdQuery getAlbumById(UserActor actor) {
        return new VideoGetAlbumByIdQuery(getClient(), actor);
    }

    /**
     * Returns a list of video albums owned by a user or community.
     *
     * @param actor vk user actor
     * @return query
     */
    @ApiMethod("video.getAlbums")
    public VideoGetAlbumsQueryWithExtended getAlbumsExtended(UserActor actor) {
        return new VideoGetAlbumsQueryWithExtended(getClient(), actor);
    }

    /**
     * Returns a list of video albums owned by a user or community.
     *
     * @param actor vk user actor
     * @return query
     */
    @ApiMethod("video.getAlbums")
    public VideoGetAlbumsQuery getAlbums(UserActor actor) {
        return new VideoGetAlbumsQuery(getClient(), actor);
    }

    /**
     * @param actor vk user actor
     * @param ownerId
     * @param videoId
     * @return query
     */
    @ApiMethod("video.getAlbumsByVideo")
    public VideoGetAlbumsByVideoQuery getAlbumsByVideo(UserActor actor, Long ownerId,
            Integer videoId) {
        return new VideoGetAlbumsByVideoQuery(getClient(), actor, ownerId, videoId);
    }

    /**
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("video.getAlbumsByVideo")
    public VideoGetAlbumsByVideoQuery getAlbumsByVideo(UserActor actor) {
        return new VideoGetAlbumsByVideoQuery(getClient(), actor);
    }

    /**
     * @param actor vk user actor
     * @param ownerId
     * @param videoId
     * @return query
     */
    @ApiMethod("video.getAlbumsByVideo")
    public VideoGetAlbumsByVideoQueryWithExtended getAlbumsByVideoExtended(UserActor actor,
            Long ownerId, Integer videoId) {
        return new VideoGetAlbumsByVideoQueryWithExtended(getClient(), actor, ownerId, videoId);
    }

    /**
     * Returns a list of comments on a video.
     *
     * @param actor vk user actor
     * @param videoId Video ID.
     * @return query
     */
    @ApiMethod("video.getComments")
    public VideoGetCommentsQuery getComments(UserActor actor, Integer videoId) {
        return new VideoGetCommentsQuery(getClient(), actor, videoId);
    }

    /**
     * Returns a list of comments on a video.
     *
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("video.getComments")
    public VideoGetCommentsQuery getComments(UserActor actor) {
        return new VideoGetCommentsQuery(getClient(), actor);
    }

    /**
     * Returns a list of comments on a video.
     *
     * @param actor vk user actor
     * @param videoId Video ID.
     * @return query
     */
    @ApiMethod("video.getComments")
    public VideoGetCommentsQueryWithExtended getCommentsExtended(UserActor actor, Integer videoId) {
        return new VideoGetCommentsQueryWithExtended(getClient(), actor, videoId);
    }

    /**
     * @param actor vk user actor
     * @param videoId
     * @return query
     */
    @ApiMethod("video.getLongPollServer")
    public VideoGetLongPollServerQuery getLongPollServer(UserActor actor, Integer videoId) {
        return new VideoGetLongPollServerQuery(getClient(), actor, videoId);
    }

    /**
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("video.getLongPollServer")
    public VideoGetLongPollServerQuery getLongPollServer(UserActor actor) {
        return new VideoGetLongPollServerQuery(getClient(), actor);
    }

    /**
     * @param actor vk user actor
     * @return query
     */
    @ApiMethod("video.liveGetCategories")
    public VideoLiveGetCategoriesQuery liveGetCategories(UserActor actor) {
        return new VideoLiveGetCategoriesQuery(getClient(), actor);
    }

    /**
     * @param actor vk user actor
     * @param ownerId
     * @param videoId
     * @return query
     */
    @ApiMethod("video.removeFromAlbum")
    public VideoRemoveFromAlbumQuery removeFromAlbum(UserActor actor, Long ownerId,
            Integer videoId) {
        return new VideoRemoveFromAlbumQuery(getClient(), actor, ownerId, videoId);
    }

    /**
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("video.removeFromAlbum")
    public VideoRemoveFromAlbumQuery removeFromAlbum(UserActor actor) {
        return new VideoRemoveFromAlbumQuery(getClient(), actor);
    }

    /**
     * Reorders the album in the list of user video albums.
     *
     * @param actor vk user actor
     * @param albumId Album ID.
     * @return query
     */
    @ApiMethod("video.reorderAlbums")
    public VideoReorderAlbumsQuery reorderAlbums(UserActor actor, Integer albumId) {
        return new VideoReorderAlbumsQuery(getClient(), actor, albumId);
    }

    /**
     * Reorders the album in the list of user video albums.
     *
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("video.reorderAlbums")
    public VideoReorderAlbumsQuery reorderAlbums(UserActor actor) {
        return new VideoReorderAlbumsQuery(getClient(), actor);
    }

    /**
     * Reorders the video in the video album.
     *
     * @param actor vk user actor
     * @param ownerId ID of the user or community that owns the video.
     * @param videoId ID of the video.
     * @return query
     */
    @ApiMethod("video.reorderVideos")
    public VideoReorderVideosQuery reorderVideos(UserActor actor, Long ownerId, Integer videoId) {
        return new VideoReorderVideosQuery(getClient(), actor, ownerId, videoId);
    }

    /**
     * Reorders the video in the video album.
     *
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("video.reorderVideos")
    public VideoReorderVideosQuery reorderVideos(UserActor actor) {
        return new VideoReorderVideosQuery(getClient(), actor);
    }

    /**
     * Reports (submits a complaint about) a video.
     *
     * @param actor vk user actor
     * @param ownerId ID of the user or community that owns the video.
     * @param videoId Video ID.
     * @return query
     */
    @ApiMethod("video.report")
    public VideoReportQuery report(UserActor actor, Long ownerId, Integer videoId) {
        return new VideoReportQuery(getClient(), actor, ownerId, videoId);
    }

    /**
     * Reports (submits a complaint about) a video.
     *
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("video.report")
    public VideoReportQuery report(UserActor actor) {
        return new VideoReportQuery(getClient(), actor);
    }

    /**
     * Reports (submits a complaint about) a comment on a video.
     *
     * @param actor vk user actor
     * @param ownerId ID of the user or community that owns the video.
     * @param commentId ID of the comment being reported.
     * @return query
     */
    @ApiMethod("video.reportComment")
    public VideoReportCommentQuery reportComment(UserActor actor, Long ownerId, Integer commentId) {
        return new VideoReportCommentQuery(getClient(), actor, ownerId, commentId);
    }

    /**
     * Reports (submits a complaint about) a comment on a video.
     *
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("video.reportComment")
    public VideoReportCommentQuery reportComment(UserActor actor) {
        return new VideoReportCommentQuery(getClient(), actor);
    }

    /**
     * Restores a previously deleted video.
     *
     * @param actor vk user actor
     * @param videoId Video ID.
     * @return query
     */
    @ApiMethod("video.restore")
    public VideoRestoreQuery restore(UserActor actor, Integer videoId) {
        return new VideoRestoreQuery(getClient(), actor, videoId);
    }

    /**
     * Restores a previously deleted video.
     *
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("video.restore")
    public VideoRestoreQuery restore(UserActor actor) {
        return new VideoRestoreQuery(getClient(), actor);
    }

    /**
     * Restores a previously deleted comment on a video.
     *
     * @param actor vk user actor
     * @param commentId ID of the deleted comment.
     * @return query
     */
    @ApiMethod("video.restoreComment")
    public VideoRestoreCommentQuery restoreComment(UserActor actor, Integer commentId) {
        return new VideoRestoreCommentQuery(getClient(), actor, commentId);
    }

    /**
     * Restores a previously deleted comment on a video.
     *
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("video.restoreComment")
    public VideoRestoreCommentQuery restoreComment(UserActor actor) {
        return new VideoRestoreCommentQuery(getClient(), actor);
    }

    /**
     * Returns a server address (required for upload) and video data.
     *
     * @param actor vk user actor
     * @return query
     */
    @ApiMethod("video.save")
    public VideoSaveQuery save(UserActor actor) {
        return new VideoSaveQuery(getClient(), actor);
    }

    /**
     * Returns a list of videos under the set search criterion.
     *
     * @param actor vk user actor
     * @return query
     */
    @ApiMethod("video.search")
    public VideoSearchQuery search(UserActor actor) {
        return new VideoSearchQuery(getClient(), actor);
    }

    /**
     * Returns a list of videos under the set search criterion.
     *
     * @param actor vk user actor
     * @return query
     */
    @ApiMethod("video.search")
    public VideoSearchQueryWithExtended searchExtended(UserActor actor) {
        return new VideoSearchQueryWithExtended(getClient(), actor);
    }

    /**
     * @param actor vk user actor
     * @return query
     */
    @ApiMethod("video.startStreaming")
    public VideoStartStreamingQuery startStreaming(UserActor actor) {
        return new VideoStartStreamingQuery(getClient(), actor);
    }

    /**
     * @param actor vk user actor
     * @return query
     */
    @ApiMethod("video.stopStreaming")
    public VideoStopStreamingQuery stopStreaming(UserActor actor) {
        return new VideoStopStreamingQuery(getClient(), actor);
    }

    /**
     * Unpin comment of a video.
     *
     * @param actor vk user actor
     * @param ownerId ID of the user or community that owns the video.
     * @param commentId
     * @return query
     */
    @ApiMethod("video.unpinComment")
    public VideoUnpinCommentQuery unpinComment(UserActor actor, Long ownerId, Integer commentId) {
        return new VideoUnpinCommentQuery(getClient(), actor, ownerId, commentId);
    }

    /**
     * Unpin comment of a video.
     *
     * @param actor vk user actor
     * @return only actor query 
     */
    @ApiMethod("video.unpinComment")
    public VideoUnpinCommentQuery unpinComment(UserActor actor) {
        return new VideoUnpinCommentQuery(getClient(), actor);
    }
}
