// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.objects.ads;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import com.vk.api.sdk.objects.Validable;
import com.vk.api.sdk.objects.annotations.Required;
import java.util.Objects;

/**
 * Musician object
 */
public class Musician implements Validable {
    /**
     * Music artist photo
     */
    @SerializedName("avatar")
    private String avatar;

    /**
     * Targeting music artist ID
     */
    @SerializedName("id")
    @Required
    private Integer id;

    /**
     * Music artist name
     */
    @SerializedName("name")
    @Required
    private String name;

    /**
     * Music artist ID as in VKMusic
     */
    @SerializedName("original_id")
    @Required
    private Long originalId;

    public String getAvatar() {
        return avatar;
    }

    public Musician setAvatar(String avatar) {
        this.avatar = avatar;
        return this;
    }

    public Integer getId() {
        return id;
    }

    public Musician setId(Integer id) {
        this.id = id;
        return this;
    }

    public String getName() {
        return name;
    }

    public Musician setName(String name) {
        this.name = name;
        return this;
    }

    public Long getOriginalId() {
        return originalId;
    }

    public Musician setOriginalId(Long originalId) {
        this.originalId = originalId;
        return this;
    }

    @Override
    public int hashCode() {
        return Objects.hash(name, avatar, id, originalId);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Musician musician = (Musician) o;
        return Objects.equals(name, musician.name) &&
                Objects.equals(avatar, musician.avatar) &&
                Objects.equals(id, musician.id) &&
                Objects.equals(originalId, musician.originalId);
    }

    @Override
    public String toString() {
        final Gson gson = new Gson();
        return gson.toJson(this);
    }

    public String toPrettyString() {
        final StringBuilder sb = new StringBuilder("Musician{");
        sb.append("name='").append(name).append("'");
        sb.append(", avatar='").append(avatar).append("'");
        sb.append(", id=").append(id);
        sb.append(", originalId=").append(originalId);
        sb.append('}');
        return sb.toString();
    }
}
