// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.objects.base;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import com.vk.api.sdk.objects.Validable;
import com.vk.api.sdk.objects.annotations.Required;
import java.util.Objects;

/**
 * LikesInfo object
 */
public class LikesInfo implements Validable {
    /**
     * Information whether author of the post/reply liked it
     */
    @SerializedName("author_liked")
    private Boolean authorLiked;

    /**
     * Information whether current user can like the post
     */
    @SerializedName("can_like")
    @Required
    private BoolInt canLike;

    /**
     * Information whether current user can repost
     */
    @SerializedName("can_publish")
    private BoolInt canPublish;

    /**
     * Likes number
     */
    @SerializedName("count")
    @Required
    private Integer count;

    /**
     * Remove repost feature for post
     */
    @SerializedName("repost_disabled")
    private Boolean repostDisabled;

    /**
     * Information whether current uer has liked the post
     */
    @SerializedName("user_likes")
    @Required
    private BoolInt userLikes;

    public Boolean getAuthorLiked() {
        return authorLiked;
    }

    public LikesInfo setAuthorLiked(Boolean authorLiked) {
        this.authorLiked = authorLiked;
        return this;
    }

    public boolean canLike() {
        return canLike == BoolInt.YES;
    }

    public BoolInt getCanLike() {
        return canLike;
    }

    public boolean canPublish() {
        return canPublish == BoolInt.YES;
    }

    public BoolInt getCanPublish() {
        return canPublish;
    }

    public Integer getCount() {
        return count;
    }

    public LikesInfo setCount(Integer count) {
        this.count = count;
        return this;
    }

    public Boolean getRepostDisabled() {
        return repostDisabled;
    }

    public LikesInfo setRepostDisabled(Boolean repostDisabled) {
        this.repostDisabled = repostDisabled;
        return this;
    }

    public boolean isUserLikes() {
        return userLikes == BoolInt.YES;
    }

    public BoolInt getUserLikes() {
        return userLikes;
    }

    @Override
    public int hashCode() {
        return Objects.hash(authorLiked, canLike, canPublish, repostDisabled, count, userLikes);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        LikesInfo likesInfo = (LikesInfo) o;
        return Objects.equals(userLikes, likesInfo.userLikes) &&
                Objects.equals(canPublish, likesInfo.canPublish) &&
                Objects.equals(canLike, likesInfo.canLike) &&
                Objects.equals(repostDisabled, likesInfo.repostDisabled) &&
                Objects.equals(count, likesInfo.count) &&
                Objects.equals(authorLiked, likesInfo.authorLiked);
    }

    @Override
    public String toString() {
        final Gson gson = new Gson();
        return gson.toJson(this);
    }

    public String toPrettyString() {
        final StringBuilder sb = new StringBuilder("LikesInfo{");
        sb.append("userLikes=").append(userLikes);
        sb.append(", canPublish=").append(canPublish);
        sb.append(", canLike=").append(canLike);
        sb.append(", repostDisabled=").append(repostDisabled);
        sb.append(", count=").append(count);
        sb.append(", authorLiked=").append(authorLiked);
        sb.append('}');
        return sb.toString();
    }
}
