// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.objects.base;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import com.vk.api.sdk.objects.Validable;
import com.vk.api.sdk.objects.annotations.Required;
import com.vk.api.sdk.objects.link.TargetObject;
import com.vk.api.sdk.objects.photos.Photo;
import com.vk.api.sdk.objects.video.VideoFull;
import java.net.URI;
import java.util.Objects;

/**
 * LinkNoProduct object
 */
public class LinkNoProduct implements Validable {
    @SerializedName("application")
    private LinkApplication application;

    @SerializedName("button")
    private LinkButton button;

    /**
     * Link caption
     */
    @SerializedName("caption")
    private String caption;

    /**
     * Link description
     */
    @SerializedName("description")
    private String description;

    /**
     * Link ID
     */
    @SerializedName("id")
    private String id;

    /**
     * Information whether the current link is external
     */
    @SerializedName("is_external")
    private Boolean isExternal;

    @SerializedName("is_favorite")
    private Boolean isFavorite;

    @SerializedName("photo")
    private Photo photo;

    /**
     * String ID of the page with article preview
     */
    @SerializedName("preview_page")
    private String previewPage;

    /**
     * URL of the page with article preview
     */
    @SerializedName("preview_url")
    private URI previewUrl;

    @SerializedName("rating")
    private LinkRating rating;

    @SerializedName("target_object")
    private TargetObject targetObject;

    /**
     * Link title
     */
    @SerializedName("title")
    private String title;

    /**
     * Link URL
     */
    @SerializedName("url")
    @Required
    private String url;

    /**
     * Video from link
     */
    @SerializedName("video")
    private VideoFull video;

    public LinkApplication getApplication() {
        return application;
    }

    public LinkNoProduct setApplication(LinkApplication application) {
        this.application = application;
        return this;
    }

    public LinkButton getButton() {
        return button;
    }

    public LinkNoProduct setButton(LinkButton button) {
        this.button = button;
        return this;
    }

    public String getCaption() {
        return caption;
    }

    public LinkNoProduct setCaption(String caption) {
        this.caption = caption;
        return this;
    }

    public String getDescription() {
        return description;
    }

    public LinkNoProduct setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getId() {
        return id;
    }

    public LinkNoProduct setId(String id) {
        this.id = id;
        return this;
    }

    public Boolean getIsExternal() {
        return isExternal;
    }

    public LinkNoProduct setIsExternal(Boolean isExternal) {
        this.isExternal = isExternal;
        return this;
    }

    public Boolean getIsFavorite() {
        return isFavorite;
    }

    public LinkNoProduct setIsFavorite(Boolean isFavorite) {
        this.isFavorite = isFavorite;
        return this;
    }

    public Photo getPhoto() {
        return photo;
    }

    public LinkNoProduct setPhoto(Photo photo) {
        this.photo = photo;
        return this;
    }

    public String getPreviewPage() {
        return previewPage;
    }

    public LinkNoProduct setPreviewPage(String previewPage) {
        this.previewPage = previewPage;
        return this;
    }

    public URI getPreviewUrl() {
        return previewUrl;
    }

    public LinkNoProduct setPreviewUrl(URI previewUrl) {
        this.previewUrl = previewUrl;
        return this;
    }

    public LinkRating getRating() {
        return rating;
    }

    public LinkNoProduct setRating(LinkRating rating) {
        this.rating = rating;
        return this;
    }

    public TargetObject getTargetObject() {
        return targetObject;
    }

    public LinkNoProduct setTargetObject(TargetObject targetObject) {
        this.targetObject = targetObject;
        return this;
    }

    public String getTitle() {
        return title;
    }

    public LinkNoProduct setTitle(String title) {
        this.title = title;
        return this;
    }

    public String getUrl() {
        return url;
    }

    public LinkNoProduct setUrl(String url) {
        this.url = url;
        return this;
    }

    public VideoFull getVideo() {
        return video;
    }

    public LinkNoProduct setVideo(VideoFull video) {
        this.video = video;
        return this;
    }

    @Override
    public int hashCode() {
        return Objects.hash(targetObject, previewUrl, isExternal, rating, caption, description, photo, video, title, url, previewPage, button, application, id, isFavorite);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        LinkNoProduct linkNoProduct = (LinkNoProduct) o;
        return Objects.equals(isFavorite, linkNoProduct.isFavorite) &&
                Objects.equals(previewPage, linkNoProduct.previewPage) &&
                Objects.equals(targetObject, linkNoProduct.targetObject) &&
                Objects.equals(rating, linkNoProduct.rating) &&
                Objects.equals(caption, linkNoProduct.caption) &&
                Objects.equals(description, linkNoProduct.description) &&
                Objects.equals(isExternal, linkNoProduct.isExternal) &&
                Objects.equals(photo, linkNoProduct.photo) &&
                Objects.equals(video, linkNoProduct.video) &&
                Objects.equals(title, linkNoProduct.title) &&
                Objects.equals(url, linkNoProduct.url) &&
                Objects.equals(button, linkNoProduct.button) &&
                Objects.equals(application, linkNoProduct.application) &&
                Objects.equals(previewUrl, linkNoProduct.previewUrl) &&
                Objects.equals(id, linkNoProduct.id);
    }

    @Override
    public String toString() {
        final Gson gson = new Gson();
        return gson.toJson(this);
    }

    public String toPrettyString() {
        final StringBuilder sb = new StringBuilder("LinkNoProduct{");
        sb.append("isFavorite=").append(isFavorite);
        sb.append(", previewPage='").append(previewPage).append("'");
        sb.append(", targetObject=").append(targetObject);
        sb.append(", rating=").append(rating);
        sb.append(", caption='").append(caption).append("'");
        sb.append(", description='").append(description).append("'");
        sb.append(", isExternal=").append(isExternal);
        sb.append(", photo=").append(photo);
        sb.append(", video=").append(video);
        sb.append(", title='").append(title).append("'");
        sb.append(", url='").append(url).append("'");
        sb.append(", button=").append(button);
        sb.append(", application=").append(application);
        sb.append(", previewUrl=").append(previewUrl);
        sb.append(", id='").append(id).append("'");
        sb.append('}');
        return sb.toString();
    }
}
