// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.objects.base;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import com.vk.api.sdk.objects.Validable;
import com.vk.api.sdk.objects.annotations.Required;
import java.util.List;
import java.util.Objects;

/**
 * OwnerCover object
 */
public class OwnerCover implements Validable {
    @SerializedName("crop_params")
    private OwnerCoverCropParams cropParams;

    /**
     * Information whether cover is enabled
     */
    @SerializedName("enabled")
    @Required
    private BoolInt enabled;

    @SerializedName("images")
    private List<Image> images;

    @SerializedName("original_image")
    private Image originalImage;

    @SerializedName("photo_id")
    private Integer photoId;

    public OwnerCoverCropParams getCropParams() {
        return cropParams;
    }

    public OwnerCover setCropParams(OwnerCoverCropParams cropParams) {
        this.cropParams = cropParams;
        return this;
    }

    public boolean isEnabled() {
        return enabled == BoolInt.YES;
    }

    public BoolInt getEnabled() {
        return enabled;
    }

    public List<Image> getImages() {
        return images;
    }

    public OwnerCover setImages(List<Image> images) {
        this.images = images;
        return this;
    }

    public Image getOriginalImage() {
        return originalImage;
    }

    public OwnerCover setOriginalImage(Image originalImage) {
        this.originalImage = originalImage;
        return this;
    }

    public Integer getPhotoId() {
        return photoId;
    }

    public OwnerCover setPhotoId(Integer photoId) {
        this.photoId = photoId;
        return this;
    }

    @Override
    public int hashCode() {
        return Objects.hash(images, photoId, cropParams, originalImage, enabled);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        OwnerCover ownerCover = (OwnerCover) o;
        return Objects.equals(images, ownerCover.images) &&
                Objects.equals(photoId, ownerCover.photoId) &&
                Objects.equals(cropParams, ownerCover.cropParams) &&
                Objects.equals(originalImage, ownerCover.originalImage) &&
                Objects.equals(enabled, ownerCover.enabled);
    }

    @Override
    public String toString() {
        final Gson gson = new Gson();
        return gson.toJson(this);
    }

    public String toPrettyString() {
        final StringBuilder sb = new StringBuilder("OwnerCover{");
        sb.append("images=").append(images);
        sb.append(", photoId=").append(photoId);
        sb.append(", cropParams=").append(cropParams);
        sb.append(", originalImage=").append(originalImage);
        sb.append(", enabled=").append(enabled);
        sb.append('}');
        return sb.toString();
    }
}
