// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.objects.base;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import com.vk.api.sdk.objects.Validable;
import java.net.URI;
import java.util.List;
import java.util.Objects;

/**
 * StickersList object
 */
public class StickersList implements Validable {
    /**
     * URL of sticker animation script
     */
    @SerializedName("animation_url")
    private URI animationUrl;

    /**
     * Array of sticker animation script objects
     */
    @SerializedName("animations")
    private List<StickerAnimation> animations;

    @SerializedName("images")
    private List<Image> images;

    @SerializedName("images_with_background")
    private List<Image> imagesWithBackground;

    /**
     * Information whether the sticker is allowed
     */
    @SerializedName("is_allowed")
    private Boolean isAllowed;

    /**
     * Pack ID
     */
    @SerializedName("product_id")
    private Integer productId;

    /**
     * Sticker ID
     */
    @SerializedName("sticker_id")
    private Integer stickerId;

    public URI getAnimationUrl() {
        return animationUrl;
    }

    public StickersList setAnimationUrl(URI animationUrl) {
        this.animationUrl = animationUrl;
        return this;
    }

    public List<StickerAnimation> getAnimations() {
        return animations;
    }

    public StickersList setAnimations(List<StickerAnimation> animations) {
        this.animations = animations;
        return this;
    }

    public List<Image> getImages() {
        return images;
    }

    public StickersList setImages(List<Image> images) {
        this.images = images;
        return this;
    }

    public List<Image> getImagesWithBackground() {
        return imagesWithBackground;
    }

    public StickersList setImagesWithBackground(List<Image> imagesWithBackground) {
        this.imagesWithBackground = imagesWithBackground;
        return this;
    }

    public Boolean getIsAllowed() {
        return isAllowed;
    }

    public StickersList setIsAllowed(Boolean isAllowed) {
        this.isAllowed = isAllowed;
        return this;
    }

    public Integer getProductId() {
        return productId;
    }

    public StickersList setProductId(Integer productId) {
        this.productId = productId;
        return this;
    }

    public Integer getStickerId() {
        return stickerId;
    }

    public StickersList setStickerId(Integer stickerId) {
        this.stickerId = stickerId;
        return this;
    }

    @Override
    public int hashCode() {
        return Objects.hash(isAllowed, images, animationUrl, productId, animations, imagesWithBackground, stickerId);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        StickersList stickersList = (StickersList) o;
        return Objects.equals(animationUrl, stickersList.animationUrl) &&
                Objects.equals(images, stickersList.images) &&
                Objects.equals(stickerId, stickersList.stickerId) &&
                Objects.equals(animations, stickersList.animations) &&
                Objects.equals(productId, stickersList.productId) &&
                Objects.equals(isAllowed, stickersList.isAllowed) &&
                Objects.equals(imagesWithBackground, stickersList.imagesWithBackground);
    }

    @Override
    public String toString() {
        final Gson gson = new Gson();
        return gson.toJson(this);
    }

    public String toPrettyString() {
        final StringBuilder sb = new StringBuilder("StickersList{");
        sb.append("animationUrl=").append(animationUrl);
        sb.append(", images=").append(images);
        sb.append(", stickerId=").append(stickerId);
        sb.append(", animations=").append(animations);
        sb.append(", productId=").append(productId);
        sb.append(", isAllowed=").append(isAllowed);
        sb.append(", imagesWithBackground=").append(imagesWithBackground);
        sb.append('}');
        return sb.toString();
    }
}
