// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.objects.bugtracker;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import com.vk.api.sdk.objects.Validable;
import com.vk.api.sdk.objects.annotations.Required;
import java.util.List;
import java.util.Objects;

/**
 * Comment object
 */
public class Comment implements Validable {
    @SerializedName("attachments")
    private List<Attachment> attachments;

    @SerializedName("author_name")
    private String authorName;

    @SerializedName("author_photo")
    private String authorPhoto;

    @SerializedName("bugreport_id")
    @Required
    private Integer bugreportId;

    @SerializedName("comment_id")
    @Required
    private Integer commentId;

    @SerializedName("created")
    @Required
    private Integer created;

    @SerializedName("edit_hash")
    private String editHash;

    @SerializedName("from_id")
    private Integer fromId;

    @SerializedName("is_hidden")
    private Boolean isHidden;

    @SerializedName("is_unread")
    private Boolean isUnread;

    @SerializedName("meta_text")
    private String metaText;

    @SerializedName("remove_hash")
    private String removeHash;

    @SerializedName("text")
    @Required
    private String text;

    public List<Attachment> getAttachments() {
        return attachments;
    }

    public Comment setAttachments(List<Attachment> attachments) {
        this.attachments = attachments;
        return this;
    }

    public String getAuthorName() {
        return authorName;
    }

    public Comment setAuthorName(String authorName) {
        this.authorName = authorName;
        return this;
    }

    public String getAuthorPhoto() {
        return authorPhoto;
    }

    public Comment setAuthorPhoto(String authorPhoto) {
        this.authorPhoto = authorPhoto;
        return this;
    }

    public Integer getBugreportId() {
        return bugreportId;
    }

    public Comment setBugreportId(Integer bugreportId) {
        this.bugreportId = bugreportId;
        return this;
    }

    public Integer getCommentId() {
        return commentId;
    }

    public Comment setCommentId(Integer commentId) {
        this.commentId = commentId;
        return this;
    }

    public Integer getCreated() {
        return created;
    }

    public Comment setCreated(Integer created) {
        this.created = created;
        return this;
    }

    public String getEditHash() {
        return editHash;
    }

    public Comment setEditHash(String editHash) {
        this.editHash = editHash;
        return this;
    }

    public Integer getFromId() {
        return fromId;
    }

    public Comment setFromId(Integer fromId) {
        this.fromId = fromId;
        return this;
    }

    public Boolean getIsHidden() {
        return isHidden;
    }

    public Comment setIsHidden(Boolean isHidden) {
        this.isHidden = isHidden;
        return this;
    }

    public Boolean getIsUnread() {
        return isUnread;
    }

    public Comment setIsUnread(Boolean isUnread) {
        this.isUnread = isUnread;
        return this;
    }

    public String getMetaText() {
        return metaText;
    }

    public Comment setMetaText(String metaText) {
        this.metaText = metaText;
        return this;
    }

    public String getRemoveHash() {
        return removeHash;
    }

    public Comment setRemoveHash(String removeHash) {
        this.removeHash = removeHash;
        return this;
    }

    public String getText() {
        return text;
    }

    public Comment setText(String text) {
        this.text = text;
        return this;
    }

    @Override
    public int hashCode() {
        return Objects.hash(attachments, created, removeHash, fromId, authorPhoto, isUnread, editHash, isHidden, bugreportId, metaText, authorName, commentId, text);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Comment comment = (Comment) o;
        return Objects.equals(authorName, comment.authorName) &&
                Objects.equals(editHash, comment.editHash) &&
                Objects.equals(attachments, comment.attachments) &&
                Objects.equals(fromId, comment.fromId) &&
                Objects.equals(metaText, comment.metaText) &&
                Objects.equals(created, comment.created) &&
                Objects.equals(isHidden, comment.isHidden) &&
                Objects.equals(commentId, comment.commentId) &&
                Objects.equals(removeHash, comment.removeHash) &&
                Objects.equals(authorPhoto, comment.authorPhoto) &&
                Objects.equals(bugreportId, comment.bugreportId) &&
                Objects.equals(isUnread, comment.isUnread) &&
                Objects.equals(text, comment.text);
    }

    @Override
    public String toString() {
        final Gson gson = new Gson();
        return gson.toJson(this);
    }

    public String toPrettyString() {
        final StringBuilder sb = new StringBuilder("Comment{");
        sb.append("authorName='").append(authorName).append("'");
        sb.append(", editHash='").append(editHash).append("'");
        sb.append(", attachments=").append(attachments);
        sb.append(", fromId=").append(fromId);
        sb.append(", metaText='").append(metaText).append("'");
        sb.append(", created=").append(created);
        sb.append(", isHidden=").append(isHidden);
        sb.append(", commentId=").append(commentId);
        sb.append(", removeHash='").append(removeHash).append("'");
        sb.append(", authorPhoto='").append(authorPhoto).append("'");
        sb.append(", bugreportId=").append(bugreportId);
        sb.append(", isUnread=").append(isUnread);
        sb.append(", text='").append(text).append("'");
        sb.append('}');
        return sb.toString();
    }
}
