// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.objects.market;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import com.vk.api.sdk.objects.Validable;
import com.vk.api.sdk.objects.base.Image;
import java.util.List;
import java.util.Objects;

/**
 * Information about the group where the item is placed
 */
public class ItemOwnerInfo implements Validable {
    /**
     * Avatar of the group
     */
    @SerializedName("avatar")
    private List<Image> avatar;

    /**
     * Category of the item or description of the group
     */
    @SerializedName("category")
    private String category;

    /**
     * Link to the section of the group
     */
    @SerializedName("category_url")
    private String categoryUrl;

    /**
     * Is the group is VK corporated market
     */
    @SerializedName("is_corporated_market")
    private Boolean isCorporatedMarket;

    /**
     * Type of the market group
     */
    @SerializedName("market_type")
    private OwnerType marketType;

    /**
     * Name of the group
     */
    @SerializedName("name")
    private String name;

    public List<Image> getAvatar() {
        return avatar;
    }

    public ItemOwnerInfo setAvatar(List<Image> avatar) {
        this.avatar = avatar;
        return this;
    }

    public String getCategory() {
        return category;
    }

    public ItemOwnerInfo setCategory(String category) {
        this.category = category;
        return this;
    }

    public String getCategoryUrl() {
        return categoryUrl;
    }

    public ItemOwnerInfo setCategoryUrl(String categoryUrl) {
        this.categoryUrl = categoryUrl;
        return this;
    }

    public Boolean getIsCorporatedMarket() {
        return isCorporatedMarket;
    }

    public ItemOwnerInfo setIsCorporatedMarket(Boolean isCorporatedMarket) {
        this.isCorporatedMarket = isCorporatedMarket;
        return this;
    }

    public OwnerType getMarketType() {
        return marketType;
    }

    public ItemOwnerInfo setMarketType(OwnerType marketType) {
        this.marketType = marketType;
        return this;
    }

    public String getName() {
        return name;
    }

    public ItemOwnerInfo setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public int hashCode() {
        return Objects.hash(isCorporatedMarket, name, categoryUrl, avatar, category, marketType);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ItemOwnerInfo itemOwnerInfo = (ItemOwnerInfo) o;
        return Objects.equals(isCorporatedMarket, itemOwnerInfo.isCorporatedMarket) &&
                Objects.equals(categoryUrl, itemOwnerInfo.categoryUrl) &&
                Objects.equals(name, itemOwnerInfo.name) &&
                Objects.equals(avatar, itemOwnerInfo.avatar) &&
                Objects.equals(category, itemOwnerInfo.category) &&
                Objects.equals(marketType, itemOwnerInfo.marketType);
    }

    @Override
    public String toString() {
        final Gson gson = new Gson();
        return gson.toJson(this);
    }

    public String toPrettyString() {
        final StringBuilder sb = new StringBuilder("ItemOwnerInfo{");
        sb.append("isCorporatedMarket=").append(isCorporatedMarket);
        sb.append(", categoryUrl='").append(categoryUrl).append("'");
        sb.append(", name='").append(name).append("'");
        sb.append(", avatar=").append(avatar);
        sb.append(", category='").append(category).append("'");
        sb.append(", marketType=").append(marketType);
        sb.append('}');
        return sb.toString();
    }
}
