// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.objects.market;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import com.vk.api.sdk.objects.Validable;
import com.vk.api.sdk.objects.annotations.Required;
import java.net.URI;
import java.util.Objects;

/**
 * MarketItem object
 */
public class MarketItem implements Validable {
    /**
     * Access key for the market item
     */
    @SerializedName("access_key")
    private String accessKey;

    @SerializedName("availability")
    @Required
    private MarketItemAvailability availability;

    /**
     * Title for button for url
     */
    @SerializedName("button_title")
    private String buttonTitle;

    @SerializedName("category")
    @Required
    private MarketCategory category;

    @SerializedName("category_v2")
    private MarketCategory categoryV2;

    /**
     * Date when the item has been created in Unixtime
     */
    @SerializedName("date")
    private Integer date;

    /**
     * Item description
     */
    @SerializedName("description")
    @Required
    private String description;

    @SerializedName("external_id")
    private String externalId;

    /**
     * Item ID
     */
    @SerializedName("id")
    @Required
    private Integer id;

    @SerializedName("is_adult")
    private Boolean isAdult;

    @SerializedName("is_favorite")
    private Boolean isFavorite;

    @SerializedName("is_main_variant")
    private Boolean isMainVariant;

    @SerializedName("is_owner")
    private Boolean isOwner;

    /**
     * Item owner's ID
     * Entity: owner
     */
    @SerializedName("owner_id")
    @Required
    private Long ownerId;

    /**
     * Attach for post id
     */
    @SerializedName("post_id")
    private Integer postId;

    /**
     * Attach for post owner id
     * Entity: owner
     */
    @SerializedName("post_owner_id")
    private Long postOwnerId;

    @SerializedName("price")
    @Required
    private Price price;

    @SerializedName("sku")
    private String sku;

    /**
     * Inventory balances
     */
    @SerializedName("stock_amount")
    private Integer stockAmount;

    /**
     * URL of the preview image
     */
    @SerializedName("thumb_photo")
    private URI thumbPhoto;

    /**
     * Item title
     */
    @SerializedName("title")
    @Required
    private String title;

    /**
     * URL to item
     */
    @SerializedName("url")
    private String url;

    @SerializedName("variants_grouping_id")
    private Integer variantsGroupingId;

    public String getAccessKey() {
        return accessKey;
    }

    public MarketItem setAccessKey(String accessKey) {
        this.accessKey = accessKey;
        return this;
    }

    public MarketItemAvailability getAvailability() {
        return availability;
    }

    public MarketItem setAvailability(MarketItemAvailability availability) {
        this.availability = availability;
        return this;
    }

    public String getButtonTitle() {
        return buttonTitle;
    }

    public MarketItem setButtonTitle(String buttonTitle) {
        this.buttonTitle = buttonTitle;
        return this;
    }

    public MarketCategory getCategory() {
        return category;
    }

    public MarketItem setCategory(MarketCategory category) {
        this.category = category;
        return this;
    }

    public MarketCategory getCategoryV2() {
        return categoryV2;
    }

    public MarketItem setCategoryV2(MarketCategory categoryV2) {
        this.categoryV2 = categoryV2;
        return this;
    }

    public Integer getDate() {
        return date;
    }

    public MarketItem setDate(Integer date) {
        this.date = date;
        return this;
    }

    public String getDescription() {
        return description;
    }

    public MarketItem setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getExternalId() {
        return externalId;
    }

    public MarketItem setExternalId(String externalId) {
        this.externalId = externalId;
        return this;
    }

    public Integer getId() {
        return id;
    }

    public MarketItem setId(Integer id) {
        this.id = id;
        return this;
    }

    public Boolean getIsAdult() {
        return isAdult;
    }

    public MarketItem setIsAdult(Boolean isAdult) {
        this.isAdult = isAdult;
        return this;
    }

    public Boolean getIsFavorite() {
        return isFavorite;
    }

    public MarketItem setIsFavorite(Boolean isFavorite) {
        this.isFavorite = isFavorite;
        return this;
    }

    public Boolean getIsMainVariant() {
        return isMainVariant;
    }

    public MarketItem setIsMainVariant(Boolean isMainVariant) {
        this.isMainVariant = isMainVariant;
        return this;
    }

    public Boolean getIsOwner() {
        return isOwner;
    }

    public MarketItem setIsOwner(Boolean isOwner) {
        this.isOwner = isOwner;
        return this;
    }

    public Long getOwnerId() {
        return ownerId;
    }

    public MarketItem setOwnerId(Long ownerId) {
        this.ownerId = ownerId;
        return this;
    }

    public Integer getPostId() {
        return postId;
    }

    public MarketItem setPostId(Integer postId) {
        this.postId = postId;
        return this;
    }

    public Long getPostOwnerId() {
        return postOwnerId;
    }

    public MarketItem setPostOwnerId(Long postOwnerId) {
        this.postOwnerId = postOwnerId;
        return this;
    }

    public Price getPrice() {
        return price;
    }

    public MarketItem setPrice(Price price) {
        this.price = price;
        return this;
    }

    public String getSku() {
        return sku;
    }

    public MarketItem setSku(String sku) {
        this.sku = sku;
        return this;
    }

    public Integer getStockAmount() {
        return stockAmount;
    }

    public MarketItem setStockAmount(Integer stockAmount) {
        this.stockAmount = stockAmount;
        return this;
    }

    public URI getThumbPhoto() {
        return thumbPhoto;
    }

    public MarketItem setThumbPhoto(URI thumbPhoto) {
        this.thumbPhoto = thumbPhoto;
        return this;
    }

    public String getTitle() {
        return title;
    }

    public MarketItem setTitle(String title) {
        this.title = title;
        return this;
    }

    public String getUrl() {
        return url;
    }

    public MarketItem setUrl(String url) {
        this.url = url;
        return this;
    }

    public Integer getVariantsGroupingId() {
        return variantsGroupingId;
    }

    public MarketItem setVariantsGroupingId(Integer variantsGroupingId) {
        this.variantsGroupingId = variantsGroupingId;
        return this;
    }

    @Override
    public int hashCode() {
        return Objects.hash(date, variantsGroupingId, thumbPhoto, buttonTitle, postOwnerId, description, externalId, availability, postId, ownerId, title, url, stockAmount, isMainVariant, isOwner, accessKey, price, id, category, sku, categoryV2, isAdult, isFavorite);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        MarketItem marketItem = (MarketItem) o;
        return Objects.equals(date, marketItem.date) &&
                Objects.equals(isFavorite, marketItem.isFavorite) &&
                Objects.equals(stockAmount, marketItem.stockAmount) &&
                Objects.equals(postOwnerId, marketItem.postOwnerId) &&
                Objects.equals(isOwner, marketItem.isOwner) &&
                Objects.equals(ownerId, marketItem.ownerId) &&
                Objects.equals(description, marketItem.description) &&
                Objects.equals(externalId, marketItem.externalId) &&
                Objects.equals(isMainVariant, marketItem.isMainVariant) &&
                Objects.equals(availability, marketItem.availability) &&
                Objects.equals(title, marketItem.title) &&
                Objects.equals(url, marketItem.url) &&
                Objects.equals(isAdult, marketItem.isAdult) &&
                Objects.equals(thumbPhoto, marketItem.thumbPhoto) &&
                Objects.equals(postId, marketItem.postId) &&
                Objects.equals(variantsGroupingId, marketItem.variantsGroupingId) &&
                Objects.equals(categoryV2, marketItem.categoryV2) &&
                Objects.equals(price, marketItem.price) &&
                Objects.equals(accessKey, marketItem.accessKey) &&
                Objects.equals(buttonTitle, marketItem.buttonTitle) &&
                Objects.equals(id, marketItem.id) &&
                Objects.equals(category, marketItem.category) &&
                Objects.equals(sku, marketItem.sku);
    }

    @Override
    public String toString() {
        final Gson gson = new Gson();
        return gson.toJson(this);
    }

    public String toPrettyString() {
        final StringBuilder sb = new StringBuilder("MarketItem{");
        sb.append("date=").append(date);
        sb.append(", isFavorite=").append(isFavorite);
        sb.append(", stockAmount=").append(stockAmount);
        sb.append(", postOwnerId=").append(postOwnerId);
        sb.append(", isOwner=").append(isOwner);
        sb.append(", ownerId=").append(ownerId);
        sb.append(", description='").append(description).append("'");
        sb.append(", externalId='").append(externalId).append("'");
        sb.append(", isMainVariant=").append(isMainVariant);
        sb.append(", availability=").append(availability);
        sb.append(", title='").append(title).append("'");
        sb.append(", url='").append(url).append("'");
        sb.append(", isAdult=").append(isAdult);
        sb.append(", thumbPhoto=").append(thumbPhoto);
        sb.append(", postId=").append(postId);
        sb.append(", variantsGroupingId=").append(variantsGroupingId);
        sb.append(", categoryV2=").append(categoryV2);
        sb.append(", price=").append(price);
        sb.append(", accessKey='").append(accessKey).append("'");
        sb.append(", buttonTitle='").append(buttonTitle).append("'");
        sb.append(", id=").append(id);
        sb.append(", category=").append(category);
        sb.append(", sku='").append(sku).append("'");
        sb.append('}');
        return sb.toString();
    }
}
