// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.objects.market;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import com.vk.api.sdk.objects.Validable;
import com.vk.api.sdk.objects.annotations.Required;
import java.net.URI;
import java.util.Objects;

/**
 * MarketItemBasic object
 */
public class MarketItemBasic implements Validable {
    /**
     * Item ID
     */
    @SerializedName("id")
    @Required
    private Integer id;

    @SerializedName("is_favorite")
    private Boolean isFavorite;

    /**
     * Item owner's ID
     * Entity: owner
     */
    @SerializedName("owner_id")
    @Required
    private Long ownerId;

    @SerializedName("price")
    @Required
    private Price price;

    /**
     * URL of the preview image
     */
    @SerializedName("thumb_photo")
    private URI thumbPhoto;

    /**
     * Item title
     */
    @SerializedName("title")
    @Required
    private String title;

    public Integer getId() {
        return id;
    }

    public MarketItemBasic setId(Integer id) {
        this.id = id;
        return this;
    }

    public Boolean getIsFavorite() {
        return isFavorite;
    }

    public MarketItemBasic setIsFavorite(Boolean isFavorite) {
        this.isFavorite = isFavorite;
        return this;
    }

    public Long getOwnerId() {
        return ownerId;
    }

    public MarketItemBasic setOwnerId(Long ownerId) {
        this.ownerId = ownerId;
        return this;
    }

    public Price getPrice() {
        return price;
    }

    public MarketItemBasic setPrice(Price price) {
        this.price = price;
        return this;
    }

    public URI getThumbPhoto() {
        return thumbPhoto;
    }

    public MarketItemBasic setThumbPhoto(URI thumbPhoto) {
        this.thumbPhoto = thumbPhoto;
        return this;
    }

    public String getTitle() {
        return title;
    }

    public MarketItemBasic setTitle(String title) {
        this.title = title;
        return this;
    }

    @Override
    public int hashCode() {
        return Objects.hash(thumbPhoto, price, id, ownerId, title, isFavorite);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        MarketItemBasic marketItemBasic = (MarketItemBasic) o;
        return Objects.equals(thumbPhoto, marketItemBasic.thumbPhoto) &&
                Objects.equals(isFavorite, marketItemBasic.isFavorite) &&
                Objects.equals(ownerId, marketItemBasic.ownerId) &&
                Objects.equals(price, marketItemBasic.price) &&
                Objects.equals(id, marketItemBasic.id) &&
                Objects.equals(title, marketItemBasic.title);
    }

    @Override
    public String toString() {
        final Gson gson = new Gson();
        return gson.toJson(this);
    }

    public String toPrettyString() {
        final StringBuilder sb = new StringBuilder("MarketItemBasic{");
        sb.append("thumbPhoto=").append(thumbPhoto);
        sb.append(", isFavorite=").append(isFavorite);
        sb.append(", ownerId=").append(ownerId);
        sb.append(", price=").append(price);
        sb.append(", id=").append(id);
        sb.append(", title='").append(title).append("'");
        sb.append('}');
        return sb.toString();
    }
}
