// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.objects.market;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import com.vk.api.sdk.objects.Validable;
import com.vk.api.sdk.objects.base.BoolInt;
import com.vk.api.sdk.objects.base.Likes;
import com.vk.api.sdk.objects.base.Link;
import com.vk.api.sdk.objects.base.RepostsInfo;
import com.vk.api.sdk.objects.photos.Photo;
import java.util.List;
import java.util.Objects;

/**
 * MarketItemFull object
 */
public class MarketItemFull extends MarketItem implements Validable {
    /**
     * Contains ad ID if it has
     */
    @SerializedName("ad_id")
    private Integer adId;

    @SerializedName("albums_ids")
    private List<Integer> albumsIds;

    /**
     * Information whether current use can comment the item
     */
    @SerializedName("can_comment")
    private BoolInt canComment;

    /**
     * Can item be deleted by current user?
     */
    @SerializedName("can_delete")
    private Boolean canDelete;

    /**
     * Can the item be updated by current user?
     */
    @SerializedName("can_edit")
    private Boolean canEdit;

    /**
     * Information whether current use can repost the item
     */
    @SerializedName("can_repost")
    private BoolInt canRepost;

    /**
     * Can the item be converted from a product into a service?
     */
    @SerializedName("can_show_convert_to_service")
    private Boolean canShowConvertToService;

    /**
     * Information for cancel and revert order
     */
    @SerializedName("cancel_info")
    private Link cancelInfo;

    @SerializedName("likes")
    private Likes likes;

    /**
     * Count of product orders
     */
    @SerializedName("orders_count")
    private Integer ordersCount;

    /**
     * Information about the group where the item is placed
     */
    @SerializedName("owner_info")
    private ItemOwnerInfo ownerInfo;

    @SerializedName("photos")
    private List<Photo> photos;

    /**
     * Information about promotion of the item
     */
    @SerializedName("promotion")
    private ItemPromotionInfo promotion;

    /**
     * Rating of product
     */
    @SerializedName("rating")
    private Number rating;

    @SerializedName("reposts")
    private RepostsInfo reposts;

    /**
     * User agreement info
     */
    @SerializedName("user_agreement_info")
    private String userAgreementInfo;

    /**
     * Views number
     */
    @SerializedName("views_count")
    private Integer viewsCount;

    /**
     * The amount of the discount if VK Pay is used for payment
     */
    @SerializedName("vk_pay_discount")
    private Integer vkPayDiscount;

    /**
     * Object identifier in wishlist of viewer
     */
    @SerializedName("wishlist_item_id")
    private Integer wishlistItemId;

    public Integer getAdId() {
        return adId;
    }

    public MarketItemFull setAdId(Integer adId) {
        this.adId = adId;
        return this;
    }

    public List<Integer> getAlbumsIds() {
        return albumsIds;
    }

    public MarketItemFull setAlbumsIds(List<Integer> albumsIds) {
        this.albumsIds = albumsIds;
        return this;
    }

    public boolean canComment() {
        return canComment == BoolInt.YES;
    }

    public BoolInt getCanComment() {
        return canComment;
    }

    public Boolean getCanDelete() {
        return canDelete;
    }

    public MarketItemFull setCanDelete(Boolean canDelete) {
        this.canDelete = canDelete;
        return this;
    }

    public Boolean getCanEdit() {
        return canEdit;
    }

    public MarketItemFull setCanEdit(Boolean canEdit) {
        this.canEdit = canEdit;
        return this;
    }

    public boolean canRepost() {
        return canRepost == BoolInt.YES;
    }

    public BoolInt getCanRepost() {
        return canRepost;
    }

    public Boolean getCanShowConvertToService() {
        return canShowConvertToService;
    }

    public MarketItemFull setCanShowConvertToService(Boolean canShowConvertToService) {
        this.canShowConvertToService = canShowConvertToService;
        return this;
    }

    public Link getCancelInfo() {
        return cancelInfo;
    }

    public MarketItemFull setCancelInfo(Link cancelInfo) {
        this.cancelInfo = cancelInfo;
        return this;
    }

    public Likes getLikes() {
        return likes;
    }

    public MarketItemFull setLikes(Likes likes) {
        this.likes = likes;
        return this;
    }

    public Integer getOrdersCount() {
        return ordersCount;
    }

    public MarketItemFull setOrdersCount(Integer ordersCount) {
        this.ordersCount = ordersCount;
        return this;
    }

    public ItemOwnerInfo getOwnerInfo() {
        return ownerInfo;
    }

    public MarketItemFull setOwnerInfo(ItemOwnerInfo ownerInfo) {
        this.ownerInfo = ownerInfo;
        return this;
    }

    public List<Photo> getPhotos() {
        return photos;
    }

    public MarketItemFull setPhotos(List<Photo> photos) {
        this.photos = photos;
        return this;
    }

    public ItemPromotionInfo getPromotion() {
        return promotion;
    }

    public MarketItemFull setPromotion(ItemPromotionInfo promotion) {
        this.promotion = promotion;
        return this;
    }

    public Number getRating() {
        return rating;
    }

    public MarketItemFull setRating(Number rating) {
        this.rating = rating;
        return this;
    }

    public RepostsInfo getReposts() {
        return reposts;
    }

    public MarketItemFull setReposts(RepostsInfo reposts) {
        this.reposts = reposts;
        return this;
    }

    public String getUserAgreementInfo() {
        return userAgreementInfo;
    }

    public MarketItemFull setUserAgreementInfo(String userAgreementInfo) {
        this.userAgreementInfo = userAgreementInfo;
        return this;
    }

    public Integer getViewsCount() {
        return viewsCount;
    }

    public MarketItemFull setViewsCount(Integer viewsCount) {
        this.viewsCount = viewsCount;
        return this;
    }

    public Integer getVkPayDiscount() {
        return vkPayDiscount;
    }

    public MarketItemFull setVkPayDiscount(Integer vkPayDiscount) {
        this.vkPayDiscount = vkPayDiscount;
        return this;
    }

    public Integer getWishlistItemId() {
        return wishlistItemId;
    }

    public MarketItemFull setWishlistItemId(Integer wishlistItemId) {
        this.wishlistItemId = wishlistItemId;
        return this;
    }

    @Override
    public int hashCode() {
        return Objects.hash(canRepost, wishlistItemId, cancelInfo, canEdit, rating, viewsCount, ownerInfo, photos, userAgreementInfo, canShowConvertToService, ordersCount, adId, vkPayDiscount, albumsIds, canDelete, canComment, reposts, likes, promotion);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        MarketItemFull marketItemFull = (MarketItemFull) o;
        return Objects.equals(ownerInfo, marketItemFull.ownerInfo) &&
                Objects.equals(rating, marketItemFull.rating) &&
                Objects.equals(canEdit, marketItemFull.canEdit) &&
                Objects.equals(photos, marketItemFull.photos) &&
                Objects.equals(canRepost, marketItemFull.canRepost) &&
                Objects.equals(ordersCount, marketItemFull.ordersCount) &&
                Objects.equals(adId, marketItemFull.adId) &&
                Objects.equals(canComment, marketItemFull.canComment) &&
                Objects.equals(userAgreementInfo, marketItemFull.userAgreementInfo) &&
                Objects.equals(canDelete, marketItemFull.canDelete) &&
                Objects.equals(wishlistItemId, marketItemFull.wishlistItemId) &&
                Objects.equals(canShowConvertToService, marketItemFull.canShowConvertToService) &&
                Objects.equals(viewsCount, marketItemFull.viewsCount) &&
                Objects.equals(vkPayDiscount, marketItemFull.vkPayDiscount) &&
                Objects.equals(albumsIds, marketItemFull.albumsIds) &&
                Objects.equals(cancelInfo, marketItemFull.cancelInfo) &&
                Objects.equals(reposts, marketItemFull.reposts) &&
                Objects.equals(likes, marketItemFull.likes) &&
                Objects.equals(promotion, marketItemFull.promotion);
    }

    @Override
    public String toString() {
        final Gson gson = new Gson();
        return gson.toJson(this);
    }

    public String toPrettyString() {
        final StringBuilder sb = new StringBuilder("MarketItemFull{");
        sb.append("ownerInfo=").append(ownerInfo);
        sb.append(", rating=").append(rating);
        sb.append(", canEdit=").append(canEdit);
        sb.append(", photos=").append(photos);
        sb.append(", canRepost=").append(canRepost);
        sb.append(", ordersCount=").append(ordersCount);
        sb.append(", adId=").append(adId);
        sb.append(", canComment=").append(canComment);
        sb.append(", userAgreementInfo='").append(userAgreementInfo).append("'");
        sb.append(", canDelete=").append(canDelete);
        sb.append(", wishlistItemId=").append(wishlistItemId);
        sb.append(", canShowConvertToService=").append(canShowConvertToService);
        sb.append(", viewsCount=").append(viewsCount);
        sb.append(", vkPayDiscount=").append(vkPayDiscount);
        sb.append(", albumsIds=").append(albumsIds);
        sb.append(", cancelInfo=").append(cancelInfo);
        sb.append(", reposts=").append(reposts);
        sb.append(", likes=").append(likes);
        sb.append(", promotion=").append(promotion);
        sb.append('}');
        return sb.toString();
    }
}
