// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.objects.market;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import com.vk.api.sdk.objects.Validable;
import com.vk.api.sdk.objects.annotations.Required;
import com.vk.api.sdk.objects.photos.Photo;
import java.util.List;
import java.util.Objects;

/**
 * OrderItem object
 */
public class OrderItem implements Validable {
    /**
     * Extended field. Can current viewer add review for this ordered item
     */
    @SerializedName("can_add_review")
    private Boolean canAddReview;

    @SerializedName("item")
    @Required
    private MarketItem item;

    @SerializedName("item_id")
    @Required
    private Integer itemId;

    /**
     * Entity: owner
     */
    @SerializedName("owner_id")
    @Required
    private Long ownerId;

    @SerializedName("photo")
    private Photo photo;

    @SerializedName("price")
    @Required
    private Price price;

    @SerializedName("quantity")
    @Required
    private Integer quantity;

    @SerializedName("title")
    private String title;

    @SerializedName("variants")
    private List<String> variants;

    public Boolean getCanAddReview() {
        return canAddReview;
    }

    public OrderItem setCanAddReview(Boolean canAddReview) {
        this.canAddReview = canAddReview;
        return this;
    }

    public MarketItem getItem() {
        return item;
    }

    public OrderItem setItem(MarketItem item) {
        this.item = item;
        return this;
    }

    public Integer getItemId() {
        return itemId;
    }

    public OrderItem setItemId(Integer itemId) {
        this.itemId = itemId;
        return this;
    }

    public Long getOwnerId() {
        return ownerId;
    }

    public OrderItem setOwnerId(Long ownerId) {
        this.ownerId = ownerId;
        return this;
    }

    public Photo getPhoto() {
        return photo;
    }

    public OrderItem setPhoto(Photo photo) {
        this.photo = photo;
        return this;
    }

    public Price getPrice() {
        return price;
    }

    public OrderItem setPrice(Price price) {
        this.price = price;
        return this;
    }

    public Integer getQuantity() {
        return quantity;
    }

    public OrderItem setQuantity(Integer quantity) {
        this.quantity = quantity;
        return this;
    }

    public String getTitle() {
        return title;
    }

    public OrderItem setTitle(String title) {
        this.title = title;
        return this;
    }

    public List<String> getVariants() {
        return variants;
    }

    public OrderItem setVariants(List<String> variants) {
        this.variants = variants;
        return this;
    }

    @Override
    public int hashCode() {
        return Objects.hash(itemId, item, quantity, price, photo, canAddReview, variants, ownerId, title);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        OrderItem orderItem = (OrderItem) o;
        return Objects.equals(item, orderItem.item) &&
                Objects.equals(quantity, orderItem.quantity) &&
                Objects.equals(canAddReview, orderItem.canAddReview) &&
                Objects.equals(itemId, orderItem.itemId) &&
                Objects.equals(ownerId, orderItem.ownerId) &&
                Objects.equals(price, orderItem.price) &&
                Objects.equals(photo, orderItem.photo) &&
                Objects.equals(variants, orderItem.variants) &&
                Objects.equals(title, orderItem.title);
    }

    @Override
    public String toString() {
        final Gson gson = new Gson();
        return gson.toJson(this);
    }

    public String toPrettyString() {
        final StringBuilder sb = new StringBuilder("OrderItem{");
        sb.append("item=").append(item);
        sb.append(", quantity=").append(quantity);
        sb.append(", canAddReview=").append(canAddReview);
        sb.append(", itemId=").append(itemId);
        sb.append(", ownerId=").append(ownerId);
        sb.append(", price=").append(price);
        sb.append(", photo=").append(photo);
        sb.append(", variants='").append(variants).append("'");
        sb.append(", title='").append(title).append("'");
        sb.append('}');
        return sb.toString();
    }
}
