// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.objects.market;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import com.vk.api.sdk.objects.Validable;
import com.vk.api.sdk.objects.annotations.Required;
import java.util.Objects;

/**
 * Price object
 */
public class Price implements Validable {
    /**
     * Amount
     */
    @SerializedName("amount")
    @Required
    private String amount;

    /**
     * Amount to for price_type=2
     */
    @SerializedName("amount_to")
    private String amountTo;

    @SerializedName("currency")
    @Required
    private Currency currency;

    @SerializedName("discount_rate")
    private Integer discountRate;

    @SerializedName("old_amount")
    private String oldAmount;

    /**
     * Textual representation of old price
     */
    @SerializedName("old_amount_text")
    private String oldAmountText;

    @SerializedName("price_type")
    private PricePriceType priceType;

    @SerializedName("price_unit")
    private PricePriceUnit priceUnit;

    /**
     * Text
     */
    @SerializedName("text")
    @Required
    private String text;

    public String getAmount() {
        return amount;
    }

    public Price setAmount(String amount) {
        this.amount = amount;
        return this;
    }

    public String getAmountTo() {
        return amountTo;
    }

    public Price setAmountTo(String amountTo) {
        this.amountTo = amountTo;
        return this;
    }

    public Currency getCurrency() {
        return currency;
    }

    public Price setCurrency(Currency currency) {
        this.currency = currency;
        return this;
    }

    public Integer getDiscountRate() {
        return discountRate;
    }

    public Price setDiscountRate(Integer discountRate) {
        this.discountRate = discountRate;
        return this;
    }

    public String getOldAmount() {
        return oldAmount;
    }

    public Price setOldAmount(String oldAmount) {
        this.oldAmount = oldAmount;
        return this;
    }

    public String getOldAmountText() {
        return oldAmountText;
    }

    public Price setOldAmountText(String oldAmountText) {
        this.oldAmountText = oldAmountText;
        return this;
    }

    public PricePriceType getPriceType() {
        return priceType;
    }

    public Price setPriceType(PricePriceType priceType) {
        this.priceType = priceType;
        return this;
    }

    public PricePriceUnit getPriceUnit() {
        return priceUnit;
    }

    public Price setPriceUnit(PricePriceUnit priceUnit) {
        this.priceUnit = priceUnit;
        return this;
    }

    public String getText() {
        return text;
    }

    public Price setText(String text) {
        this.text = text;
        return this;
    }

    @Override
    public int hashCode() {
        return Objects.hash(priceUnit, discountRate, amount, amountTo, oldAmount, oldAmountText, priceType, currency, text);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Price price = (Price) o;
        return Objects.equals(priceUnit, price.priceUnit) &&
                Objects.equals(amount, price.amount) &&
                Objects.equals(oldAmount, price.oldAmount) &&
                Objects.equals(priceType, price.priceType) &&
                Objects.equals(currency, price.currency) &&
                Objects.equals(text, price.text) &&
                Objects.equals(discountRate, price.discountRate) &&
                Objects.equals(oldAmountText, price.oldAmountText) &&
                Objects.equals(amountTo, price.amountTo);
    }

    @Override
    public String toString() {
        final Gson gson = new Gson();
        return gson.toJson(this);
    }

    public String toPrettyString() {
        final StringBuilder sb = new StringBuilder("Price{");
        sb.append("priceUnit=").append(priceUnit);
        sb.append(", amount='").append(amount).append("'");
        sb.append(", oldAmount='").append(oldAmount).append("'");
        sb.append(", priceType=").append(priceType);
        sb.append(", currency=").append(currency);
        sb.append(", text='").append(text).append("'");
        sb.append(", discountRate=").append(discountRate);
        sb.append(", oldAmountText='").append(oldAmountText).append("'");
        sb.append(", amountTo='").append(amountTo).append("'");
        sb.append('}');
        return sb.toString();
    }
}
