// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.objects.messages;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import com.vk.api.sdk.objects.Validable;
import com.vk.api.sdk.objects.annotations.Required;
import java.util.List;
import java.util.Objects;

/**
 * Conversation object
 */
public class Conversation implements Validable {
    @SerializedName("can_write")
    private ConversationCanWrite canWrite;

    @SerializedName("chat_settings")
    private ChatSettings chatSettings;

    @SerializedName("current_keyboard")
    private Keyboard currentKeyboard;

    @SerializedName("important")
    private Boolean important;

    /**
     * Last message user have read
     */
    @SerializedName("in_read")
    @Required
    private Integer inRead;

    /**
     * Is this conversation uread
     */
    @SerializedName("is_marked_unread")
    private Boolean isMarkedUnread;

    /**
     * Conversation message ID of the last message in conversation
     */
    @SerializedName("last_conversation_message_id")
    private Integer lastConversationMessageId;

    /**
     * ID of the last message in conversation
     */
    @SerializedName("last_message_id")
    @Required
    private Integer lastMessageId;

    /**
     * Ids of messages with mentions
     */
    @SerializedName("mentions")
    private List<Integer> mentions;

    @SerializedName("message_request_data")
    private MessageRequestData messageRequestData;

    /**
     * Last outcoming message have been read by the opponent
     */
    @SerializedName("out_read")
    @Required
    private Integer outRead;

    @SerializedName("out_read_by")
    private OutReadBy outReadBy;

    @SerializedName("peer")
    @Required
    private ConversationPeer peer;

    @SerializedName("push_settings")
    private PushSettings pushSettings;

    @SerializedName("sort_id")
    private ConversationSortId sortId;

    @SerializedName("special_service_type")
    private ConversationSpecialServiceType specialServiceType;

    @SerializedName("unanswered")
    private Boolean unanswered;

    /**
     * Unread messages number
     */
    @SerializedName("unread_count")
    private Integer unreadCount;

    public ConversationCanWrite getCanWrite() {
        return canWrite;
    }

    public Conversation setCanWrite(ConversationCanWrite canWrite) {
        this.canWrite = canWrite;
        return this;
    }

    public ChatSettings getChatSettings() {
        return chatSettings;
    }

    public Conversation setChatSettings(ChatSettings chatSettings) {
        this.chatSettings = chatSettings;
        return this;
    }

    public Keyboard getCurrentKeyboard() {
        return currentKeyboard;
    }

    public Conversation setCurrentKeyboard(Keyboard currentKeyboard) {
        this.currentKeyboard = currentKeyboard;
        return this;
    }

    public Boolean getImportant() {
        return important;
    }

    public Conversation setImportant(Boolean important) {
        this.important = important;
        return this;
    }

    public Integer getInRead() {
        return inRead;
    }

    public Conversation setInRead(Integer inRead) {
        this.inRead = inRead;
        return this;
    }

    public Boolean getIsMarkedUnread() {
        return isMarkedUnread;
    }

    public Conversation setIsMarkedUnread(Boolean isMarkedUnread) {
        this.isMarkedUnread = isMarkedUnread;
        return this;
    }

    public Integer getLastConversationMessageId() {
        return lastConversationMessageId;
    }

    public Conversation setLastConversationMessageId(Integer lastConversationMessageId) {
        this.lastConversationMessageId = lastConversationMessageId;
        return this;
    }

    public Integer getLastMessageId() {
        return lastMessageId;
    }

    public Conversation setLastMessageId(Integer lastMessageId) {
        this.lastMessageId = lastMessageId;
        return this;
    }

    public List<Integer> getMentions() {
        return mentions;
    }

    public Conversation setMentions(List<Integer> mentions) {
        this.mentions = mentions;
        return this;
    }

    public MessageRequestData getMessageRequestData() {
        return messageRequestData;
    }

    public Conversation setMessageRequestData(MessageRequestData messageRequestData) {
        this.messageRequestData = messageRequestData;
        return this;
    }

    public Integer getOutRead() {
        return outRead;
    }

    public Conversation setOutRead(Integer outRead) {
        this.outRead = outRead;
        return this;
    }

    public OutReadBy getOutReadBy() {
        return outReadBy;
    }

    public Conversation setOutReadBy(OutReadBy outReadBy) {
        this.outReadBy = outReadBy;
        return this;
    }

    public ConversationPeer getPeer() {
        return peer;
    }

    public Conversation setPeer(ConversationPeer peer) {
        this.peer = peer;
        return this;
    }

    public PushSettings getPushSettings() {
        return pushSettings;
    }

    public Conversation setPushSettings(PushSettings pushSettings) {
        this.pushSettings = pushSettings;
        return this;
    }

    public ConversationSortId getSortId() {
        return sortId;
    }

    public Conversation setSortId(ConversationSortId sortId) {
        this.sortId = sortId;
        return this;
    }

    public ConversationSpecialServiceType getSpecialServiceType() {
        return specialServiceType;
    }

    public Conversation setSpecialServiceType(ConversationSpecialServiceType specialServiceType) {
        this.specialServiceType = specialServiceType;
        return this;
    }

    public Boolean getUnanswered() {
        return unanswered;
    }

    public Conversation setUnanswered(Boolean unanswered) {
        this.unanswered = unanswered;
        return this;
    }

    public Integer getUnreadCount() {
        return unreadCount;
    }

    public Conversation setUnreadCount(Integer unreadCount) {
        this.unreadCount = unreadCount;
        return this;
    }

    @Override
    public int hashCode() {
        return Objects.hash(outRead, unanswered, unreadCount, outReadBy, canWrite, isMarkedUnread, lastConversationMessageId, messageRequestData, important, chatSettings, sortId, peer, mentions, currentKeyboard, inRead, lastMessageId, pushSettings, specialServiceType);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Conversation conversation = (Conversation) o;
        return Objects.equals(inRead, conversation.inRead) &&
                Objects.equals(canWrite, conversation.canWrite) &&
                Objects.equals(chatSettings, conversation.chatSettings) &&
                Objects.equals(unanswered, conversation.unanswered) &&
                Objects.equals(isMarkedUnread, conversation.isMarkedUnread) &&
                Objects.equals(sortId, conversation.sortId) &&
                Objects.equals(important, conversation.important) &&
                Objects.equals(lastMessageId, conversation.lastMessageId) &&
                Objects.equals(specialServiceType, conversation.specialServiceType) &&
                Objects.equals(unreadCount, conversation.unreadCount) &&
                Objects.equals(pushSettings, conversation.pushSettings) &&
                Objects.equals(peer, conversation.peer) &&
                Objects.equals(currentKeyboard, conversation.currentKeyboard) &&
                Objects.equals(mentions, conversation.mentions) &&
                Objects.equals(messageRequestData, conversation.messageRequestData) &&
                Objects.equals(outRead, conversation.outRead) &&
                Objects.equals(lastConversationMessageId, conversation.lastConversationMessageId) &&
                Objects.equals(outReadBy, conversation.outReadBy);
    }

    @Override
    public String toString() {
        final Gson gson = new Gson();
        return gson.toJson(this);
    }

    public String toPrettyString() {
        final StringBuilder sb = new StringBuilder("Conversation{");
        sb.append("inRead=").append(inRead);
        sb.append(", canWrite=").append(canWrite);
        sb.append(", chatSettings=").append(chatSettings);
        sb.append(", unanswered=").append(unanswered);
        sb.append(", isMarkedUnread=").append(isMarkedUnread);
        sb.append(", sortId=").append(sortId);
        sb.append(", important=").append(important);
        sb.append(", lastMessageId=").append(lastMessageId);
        sb.append(", specialServiceType='").append(specialServiceType).append("'");
        sb.append(", unreadCount=").append(unreadCount);
        sb.append(", pushSettings=").append(pushSettings);
        sb.append(", peer=").append(peer);
        sb.append(", currentKeyboard=").append(currentKeyboard);
        sb.append(", mentions=").append(mentions);
        sb.append(", messageRequestData=").append(messageRequestData);
        sb.append(", outRead=").append(outRead);
        sb.append(", lastConversationMessageId=").append(lastConversationMessageId);
        sb.append(", outReadBy=").append(outReadBy);
        sb.append('}');
        return sb.toString();
    }
}
