// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.objects.messages;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import com.vk.api.sdk.objects.Validable;
import com.vk.api.sdk.objects.annotations.Required;
import java.util.Objects;

/**
 * HistoryAttachment object
 */
public class HistoryAttachment implements Validable {
    @SerializedName("attachment")
    @Required
    private HistoryMessageAttachment attachment;

    /**
     * Conversation Message ID
     */
    @SerializedName("cmid")
    private Integer cmid;

    /**
     * Message sending time
     */
    @SerializedName("date")
    @Required
    private Integer date;

    /**
     * Forward level (optional)
     */
    @SerializedName("forward_level")
    private Integer forwardLevel;

    /**
     * Message author's ID
     * Entity: owner
     */
    @SerializedName("from_id")
    @Required
    private Long fromId;

    /**
     * Message Exipire ttl
     */
    @SerializedName("message_expire_ttl")
    private Integer messageExpireTtl;

    /**
     * Message ID
     */
    @SerializedName("message_id")
    @Required
    private Integer messageId;

    /**
     * Attachment position in the Message
     */
    @SerializedName("position")
    private Integer position;

    @SerializedName("was_listened")
    private Boolean wasListened;

    public HistoryMessageAttachment getAttachment() {
        return attachment;
    }

    public HistoryAttachment setAttachment(HistoryMessageAttachment attachment) {
        this.attachment = attachment;
        return this;
    }

    public Integer getCmid() {
        return cmid;
    }

    public HistoryAttachment setCmid(Integer cmid) {
        this.cmid = cmid;
        return this;
    }

    public Integer getDate() {
        return date;
    }

    public HistoryAttachment setDate(Integer date) {
        this.date = date;
        return this;
    }

    public Integer getForwardLevel() {
        return forwardLevel;
    }

    public HistoryAttachment setForwardLevel(Integer forwardLevel) {
        this.forwardLevel = forwardLevel;
        return this;
    }

    public Long getFromId() {
        return fromId;
    }

    public HistoryAttachment setFromId(Long fromId) {
        this.fromId = fromId;
        return this;
    }

    public Integer getMessageExpireTtl() {
        return messageExpireTtl;
    }

    public HistoryAttachment setMessageExpireTtl(Integer messageExpireTtl) {
        this.messageExpireTtl = messageExpireTtl;
        return this;
    }

    public Integer getMessageId() {
        return messageId;
    }

    public HistoryAttachment setMessageId(Integer messageId) {
        this.messageId = messageId;
        return this;
    }

    public Integer getPosition() {
        return position;
    }

    public HistoryAttachment setPosition(Integer position) {
        this.position = position;
        return this;
    }

    public Boolean getWasListened() {
        return wasListened;
    }

    public HistoryAttachment setWasListened(Boolean wasListened) {
        this.wasListened = wasListened;
        return this;
    }

    @Override
    public int hashCode() {
        return Objects.hash(date, attachment, messageExpireTtl, wasListened, messageId, cmid, position, fromId, forwardLevel);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        HistoryAttachment historyAttachment = (HistoryAttachment) o;
        return Objects.equals(date, historyAttachment.date) &&
                Objects.equals(fromId, historyAttachment.fromId) &&
                Objects.equals(attachment, historyAttachment.attachment) &&
                Objects.equals(messageExpireTtl, historyAttachment.messageExpireTtl) &&
                Objects.equals(wasListened, historyAttachment.wasListened) &&
                Objects.equals(messageId, historyAttachment.messageId) &&
                Objects.equals(cmid, historyAttachment.cmid) &&
                Objects.equals(position, historyAttachment.position) &&
                Objects.equals(forwardLevel, historyAttachment.forwardLevel);
    }

    @Override
    public String toString() {
        final Gson gson = new Gson();
        return gson.toJson(this);
    }

    public String toPrettyString() {
        final StringBuilder sb = new StringBuilder("HistoryAttachment{");
        sb.append("date=").append(date);
        sb.append(", fromId=").append(fromId);
        sb.append(", attachment=").append(attachment);
        sb.append(", messageExpireTtl=").append(messageExpireTtl);
        sb.append(", wasListened=").append(wasListened);
        sb.append(", messageId=").append(messageId);
        sb.append(", cmid=").append(cmid);
        sb.append(", position=").append(position);
        sb.append(", forwardLevel=").append(forwardLevel);
        sb.append('}');
        return sb.toString();
    }
}
