// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.objects.messages.responses;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import com.vk.api.sdk.objects.Validable;
import com.vk.api.sdk.objects.annotations.Required;
import com.vk.api.sdk.objects.base.BoolInt;
import com.vk.api.sdk.objects.messages.ChatPushSettings;
import com.vk.api.sdk.objects.messages.UserXtrInvitedBy;
import java.net.URI;
import java.util.List;
import java.util.Objects;

/**
 * GetChatFieldsResponse object
 */
public class GetChatFieldsResponse implements Validable {
    /**
     * Chat creator ID
     * Entity: owner
     */
    @SerializedName("admin_id")
    @Required
    private Long adminId;

    /**
     * Chat ID
     */
    @SerializedName("id")
    @Required
    private Integer id;

    /**
     * If provided photo is default
     */
    @SerializedName("is_default_photo")
    private Boolean isDefaultPhoto;

    /**
     * If chat is group channel
     */
    @SerializedName("is_group_channel")
    private Boolean isGroupChannel;

    /**
     * Shows that user has been kicked from the chat
     */
    @SerializedName("kicked")
    private BoolInt kicked;

    /**
     * Shows that user has been left the chat
     */
    @SerializedName("left")
    private BoolInt left;

    /**
     * Count members in a chat
     */
    @SerializedName("members_count")
    @Required
    private Integer membersCount;

    /**
     * URL of the preview image with 100 px in width
     */
    @SerializedName("photo_100")
    private URI photo100;

    /**
     * URL of the preview image with 200 px in width
     */
    @SerializedName("photo_200")
    private URI photo200;

    /**
     * URL of the preview image with 50 px in width
     */
    @SerializedName("photo_50")
    private URI photo50;

    @SerializedName("push_settings")
    private ChatPushSettings pushSettings;

    /**
     * Chat title
     */
    @SerializedName("title")
    private String title;

    /**
     * Chat type
     */
    @SerializedName("type")
    @Required
    private String type;

    @SerializedName("users")
    @Required
    private List<UserXtrInvitedBy> users;

    public Long getAdminId() {
        return adminId;
    }

    public GetChatFieldsResponse setAdminId(Long adminId) {
        this.adminId = adminId;
        return this;
    }

    public Integer getId() {
        return id;
    }

    public GetChatFieldsResponse setId(Integer id) {
        this.id = id;
        return this;
    }

    public Boolean getIsDefaultPhoto() {
        return isDefaultPhoto;
    }

    public GetChatFieldsResponse setIsDefaultPhoto(Boolean isDefaultPhoto) {
        this.isDefaultPhoto = isDefaultPhoto;
        return this;
    }

    public Boolean getIsGroupChannel() {
        return isGroupChannel;
    }

    public GetChatFieldsResponse setIsGroupChannel(Boolean isGroupChannel) {
        this.isGroupChannel = isGroupChannel;
        return this;
    }

    public boolean isKicked() {
        return kicked == BoolInt.YES;
    }

    public BoolInt getKicked() {
        return kicked;
    }

    public boolean isLeft() {
        return left == BoolInt.YES;
    }

    public BoolInt getLeft() {
        return left;
    }

    public Integer getMembersCount() {
        return membersCount;
    }

    public GetChatFieldsResponse setMembersCount(Integer membersCount) {
        this.membersCount = membersCount;
        return this;
    }

    public URI getPhoto100() {
        return photo100;
    }

    public GetChatFieldsResponse setPhoto100(URI photo100) {
        this.photo100 = photo100;
        return this;
    }

    public URI getPhoto200() {
        return photo200;
    }

    public GetChatFieldsResponse setPhoto200(URI photo200) {
        this.photo200 = photo200;
        return this;
    }

    public URI getPhoto50() {
        return photo50;
    }

    public GetChatFieldsResponse setPhoto50(URI photo50) {
        this.photo50 = photo50;
        return this;
    }

    public ChatPushSettings getPushSettings() {
        return pushSettings;
    }

    public GetChatFieldsResponse setPushSettings(ChatPushSettings pushSettings) {
        this.pushSettings = pushSettings;
        return this;
    }

    public String getTitle() {
        return title;
    }

    public GetChatFieldsResponse setTitle(String title) {
        this.title = title;
        return this;
    }

    public String getType() {
        return type;
    }

    public GetChatFieldsResponse setType(String type) {
        this.type = type;
        return this;
    }

    public List<UserXtrInvitedBy> getUsers() {
        return users;
    }

    public GetChatFieldsResponse setUsers(List<UserXtrInvitedBy> users) {
        this.users = users;
        return this;
    }

    @Override
    public int hashCode() {
        return Objects.hash(membersCount, photo50, kicked, photo200, title, type, users, photo100, left, isGroupChannel, adminId, pushSettings, id, isDefaultPhoto);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        GetChatFieldsResponse getChatFieldsResponse = (GetChatFieldsResponse) o;
        return Objects.equals(photo50, getChatFieldsResponse.photo50) &&
                Objects.equals(isDefaultPhoto, getChatFieldsResponse.isDefaultPhoto) &&
                Objects.equals(isGroupChannel, getChatFieldsResponse.isGroupChannel) &&
                Objects.equals(kicked, getChatFieldsResponse.kicked) &&
                Objects.equals(title, getChatFieldsResponse.title) &&
                Objects.equals(type, getChatFieldsResponse.type) &&
                Objects.equals(users, getChatFieldsResponse.users) &&
                Objects.equals(left, getChatFieldsResponse.left) &&
                Objects.equals(pushSettings, getChatFieldsResponse.pushSettings) &&
                Objects.equals(adminId, getChatFieldsResponse.adminId) &&
                Objects.equals(membersCount, getChatFieldsResponse.membersCount) &&
                Objects.equals(id, getChatFieldsResponse.id) &&
                Objects.equals(photo100, getChatFieldsResponse.photo100) &&
                Objects.equals(photo200, getChatFieldsResponse.photo200);
    }

    @Override
    public String toString() {
        final Gson gson = new Gson();
        return gson.toJson(this);
    }

    public String toPrettyString() {
        final StringBuilder sb = new StringBuilder("GetChatFieldsResponse{");
        sb.append("photo50=").append(photo50);
        sb.append(", isDefaultPhoto=").append(isDefaultPhoto);
        sb.append(", isGroupChannel=").append(isGroupChannel);
        sb.append(", kicked=").append(kicked);
        sb.append(", title='").append(title).append("'");
        sb.append(", type='").append(type).append("'");
        sb.append(", users=").append(users);
        sb.append(", left=").append(left);
        sb.append(", pushSettings=").append(pushSettings);
        sb.append(", adminId=").append(adminId);
        sb.append(", membersCount=").append(membersCount);
        sb.append(", id=").append(id);
        sb.append(", photo100=").append(photo100);
        sb.append(", photo200=").append(photo200);
        sb.append('}');
        return sb.toString();
    }
}
